/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.handler;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.deeplink.api.AbstractDeepLinkTypeHandler;
import org.eclipse.e4.core.deeplink.api.Activator;
import org.eclipse.e4.core.deeplink.handler.DeepLinkTypeHandlerFactory;
import org.eclipse.e4.core.deeplink.handler.DeepLinkTypeHandlerMapper;
import org.eclipse.e4.core.functionalprog.optionmonad.Option;

public class RequestHandler
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static DeepLinkTypeHandlerFactory typeHandlerFactory;

    public RequestHandler() {
        DeepLinkTypeHandlerMapper deepLinkTypeHandlerMapper = new DeepLinkTypeHandlerMapper(Platform.getExtensionRegistry());
        Map<String, AbstractDeepLinkTypeHandler> handlerMap = deepLinkTypeHandlerMapper.getMap();
        typeHandlerFactory = new DeepLinkTypeHandlerFactory(handlerMap);
    }

    RequestHandler(Map<String, AbstractDeepLinkTypeHandler> handlerMap) {
        typeHandlerFactory = new DeepLinkTypeHandlerFactory(handlerMap);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isRequestFromLocalhost(req)) {
            resp.sendError(403);
            return;
        }
        try {
            Option<AbstractDeepLinkTypeHandler> typeHandlerOption = typeHandlerFactory.createTypeHandler(req, resp);
            if (typeHandlerOption.hasValue()) {
                AbstractDeepLinkTypeHandler typeHandler = (AbstractDeepLinkTypeHandler)typeHandlerOption.get();
                typeHandler.doGet();
            } else {
                String message = "No deep link handler for URL path: " + req.getPathInfo();
                this.logInfo(message);
                this.returnErrorMessageToClient(message, resp);
            }
        }
        catch (Throwable t) {
            this.logUnhandledExceptionAndReturnResult(t, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isRequestFromLocalhost(req)) {
            resp.sendError(403);
            return;
        }
        try {
            Option<AbstractDeepLinkTypeHandler> typeHandlerOption = typeHandlerFactory.createTypeHandler(req, resp);
            if (typeHandlerOption.hasValue()) {
                AbstractDeepLinkTypeHandler typeHandler = (AbstractDeepLinkTypeHandler)typeHandlerOption.get();
                typeHandler.doPost();
            } else {
                String message = "No deep link handler for URL path: " + req.getPathInfo();
                this.logInfo(message);
                this.returnErrorMessageToClient(message, resp);
            }
        }
        catch (Throwable t) {
            this.logUnhandledExceptionAndReturnResult(t, resp);
        }
    }

    private boolean isRequestFromLocalhost(HttpServletRequest req) {
        String remoteHost = req.getRemoteHost();
        return "localhost".equalsIgnoreCase(remoteHost) || "127.0.0.1".equalsIgnoreCase(remoteHost);
    }

    private void logUnhandledExceptionAndReturnResult(Throwable t, HttpServletResponse response) {
        this.returnErrorMessageToClient(t.getMessage(), response);
        this.logException("Unhandled exception processing HTTP request: " + t.getMessage(), t);
    }

    private void returnErrorMessageToClient(String message, HttpServletResponse response) {
        response.setContentType("text/xml");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.println("<?xml version=\"1.0\"?>");
            out.println("<deeplink>");
            out.println("   <result exception=\"" + message + "\"/>");
            out.println("</deeplink>");
        }
        catch (IOException e) {
            this.logException("Unable to return error result to client: " + e.getMessage(), e);
        }
    }

    private void logException(String message, Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.core.deeplink.handler", message, t));
    }

    private void logInfo(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.core.deeplink.handler", message));
    }
}

