/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.examples.legacy.workbench;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.ui.examples.legacy.workbench.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.AbstractSplashHandler;

public class AnimationSplashHandler
extends AbstractSplashHandler {
    private Image imgProgressDark = null;
    private Image imgProgressLight = null;
    private GC shellGC;

    private void configureUISplash() {
        this.getSplash().setSize(480, 320);
        this.getSplash().setVisible(true);
    }

    public void init(Shell splash) {
        super.init(splash);
        this.loadImages();
        this.configureUISplash();
        splash.layout(true);
        this.shellGC = new GC((Drawable)this.getSplash());
    }

    private void loadImages() {
        ImageLoader loader = new ImageLoader();
        try {
            ImageData imageDataProgressDark = loader.load(Activator.getContext().getBundle().getEntry("splash/progress-dark.png").openStream())[0];
            ImageData imageDataProgressLight = loader.load(Activator.getContext().getBundle().getEntry("splash/progress-light.png").openStream())[0];
            this.imgProgressDark = new Image((Device)this.getSplash().getDisplay(), imageDataProgressDark);
            this.imgProgressLight = new Image((Device)this.getSplash().getDisplay(), imageDataProgressLight);
        }
        catch (IOException iOException) {}
    }

    public IProgressMonitor getBundleProgressMonitor() {
        return new BundleProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.shellGC != null) {
            GC gC = this.shellGC;
            synchronized (gC) {
                this.shellGC.dispose();
            }
        }
        if (this.imgProgressDark != null) {
            this.imgProgressDark.dispose();
        }
        if (this.imgProgressLight != null) {
            this.imgProgressLight.dispose();
        }
        super.dispose();
    }

    private final class BundleProgressMonitor
    extends NullProgressMonitor {
        private static final int NB_TICKS = 42;
        private int worked = 0;
        private int total = 0;

        private BundleProgressMonitor() {
        }

        public void worked(int work) {
            ++this.worked;
            this.updateProgressBar();
        }

        public void done() {
            this.worked = this.total;
            this.updateProgressBar();
        }

        public void beginTask(String name, int totalWork) {
            this.total = 19;
            this.updateProgressBar();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateProgressBar() {
            int currentImgIdx = (int)(42.0f / (float)this.total * (float)this.worked);
            int i = 0;
            while (i < 42) {
                Image imgToDraw = i <= currentImgIdx ? AnimationSplashHandler.this.imgProgressDark : AnimationSplashHandler.this.imgProgressLight;
                GC gC = AnimationSplashHandler.this.shellGC;
                synchronized (gC) {
                    AnimationSplashHandler.this.shellGC.drawImage(imgToDraw, 11 + 11 * i, 292);
                }
                ++i;
            }
        }
    }
}

