/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.menu.tests;

import junit.framework.TestCase;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.menu.tests.TestUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.menus.MenuPersistence;

public class MToolItemTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    private ToolBar getToolBar(Composite intermediate) {
        Control[] controlArray = intermediate.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData() instanceof ToolBarManager) {
                return (ToolBar)child;
            }
            ++n2;
        }
        return null;
    }

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.appContext);
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    public void test01Children() throws Exception {
        MToolBar toolbarModel = MenuFactoryImpl.eINSTANCE.createToolBar();
        toolbarModel.setElementId("p2.tb1");
        MToolBar toolbarModel2 = MenuFactoryImpl.eINSTANCE.createToolBar();
        toolbarModel2.setElementId("p2.tb2");
        MToolBarSeparator sep = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        sep.setElementId("additions");
        toolbarModel.getChildren().add(sep);
        MToolItemTest.assertEquals((int)1, (int)toolbarModel.getChildren().size());
        MToolItemTest.assertEquals((int)0, (int)toolbarModel2.getChildren().size());
        toolbarModel2.getChildren().addAll(toolbarModel.getChildren());
        MToolItemTest.assertEquals((int)0, (int)toolbarModel.getChildren().size());
        MToolItemTest.assertEquals((int)1, (int)toolbarModel2.getChildren().size());
    }

    public void testActionSetAddedToFile() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MTrimmedWindow window = (MTrimmedWindow)application.getChildren().get(0);
        MTrimBar coolbar = (MTrimBar)window.getTrimBars().get(0);
        MToolItemTest.assertNotNull((Object)coolbar);
        TestUtil.setupActionBuilderStructure(coolbar);
        MToolBar file = (MToolBar)coolbar.getChildren().get(1);
        MToolItemTest.assertEquals((int)5, (int)coolbar.getChildren().size());
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p3");
        mp.reRead();
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.appContext.get(ToolBarManagerRenderer.class);
        Shell shell = new Shell();
        Composite parent = new Composite((Composite)shell, 0);
        ToolBar toolbar = (ToolBar)renderer.createWidget((MUIElement)file, (Object)parent);
        MToolItemTest.assertNotNull((Object)toolbar);
        MToolBar obj = file;
        renderer.processContents((MElementContainer)obj);
        ToolBarManager tbm = renderer.getManager(file);
        MToolItemTest.assertNotNull((Object)tbm);
        IContributionItem[] tbItems = tbm.getItems();
        MToolItemTest.assertEquals((int)12, (int)tbItems.length);
        IContributionItem actionSetAction = tbItems[2];
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p3.toolAction1", (String)actionSetAction.getId());
        MToolItemTest.assertFalse((boolean)actionSetAction.isVisible());
        IEclipseContext windowContext = window.getContext();
        EContextService ecs = (EContextService)windowContext.get(EContextService.class);
        ecs.activateContext("org.eclipse.e4.ui.menu.tests.p3.toolSet");
        MToolItemTest.assertTrue((boolean)actionSetAction.isVisible());
        ecs.deactivateContext("org.eclipse.e4.ui.menu.tests.p3.toolSet");
        MToolItemTest.assertFalse((boolean)actionSetAction.isVisible());
    }

    public void testActionSetAddedToMyToolbar() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MTrimmedWindow window = (MTrimmedWindow)application.getChildren().get(0);
        MTrimBar coolbar = (MTrimBar)window.getTrimBars().get(0);
        MToolItemTest.assertNotNull((Object)coolbar);
        TestUtil.setupActionBuilderStructure(coolbar);
        int idx = 0;
        for (MTrimElement child : coolbar.getChildren()) {
            if (child.getElementId().equals("additions")) break;
            ++idx;
        }
        MToolBar toolbarModel = MenuFactoryImpl.eINSTANCE.createToolBar();
        toolbarModel.setElementId("p2.tb1");
        coolbar.getChildren().add(idx, toolbarModel);
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p2");
        mp.reRead();
        TestUtil.printContributions(application);
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.appContext.get(ToolBarManagerRenderer.class);
        Shell shell = new Shell();
        Composite parent = new Composite((Composite)shell, 0);
        ToolBar toolbar = (ToolBar)renderer.createWidget((MUIElement)toolbarModel, (Object)parent);
        MToolItemTest.assertNotNull((Object)toolbar);
        MToolBar obj = toolbarModel;
        renderer.processContents((MElementContainer)obj);
        ToolBarManager tbm = renderer.getManager(toolbarModel);
        MToolItemTest.assertNotNull((Object)tbm);
        IContributionItem[] tbItems = tbm.getItems();
        MToolItemTest.assertEquals((int)7, (int)tbItems.length);
        MToolItemTest.assertEquals((String)"group2", (String)tbItems[0].getId());
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.tb5", (String)tbItems[1].getId());
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.tb4", (String)tbItems[2].getId());
        MToolItemTest.assertEquals((String)"group1", (String)tbItems[3].getId());
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.tb3", (String)tbItems[4].getId());
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.tb2", (String)tbItems[5].getId());
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.tb1", (String)tbItems[6].getId());
    }

    public void testFileItemContributionVisibility() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MTrimmedWindow window = (MTrimmedWindow)application.getChildren().get(0);
        MTrimBar coolbar = (MTrimBar)window.getTrimBars().get(0);
        MToolItemTest.assertNotNull((Object)coolbar);
        TestUtil.setupActionBuilderStructure(coolbar);
        MToolBar file = (MToolBar)coolbar.getChildren().get(1);
        MToolItemTest.assertEquals((int)5, (int)coolbar.getChildren().size());
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p4");
        mp.reRead();
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.appContext.get(ToolBarManagerRenderer.class);
        Shell shell = new Shell();
        Composite parent = new Composite((Composite)shell, 0);
        ToolBar toolbar = (ToolBar)renderer.createWidget((MUIElement)file, (Object)parent);
        MToolItemTest.assertNotNull((Object)toolbar);
        MToolBar obj = file;
        renderer.processContents((MElementContainer)obj);
        ToolBarManager tbm = renderer.getManager(file);
        MToolItemTest.assertNotNull((Object)tbm);
        IContributionItem[] tbItems = tbm.getItems();
        MToolItemTest.assertEquals((int)12, (int)tbItems.length);
        IContributionItem p4InvOne = tbItems[8];
        MToolItemTest.assertEquals((String)"p4.invisible.commandOne", (String)p4InvOne.getId());
        MToolItemTest.assertFalse((boolean)p4InvOne.isVisible());
        IEclipseContext context = window.getContext();
        context.set("selection", (Object)new StructuredSelection((Object)"show.p4.invisible.commandOne"));
        MToolItemTest.assertTrue((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection(new Object[]{"show.p4.invisible.commandOne", "show.p4.invisible.commandOne"}));
        MToolItemTest.assertFalse((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection((Object)"show.p4.invisible.commandOne"));
        MToolItemTest.assertTrue((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection((Object)"hide.p4.invisible.commandOne"));
        MToolItemTest.assertFalse((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection((Object)"show.p4.invisible.commandOne"));
        MToolItemTest.assertTrue((boolean)p4InvOne.isVisible());
        context.remove("selection");
        MToolItemTest.assertFalse((boolean)p4InvOne.isVisible());
    }

    public void testFileItemGeneration() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MTrimmedWindow window = (MTrimmedWindow)application.getChildren().get(0);
        MTrimBar coolbar = (MTrimBar)window.getTrimBars().get(0);
        MToolItemTest.assertNotNull((Object)coolbar);
        TestUtil.setupActionBuilderStructure(coolbar);
        MToolBar file = (MToolBar)coolbar.getChildren().get(1);
        MToolItemTest.assertEquals((int)5, (int)coolbar.getChildren().size());
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p1");
        mp.reRead();
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.appContext.get(ToolBarManagerRenderer.class);
        Shell shell = new Shell();
        Composite parent = new Composite((Composite)shell, 0);
        ToolBar toolbar = (ToolBar)renderer.createWidget((MUIElement)file, (Object)parent);
        MToolItemTest.assertNotNull((Object)toolbar);
        MToolBar obj = file;
        renderer.processContents((MElementContainer)obj);
        ToolBarManager tbm = renderer.getManager(file);
        MToolItemTest.assertNotNull((Object)tbm);
        MToolItemTest.assertEquals((int)13, (int)tbm.getItems().length);
        IContributionItem saveAll = tbm.find("saveAll");
        MToolItemTest.assertNotNull((Object)saveAll);
        MToolItemTest.assertTrue((boolean)(saveAll instanceof DirectContributionItem));
        IContributionItem cmdTwo = tbm.getItems()[8];
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandTwo", (String)cmdTwo.getId());
        IContributionItem cmdOne = tbm.getItems()[12];
        MToolItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandOne", (String)cmdOne.getId());
    }

    public void testFileToolbarRendered() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MTrimmedWindow window = (MTrimmedWindow)application.getChildren().get(0);
        MTrimBar coolbar = (MTrimBar)window.getTrimBars().get(0);
        MToolItemTest.assertNotNull((Object)coolbar);
        TestUtil.setupActionBuilderStructure(coolbar);
        MToolBar file = (MToolBar)coolbar.getChildren().get(1);
        MToolItemTest.assertEquals((int)5, (int)coolbar.getChildren().size());
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.appContext.get(ToolBarManagerRenderer.class);
        Shell shell = new Shell();
        Composite parent = new Composite((Composite)shell, 0);
        ToolBar toolbar = (ToolBar)renderer.createWidget((MUIElement)file, (Object)parent);
        MToolItemTest.assertNotNull((Object)toolbar);
        MToolBar obj = file;
        renderer.processContents((MElementContainer)obj);
        ToolBarManager tbm = renderer.getManager(file);
        MToolItemTest.assertNotNull((Object)tbm);
        MToolItemTest.assertEquals((int)11, (int)tbm.getItems().length);
        IContributionItem saveAll = tbm.find("saveAll");
        MToolItemTest.assertNotNull((Object)saveAll);
        MToolItemTest.assertTrue((boolean)(saveAll instanceof DirectContributionItem));
    }

    public void testMToolItem_RadioItems() {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        MDirectToolItem toolItem1 = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        MDirectToolItem toolItem2 = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem1.setType(ItemType.RADIO);
        toolItem2.setType(ItemType.RADIO);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem1);
        toolBar.getChildren().add(toolItem2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget1 = toolItem1.getWidget();
        MToolItemTest.assertNotNull((Object)widget1);
        MToolItemTest.assertTrue((boolean)(widget1 instanceof ToolItem));
        Object widget2 = toolItem2.getWidget();
        MToolItemTest.assertNotNull((Object)widget2);
        MToolItemTest.assertTrue((boolean)(widget2 instanceof ToolItem));
        ToolItem toolItemWidget1 = (ToolItem)widget1;
        ToolItem toolItemWidget2 = (ToolItem)widget2;
        toolItemWidget1.setSelection(false);
        toolItemWidget2.setSelection(true);
        toolItemWidget1.notifyListeners(13, new Event());
        toolItemWidget2.notifyListeners(13, new Event());
        MToolItemTest.assertFalse((boolean)toolItem1.isSelected());
        MToolItemTest.assertTrue((boolean)toolItem2.isSelected());
        toolItemWidget2.setSelection(false);
        toolItemWidget1.setSelection(true);
        toolItemWidget2.notifyListeners(13, new Event());
        toolItemWidget1.notifyListeners(13, new Event());
        MToolItemTest.assertTrue((boolean)toolItem1.isSelected());
        MToolItemTest.assertFalse((boolean)toolItem2.isSelected());
        toolItem1.setSelected(false);
        MToolItemTest.assertFalse((boolean)toolItemWidget1.getSelection());
        toolItem2.setSelected(true);
        MToolItemTest.assertTrue((boolean)toolItemWidget2.getSelection());
    }

    private void testMToolItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem.setLabel(before);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = toolItem.getWidget();
        MToolItemTest.assertNotNull((Object)widget);
        MToolItemTest.assertTrue((boolean)(widget instanceof ToolItem));
        ToolItem toolItemWidget = (ToolItem)widget;
        MToolItemTest.assertEquals((String)beforeExpected, (String)toolItemWidget.getText());
        toolItem.setLabel(after);
        MToolItemTest.assertEquals((String)afterExpected, (String)toolItemWidget.getText());
    }

    public void testMToolItem_Text_EmptyEmpty() {
        this.testMToolItem_Text("", "", "", "");
    }

    public void testMToolItem_Text_EmptyNull() {
        this.testMToolItem_Text("", "", null, "");
    }

    public void testMToolItem_Text_EmptyString() {
        this.testMToolItem_Text("", "", "label", "label");
    }

    public void testMToolItem_Text_NullEmpty() {
        this.testMToolItem_Text(null, "", "", "");
    }

    public void testMToolItem_Text_NullNull() {
        this.testMToolItem_Text(null, "", null, "");
    }

    public void testMToolItem_Text_NullString() {
        this.testMToolItem_Text(null, "", "label", "label");
    }

    public void testMToolItem_Text_StringEmpty() {
        this.testMToolItem_Text("label", "label", "", "");
    }

    public void testMToolItem_Text_StringNull() {
        this.testMToolItem_Text("label", "label", null, "");
    }

    public void testMToolItem_Text_StringStringChanged() {
        this.testMToolItem_Text("label", "label", "label2", "label2");
    }

    public void testMToolItem_Text_StringStringUnchanged() {
        this.testMToolItem_Text("label", "label", "label", "label");
    }

    private void testMToolItem_Tooltip(String before, String beforeExpected, String after, String afterExpected) {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem.setTooltip(before);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = toolItem.getWidget();
        MToolItemTest.assertNotNull((Object)widget);
        MToolItemTest.assertTrue((boolean)(widget instanceof ToolItem));
        ToolItem toolItemWidget = (ToolItem)widget;
        MToolItemTest.assertEquals((String)beforeExpected, (String)toolItemWidget.getToolTipText());
        toolItem.setTooltip(after);
        MToolItemTest.assertEquals((String)afterExpected, (String)toolItemWidget.getToolTipText());
    }

    public void testMToolItem_Tooltip_EmptyEmpty() {
        this.testMToolItem_Tooltip("", "", "", "");
    }

    public void testMToolItem_Tooltip_EmptyNull() {
        this.testMToolItem_Tooltip("", "", null, null);
    }

    public void testMToolItem_Tooltip_EmptyString() {
        this.testMToolItem_Tooltip("", "", "toolTip", "toolTip");
    }

    public void testMToolItem_Tooltip_NullEmpty() {
        this.testMToolItem_Tooltip(null, null, "", "");
    }

    public void testMToolItem_Tooltip_NullNull() {
        this.testMToolItem_Tooltip(null, null, null, null);
    }

    public void testMToolItem_Tooltip_NullString() {
        this.testMToolItem_Tooltip(null, null, "toolTip", "toolTip");
    }

    public void testMToolItem_Tooltip_StringEmpty() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "", "");
    }

    public void testMToolItem_Tooltip_StringNull() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", null, null);
    }

    public void testMToolItem_Tooltip_StringStringChanged() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "toolTip2", "toolTip2");
    }

    public void testMToolItem_Tooltip_StringStringUnchanged() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "toolTip", "toolTip");
    }
}

