/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.controls.button;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.controls.button.Button_Alignment;
import org.eclipse.e4.xwt.tests.controls.button.Button_Enabled;
import org.eclipse.e4.xwt.tests.controls.button.Button_Styles;
import org.eclipse.e4.xwt.tests.controls.button.Button_Visible;
import org.eclipse.swt.widgets.Button;

public class ButtonTests
extends XWTTestCase {
    public void testButtonVisible() throws Exception {
        URL url = ButtonTests.class.getResource(String.valueOf(Button_Visible.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkButtonVisible();
                this.checkButtonNonVisible();
            }

            public void checkButtonVisible() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"buttonVisible");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue((boolean)button.getVisible());
            }

            public void checkButtonNonVisible() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"buttonNonVisible");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertFalse((boolean)button.getVisible());
            }
        });
    }

    public void testButtonAlignment() throws Exception {
        URL url = ButtonTests.class.getResource(String.valueOf(Button_Alignment.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkButtonLeft();
                this.checkButtonRight();
                this.checkButtonCenter();
            }

            public void checkButtonLeft() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"ButtonLeft");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue((button.getAlignment() == 16384 ? 1 : 0) != 0);
            }

            public void checkButtonRight() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"ButtonRight");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue((button.getAlignment() == 131072 ? 1 : 0) != 0);
            }

            public void checkButtonCenter() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"ButtonCenter");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue((button.getAlignment() == 0x1000000 ? 1 : 0) != 0);
            }
        });
    }

    public void testButtonEnabled() throws Exception {
        URL url = ButtonTests.class.getResource(String.valueOf(Button_Enabled.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkButtonEnabled();
                this.checkButtonNotEnabled();
            }

            public void checkButtonEnabled() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"EnabledButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue((boolean)button.isEnabled());
            }

            public void checkButtonNotEnabled() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"NotEnabledButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertFalse((boolean)button.isEnabled());
            }
        });
    }

    public void testButtonStyles() throws Exception {
        URL url = ButtonTests.class.getResource(String.valueOf(Button_Styles.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkPushButton();
                this.checkCheckButton();
                this.checkRadioButton();
                this.checkToggleButton();
                this.checkArrowButton();
                this.checkFlatButton();
            }

            public void checkPushButton() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"PushButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue(((button.getStyle() & 8) == 8 ? 1 : 0) != 0);
            }

            public void checkCheckButton() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"CheckButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue(((button.getStyle() & 0x20) == 32 ? 1 : 0) != 0);
            }

            public void checkRadioButton() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"RadioButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue(((button.getStyle() & 0x10) == 16 ? 1 : 0) != 0);
            }

            public void checkToggleButton() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"ToggleButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue(((button.getStyle() & 2) == 2 ? 1 : 0) != 0);
            }

            public void checkArrowButton() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"ArrowButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue(((button.getStyle() & 4) == 4 ? 1 : 0) != 0);
            }

            public void checkFlatButton() {
                Object element = XWT.findElementByName((Object)ButtonTests.this.root, (String)"FlatButton");
                ButtonTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ButtonTests.assertTrue(((button.getStyle() & 0x800000) == 0x800000 ? 1 : 0) != 0);
            }
        });
    }
}

