/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.databinding.ui;

import org.eclipse.e4.xwt.tools.ui.designer.databinding.CodeStyles;
import org.eclipse.e4.xwt.tools.ui.designer.databinding.ui.IGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CodeGenGroup
implements IGroup {
    private static final String STYLE_FLAT = "Flat";
    private static final String STYLE_TREE = "Tree";
    private static final String DATACONTEXT = "DataContext";
    private static final String STATICRESOURCE = "StaticResource";
    private static final String ATTRIBUTE_VALUE_FLAT = "<Label text=\"{Binding path=\"[PATH]\", mode=\"TwoWay\"}\">";
    private static final String ATTRIBUTE_VALUE_TREE = "<Lable.text>\n\r\t<Binding path=\"[PATH]\">\n\r\t\t<Binding.mode>TwoWay</Binding.mode>\n\r\t</Binding>\n\r</Lable.text>";
    private static final String CODE_DATACONTEXT = "<Shell DataContext=\"{StaticResource myData}\">\n\r\t<Shell.Resources>\n\r\t\t<y:Person x:key=\"myData\"/>\n\r\t</Shell.Resources>\n\r</Shell>\n<Label text=\"{Binding path=\"name\", mode=\"TwoWay\"}\">";
    private static final String CODE_STATICRESOURCE = "{Binding source=\"StaticResource myData\" path=\"name\"}";
    private Text bindingPreview;
    private Text pathPreview;
    private Button flatValueRadio;
    private Button treeValueRadio;
    private Button dataContextRadio;
    private Button staticResourceRadio;
    private CodeStyles codeStyles;

    public ExpandableComposite createGroup(final Composite parent, int style) {
        FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
        final ExpandableComposite result = formToolkit.createExpandableComposite(parent, 66);
        result.setText("Code Gen Settings");
        Composite cilent = formToolkit.createComposite((Composite)result);
        cilent.setLayout((Layout)new GridLayout());
        result.setClient((Control)cilent);
        result.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout(new Control[]{result});
            }
        });
        Group bindComp = new Group(cilent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        bindComp.setLayout((Layout)layout);
        bindComp.setLayoutData((Object)new GridData(1808));
        bindComp.setText("Code of Binding:");
        formToolkit.adapt((Composite)bindComp);
        this.flatValueRadio = formToolkit.createButton((Composite)bindComp, STYLE_FLAT, 16);
        this.flatValueRadio.setData((Object)STYLE_FLAT);
        this.flatValueRadio.setLayoutData((Object)new GridData(16384, 1024, false, true, 1, 1));
        this.bindingPreview = formToolkit.createText((Composite)bindComp, ATTRIBUTE_VALUE_FLAT, 2570);
        GridData layoutData = new GridData(4, 4, true, true, 1, 2);
        this.bindingPreview.setLayoutData((Object)layoutData);
        this.treeValueRadio = formToolkit.createButton((Composite)bindComp, STYLE_TREE, 16);
        this.treeValueRadio.setData((Object)STYLE_TREE);
        this.treeValueRadio.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
        Object listener = new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    CodeGenGroup.this.previewBindingCodes(event.widget.getData().toString());
                }
            }
        };
        this.flatValueRadio.addListener(13, listener);
        this.treeValueRadio.addListener(13, listener);
        Group pathComp = new Group(cilent, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        pathComp.setLayout((Layout)layout);
        pathComp.setLayoutData((Object)new GridData(1808));
        pathComp.setText("Code of Path:");
        formToolkit.adapt((Composite)pathComp);
        this.dataContextRadio = formToolkit.createButton((Composite)pathComp, DATACONTEXT, 16);
        this.dataContextRadio.setData((Object)DATACONTEXT);
        this.dataContextRadio.setLayoutData((Object)new GridData(16384, 1024, false, true, 1, 1));
        this.pathPreview = formToolkit.createText((Composite)pathComp, CODE_DATACONTEXT, 2570);
        layoutData = new GridData(4, 4, true, true, 1, 3);
        this.pathPreview.setLayoutData((Object)layoutData);
        this.staticResourceRadio = formToolkit.createButton((Composite)pathComp, STATICRESOURCE, 16);
        this.staticResourceRadio.setData((Object)STATICRESOURCE);
        this.staticResourceRadio.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
        listener = new Listener(){

            public void handleEvent(Event event) {
                CodeGenGroup.this.previewPathCodes(event.widget.getData().toString());
            }
        };
        this.dataContextRadio.addListener(13, listener);
        this.staticResourceRadio.addListener(13, listener);
        return result;
    }

    protected void previewPathCodes(String style) {
        if (DATACONTEXT.equals(style)) {
            this.pathPreview.setText(CODE_DATACONTEXT);
            this.getCodeStyles().useDataContext = true;
        } else if (STATICRESOURCE.equals(style)) {
            this.pathPreview.setText(CODE_STATICRESOURCE);
            this.getCodeStyles().useDataContext = false;
        }
    }

    protected void previewBindingCodes(String style) {
        if (STYLE_FLAT.equals(style)) {
            this.bindingPreview.setText(ATTRIBUTE_VALUE_FLAT);
            this.getCodeStyles().useFlatVlaue = true;
        } else if (STYLE_TREE.equals(style)) {
            this.bindingPreview.setText(ATTRIBUTE_VALUE_TREE);
            this.getCodeStyles().useFlatVlaue = false;
        }
    }

    public CodeStyles getCodeStyles() {
        if (this.codeStyles == null) {
            this.codeStyles = new CodeStyles();
        }
        return this.codeStyles;
    }

    public void setInput(Object input) {
        this.codeStyles = input != null && input instanceof CodeStyles ? (CodeStyles)input : new CodeStyles();
        this.previewCodeStyles();
    }

    private void previewCodeStyles() {
        CodeStyles settings = this.getCodeStyles();
        if (this.dataContextRadio != null || this.flatValueRadio != null) {
            this.flatValueRadio.setSelection(settings.useFlatVlaue);
            this.treeValueRadio.setSelection(!settings.useFlatVlaue);
            this.previewBindingCodes(settings.useFlatVlaue ? STYLE_FLAT : STYLE_TREE);
            this.dataContextRadio.setSelection(settings.useDataContext);
            this.previewPathCodes(settings.useDataContext ? DATACONTEXT : STATICRESOURCE);
        }
    }
}

