/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.swt.SwtBuilder;
import org.eclipse.e4.tm.stringconverter.StringConversion;
import org.eclipse.e4.tm.stringconverter.StringConverter;
import org.eclipse.e4.tm.stringconverters.SimpleObjectStringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverterTest
extends TestCase {
    private StringConversion stringConverter;
    private AbstractBuilder builder;
    private Display display;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new SwtBuilder();
        this.stringConverter = this.builder.getStringConverter();
        this.stringConverter.registerStringConverter(Class.class, (StringConverter)this.builder.getClassResolver());
        this.builder.getClassResolver().importPackage("org.eclipse.swt.widgets");
        this.builder.getClassResolver().importPackage("org.eclipse.swt.layout");
        this.display = Display.getDefault();
    }

    protected <T> void testStringConverter(Class<T> klass, String source, Object expected) {
        this.testStringConverter(klass, klass, source, expected);
    }

    protected <T> void testStringConverter(Class<T> type, Class<?> klass, String source, Object expected) {
        Object result = null;
        try {
            result = this.stringConverter.convert(source, type);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)expected, e.getClass());
        }
        if (!klass.isInstance(result)) {
            Assert.fail((String)(result + " is not of " + klass));
        }
        if (klass.isArray()) {
            int length = Array.getLength(result);
            int i = 0;
            while (i < length) {
                Assert.assertEquals((Object)Array.get(expected, i), (Object)Array.get(result, i));
                ++i;
            }
        } else if (!klass.isInstance(expected)) {
            Assert.assertEquals((String)expected.toString(), (String)result.toString());
        } else {
            Assert.assertEquals((Object)expected, (Object)result);
        }
    }

    public void testBooleanStringConverter() {
        this.testStringConverter(Boolean.TYPE, Boolean.class, "true", Boolean.TRUE);
        this.testStringConverter(Boolean.TYPE, Boolean.class, "false", Boolean.FALSE);
    }

    public void testIntStringConverter() {
        this.testStringConverter(Integer.TYPE, Integer.class, "0", new Integer(0));
        this.testStringConverter(Integer.TYPE, Integer.class, "10", new Integer(10));
    }

    public void testByteStringConverter() {
        this.testStringConverter(Byte.TYPE, Byte.class, "0", new Byte(0));
        this.testStringConverter(Byte.TYPE, Byte.class, "10", new Byte(10));
    }

    public void testDoubleStringConverter() {
        this.testStringConverter(Double.TYPE, Double.class, "1.2", new Double(1.2));
    }

    public void testLongStringConverter() {
        this.testStringConverter(Long.TYPE, Long.class, "0", new Long(0L));
    }

    public void testFloatStringConverter() {
        this.testStringConverter(Float.TYPE, Float.class, "1.2", new Float(1.2));
    }

    public void testStringStringConverter() {
        this.testStringConverter(String.class, "hello", "hello");
    }

    public void testStringArrayStringConverter() {
        this.testStringConverter(String[].class, "hello world", new String[]{"hello", "world"});
        this.testStringConverter(String[].class, "(hello, world)", new String[]{"hello", " world"});
        this.testStringConverter(String[].class, "[hello world]", new String[]{"hello", "world"});
        this.testStringConverter(String[].class, "{hello ;world}", new String[]{"hello ", "world"});
        this.testStringConverter(String[].class, "<hello | world>", new String[]{"hello ", " world"});
    }

    public void testStringBufferStringConverter() {
        this.testStringConverter(StringBuffer.class, "hello", "hello");
    }

    public void testIntArrayStringConverter() {
        this.testStringConverter(int[].class, "1 2 3", new int[]{1, 2, 3});
    }

    public void testByteArrayStringConverter() {
        this.testStringConverter(byte[].class, "1 2 3", new byte[]{1, 2, 3});
    }

    public void testRGBStringConverter() {
        this.testStringConverter(RGB.class, "0 1 2", new RGB(0, 1, 2));
        this.testStringConverter(RGB.class, "-1 128 256", new RGB(0, 128, 255));
        this.testStringConverter(RGB.class, "-1 256", new RGB(0, 255, 0));
        this.testStringConverter(RGB.class, "#00FFFF", new RGB(0, 255, 255));
    }

    public void testPointStringConverter() {
        this.testStringConverter(Point.class, "0 1", new Point(0, 1));
    }

    public void testRectangleStringConverter() {
        this.testStringConverter(Rectangle.class, "0 1 2 3", new Rectangle(0, 1, 2, 3));
    }

    private void testColorStringConverter(String colorString, Color c) {
        Color result = null;
        try {
            result = (Color)this.stringConverter.convert(colorString, Color.class);
            StringConverterTest.assertEquals((Object)c, (Object)result);
        }
        finally {
            if (result != null) {
                result.dispose();
            }
            c.dispose();
        }
    }

    public void testColorStringConverter() {
        this.testColorStringConverter("white", new Color((Device)this.display, 255, 255, 255));
        this.testColorStringConverter("red", new Color((Device)this.display, 255, 0, 0));
    }

    private void testFontStringConverter(String fontString, Font f) {
        Font result = null;
        try {
            result = (Font)this.stringConverter.convert(fontString, Font.class);
            Object[] fontData1 = result.getFontData();
            Object[] fontData2 = f.getFontData();
            StringConverterTest.assertTrue((boolean)Arrays.equals(fontData1, fontData2));
        }
        finally {
            if (result != null) {
                result.dispose();
            }
            f.dispose();
        }
    }

    public void testFontStringConverter() {
        this.testFontStringConverter("Times 12", new Font((Device)this.display, "Times", 12, 0));
        this.testFontStringConverter("bold italic Times 18", new Font((Device)this.display, "Times", 18, 3));
    }

    public void testURLStringConverter() {
        try {
            this.testStringConverter(URL.class, "http://www.news.com/", new URL("http://www.news.com/"));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void testClassStringConverter() {
        this.testStringConverter(Class.class, "int", Integer.TYPE);
        this.testStringConverter(Class.class, "int[]", int[].class);
        this.testStringConverter(Class.class, "Class", Class.class);
        this.testStringConverter(Class.class, "Class[]", Class[].class);
    }

    protected void testMethodStringConverter(String source, Class<?> klass, String methodName, Class<?>[] args) {
        Method m = null;
        try {
            m = klass.getMethod(methodName, args);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Assert.assertNotNull(m);
        this.testStringConverter(Method.class, source, m);
    }

    public void testSimpleObjectStringConverter() {
        this.stringConverter.registerStringConverter(RowData.class, (StringConverter)new SimpleObjectStringConverter());
        String source = "RowData {int: width = 50; int: height = 25; boolean: exclude = true;}";
        Object result = null;
        try {
            result = this.stringConverter.convert(source, RowData.class);
        }
        catch (Exception exception) {
            Assert.fail((String)("Couldn't create RowData from " + source));
        }
        Assert.assertNotNull((Object)result);
        RowData rowData = (RowData)result;
        Assert.assertEquals((int)50, (int)rowData.width);
        Assert.assertEquals((int)25, (int)rowData.height);
        Assert.assertTrue((boolean)rowData.exclude);
    }

    public static void main(String[] args) {
        TestRunner runner = new TestRunner();
        runner.doRun((Test)new TestSuite(StringConverterTest.class));
    }
}

