/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class StackDropAgent
extends DropAgent {
    private Rectangle tabArea;
    private MPartStack dropStack;
    private CTabFolder dropCTF;
    private ArrayList<Rectangle> itemRects;
    private int curDropIndex = -2;

    public StackDropAgent(DnDManager manager) {
        super(manager);
    }

    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        if (!(dragElement instanceof MStackElement) && !(dragElement instanceof MPartStack)) {
            return false;
        }
        if (!(info.curElement instanceof MPartStack)) {
            return false;
        }
        MPartStack stack = (MPartStack)info.curElement;
        if (!(stack.getWidget() instanceof CTabFolder)) {
            return false;
        }
        if (stack == dragElement) {
            return false;
        }
        Rectangle areaRect = this.getTabAreaRect((CTabFolder)stack.getWidget());
        boolean inArea = areaRect.contains(info.cursorPos);
        if (inArea) {
            this.tabArea = areaRect;
            this.dropStack = (MPartStack)info.curElement;
            this.dropCTF = (CTabFolder)this.dropStack.getWidget();
            this.createInsertRects();
        }
        return inArea;
    }

    private Rectangle getTabAreaRect(CTabFolder theCTF) {
        Rectangle ctfBounds = theCTF.getBounds();
        ctfBounds.height = theCTF.getTabHeight();
        Rectangle displayBounds = Display.getCurrent().map((Control)theCTF.getParent(), null, ctfBounds);
        return displayBounds;
    }

    private void createInsertRects() {
        this.itemRects = new ArrayList();
        if (this.dropCTF.getItems().length > 0) {
            CTabItem[] items = this.dropCTF.getItems();
            Rectangle itemRect = items[0].getBounds();
            int centerX = itemRect.x + itemRect.width / 2;
            itemRect.width /= 2;
            int curX = itemRect.x + itemRect.width;
            Rectangle insertRect = this.dropCTF.getDisplay().map((Control)this.dropCTF, null, itemRect);
            this.itemRects.add(insertRect);
            int i = 1;
            while (i < items.length) {
                itemRect = items[i].getBounds();
                centerX = itemRect.x + itemRect.width / 2;
                itemRect.width = centerX - curX;
                itemRect.x = curX;
                curX = centerX;
                insertRect = this.dropCTF.getDisplay().map((Control)this.dropCTF, null, itemRect);
                this.itemRects.add(insertRect);
                ++i;
            }
            itemRect.x = curX;
            itemRect.width = this.dropCTF.getBounds().width - curX;
            insertRect = this.dropCTF.getDisplay().map((Control)this.dropCTF, null, itemRect);
            this.itemRects.add(insertRect);
        } else {
            this.itemRects.add(this.tabArea);
        }
    }

    private int getDropIndex(DnDInfo info) {
        if (this.itemRects == null) {
            return -1;
        }
        for (Rectangle itemRect : this.itemRects) {
            if (!itemRect.contains(info.cursorPos)) continue;
            return this.itemRects.indexOf(itemRect);
        }
        return -1;
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        this.dndManager.clearOverlay();
        if (this.dndManager.getFeedbackStyle() == 1) {
            if (dragElement.getParent() != null) {
                this.dndManager.hostElement(dragElement, 16, 10);
            }
        } else {
            this.dndManager.setHostBounds(null);
        }
        this.tabArea = null;
        this.curDropIndex = -2;
        super.dragLeave(dragElement, info);
    }

    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (!this.tabArea.contains(info.cursorPos) || this.dropStack == null || !this.dropStack.isToBeRendered()) {
            return false;
        }
        int dropIndex = this.getDropIndex(info);
        if (this.curDropIndex == dropIndex || dropIndex == -1) {
            return true;
        }
        this.curDropIndex = dropIndex;
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
        if (this.dropStack.getChildren().indexOf(dragElement) == dropIndex) {
            return true;
        }
        if (this.dndManager.getFeedbackStyle() == 1) {
            this.dock(dragElement, dropIndex);
            Display.getCurrent().update();
            this.showFrame(dragElement);
        } else {
            Rectangle itemBounds;
            if (dropIndex < this.dropCTF.getItemCount()) {
                itemBounds = this.dropCTF.getItem(dropIndex).getBounds();
                itemBounds.width = 2;
                itemBounds = Display.getCurrent().map((Control)this.dropCTF, null, itemBounds);
                this.dndManager.frameRect(itemBounds);
            } else if (this.dropCTF.getItemCount() > 0) {
                itemBounds = this.dropCTF.getItem(dropIndex - 1).getBounds();
                itemBounds.x += itemBounds.width;
                itemBounds.width = 2;
                itemBounds = Display.getCurrent().map((Control)this.dropCTF, null, itemBounds);
                this.dndManager.frameRect(itemBounds);
            } else {
                Rectangle fr = new Rectangle(this.tabArea.x, this.tabArea.y, this.tabArea.width, this.tabArea.height);
                fr.width = 2;
                this.dndManager.frameRect(fr);
            }
            if (this.dndManager.getFeedbackStyle() == 2) {
                Rectangle ca = this.dropCTF.getClientArea();
                ca = Display.getCurrent().map((Control)this.dropCTF, null, ca);
                this.dndManager.setHostBounds(ca);
            }
        }
        return true;
    }

    private void dock(MUIElement dragElement, int dropIndex) {
        int elementIndex = this.dropStack.getChildren().indexOf(dragElement);
        if (elementIndex != -1 && !(dragElement instanceof MPartStack)) {
            Control dragCtrl = (Control)dragElement.getWidget();
            CTabItem[] cTabItemArray = this.dropCTF.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                int itemIndex;
                CTabItem cti = cTabItemArray[n2];
                if (dragCtrl == cti.getControl() && (itemIndex = this.dropCTF.indexOf(cti)) <= dropIndex) {
                    --dropIndex;
                }
                ++n2;
            }
        }
        if (dropIndex < this.dropCTF.getItemCount()) {
            CTabItem item = this.dropCTF.getItem(dropIndex);
            MUIElement itemModel = (MUIElement)item.getData("modelElement");
            if (itemModel == dragElement) {
                return;
            }
            dropIndex = itemModel.getParent().getChildren().indexOf(itemModel);
        }
        if (dragElement instanceof MStackElement) {
            if (dragElement.getParent() != null) {
                dragElement.getParent().getChildren().remove(dragElement);
            }
            if (dropIndex >= 0 && dropIndex < this.dropStack.getChildren().size()) {
                this.dropStack.getChildren().add(dropIndex, (MStackElement)dragElement);
            } else {
                this.dropStack.getChildren().add((MStackElement)dragElement);
            }
            this.dropStack.setSelectedElement((MUIElement)((MStackElement)dragElement));
        } else {
            MPartStack stack = (MPartStack)dragElement;
            MStackElement curSel = (MStackElement)stack.getSelectedElement();
            List kids = stack.getChildren();
            while (kids.size() > 0) {
                MStackElement lastChild = (MStackElement)kids.remove(kids.size() - 1);
                if (dropIndex >= 0 && dropIndex < this.dropStack.getChildren().size()) {
                    this.dropStack.getChildren().add(dropIndex, lastChild);
                    continue;
                }
                this.dropStack.getChildren().add(lastChild);
            }
            this.dropStack.setSelectedElement((MUIElement)curSel);
        }
    }

    private void showFrame(MUIElement dragElement) {
        CTabFolder ctf = (CTabFolder)this.dropStack.getWidget();
        CTabItem[] items = ctf.getItems();
        CTabItem item = null;
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == dragElement) {
                item = items[i];
                break;
            }
            ++i;
        }
        Rectangle bounds = item.getBounds();
        bounds = Display.getCurrent().map((Control)this.dropCTF, null, bounds);
        Rectangle outerBounds = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        this.dndManager.frameRect(outerBounds);
    }

    public boolean drop(MUIElement dragElement, DnDInfo info) {
        int dropIndex;
        if (this.dndManager.getFeedbackStyle() != 1 && (dropIndex = this.getDropIndex(info)) != -1) {
            this.dock(dragElement, dropIndex);
        }
        return true;
    }
}

