/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Testable;
import org.eclipse.e4.ui.internal.workbench.swt.ResourceUtility;
import org.eclipse.e4.ui.internal.workbench.swt.ShellActivationListener;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.testing.TestableObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartRenderingEngine
implements IPresentationEngine {
    public static final String engineURI = "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
    private static final String defaultFactoryUrl = "platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/org.eclipse.e4.ui.workbench.renderers.swt.WorkbenchRendererFactory";
    private String factoryUrl;
    IRendererFactory curFactory = null;
    Listener keyListener;
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            MElementContainer parent = changedElement.getParent();
            if (parent == null) {
                parent = (MElementContainer)((EObject)changedElement).eContainer();
            }
            boolean menuChild = parent instanceof MMenu;
            if (!(parent instanceof MApplication) && (parent == null || parent.getWidget() == null || menuChild)) {
                return;
            }
            if (changedElement.isToBeRendered()) {
                Activator.trace((String)"/trace/renderer", (String)"visible -> true", null);
                Object w = PartRenderingEngine.this.createGui(changedElement);
                if (w instanceof Control && !(w instanceof Shell)) {
                    PartRenderingEngine.this.fixZOrder(changedElement);
                }
            } else {
                Activator.trace((String)"/trace/renderer", (String)"visible -> false", null);
                if (parent.getSelectedElement() == changedElement) {
                    parent.setSelectedElement(null);
                }
                PartRenderingEngine.this.removeGui(changedElement);
            }
        }
    };
    private EventHandler visibilityHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            MElementContainer parent = changedElement.getParent();
            if (parent == null && (parent = (MUIElement)((EObject)changedElement).eContainer()) == null) {
                return;
            }
            AbstractPartRenderer renderer = (AbstractPartRenderer)parent.getRenderer();
            if (renderer == null) {
                return;
            }
            if (changedElement.isVisible()) {
                if (changedElement.isToBeRendered()) {
                    if (changedElement.getWidget() instanceof Control) {
                        Composite realComp = (Composite)renderer.getUIContainer(changedElement);
                        Control ctrl = (Control)changedElement.getWidget();
                        ctrl.setParent(realComp);
                        PartRenderingEngine.this.fixZOrder(changedElement);
                    }
                    if (parent instanceof MElementContainer) {
                        renderer.childRendered((MElementContainer<MUIElement>)parent, changedElement);
                    }
                }
            } else {
                if (changedElement.getWidget() instanceof Control) {
                    Control ctrl = (Control)changedElement.getWidget();
                    ctrl.setParent((Composite)PartRenderingEngine.this.getLimboShell());
                }
                if (parent instanceof MElementContainer) {
                    renderer.hideChild((MElementContainer<MUIElement>)parent, changedElement);
                }
            }
        }
    };
    private EventHandler trimHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement removed;
            Object changedObj = event.getProperty("ChangedElement");
            if (!(changedObj instanceof MTrimmedWindow)) {
                return;
            }
            MTrimmedWindow window = (MTrimmedWindow)changedObj;
            if (window.getWidget() == null) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType)) {
                MUIElement added = (MUIElement)event.getProperty("NewValue");
                if (added.isToBeRendered()) {
                    PartRenderingEngine.this.createGui(added, window.getWidget(), window.getContext());
                }
            } else if ("REMOVE".equals(eventType) && (removed = (MUIElement)event.getProperty("OldValue")).getRenderer() != null) {
                PartRenderingEngine.this.removeGui(removed);
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            if (!(changedObj instanceof MElementContainer)) {
                return;
            }
            MElementContainer changedElement = (MElementContainer)changedObj;
            boolean isApplication = changedObj instanceof MApplication;
            boolean menuChild = changedObj instanceof MMenu;
            AbstractPartRenderer renderer = PartRenderingEngine.this.getRendererFor((MUIElement)changedElement);
            if (!isApplication && renderer == null || menuChild) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType)) {
                int newLocation;
                boolean renderIt;
                Activator.trace((String)"/trace/renderer", (String)"Child Added", null);
                MUIElement added = (MUIElement)event.getProperty("NewValue");
                boolean isStack = changedObj instanceof MGenericStack;
                boolean hasWidget = added.getWidget() != null;
                boolean isSelected = added == changedElement.getSelectedElement();
                boolean bl = renderIt = !isStack || hasWidget || isSelected;
                if (renderIt) {
                    Object w = PartRenderingEngine.this.createGui(added);
                    if (w instanceof Control && !(w instanceof Shell)) {
                        Control ctrl = (Control)w;
                        PartRenderingEngine.this.fixZOrder(added);
                        if (!ctrl.isDisposed()) {
                            ctrl.getShell().layout(new Control[]{ctrl}, 4);
                        }
                    }
                } else if (renderer != null && added.isToBeRendered()) {
                    renderer.childRendered((MElementContainer<MUIElement>)changedElement, added);
                }
                if ((newLocation = PartRenderingEngine.this.modelService.getElementLocation(added)) == 8 || newLocation == 1) {
                    MWindow topWin = PartRenderingEngine.this.modelService.getTopLevelWindowFor(added);
                    PartRenderingEngine.this.modelService.hideLocalPlaceholders(topWin, null);
                }
            } else if ("REMOVE".equals(eventType)) {
                Activator.trace((String)"/trace/renderer", (String)"Child Removed", null);
                MUIElement removed = (MUIElement)event.getProperty("OldValue");
                if (!removed.isToBeRendered()) {
                    return;
                }
                if (removed.getWidget() instanceof Control) {
                    Control ctrl = (Control)removed.getWidget();
                    ctrl.setLayoutData(null);
                    ctrl.getParent().layout(new Control[]{ctrl}, 6);
                }
                if (changedElement.getSelectedElement() == removed) {
                    changedElement.setSelectedElement(null);
                }
                if (renderer != null) {
                    renderer.hideChild((MElementContainer<MUIElement>)changedElement, removed);
                }
            }
        }
    };
    private EventHandler windowsHandler = new EventHandler(){

        public void handleEvent(Event event) {
            PartRenderingEngine.this.childrenHandler.handleEvent(event);
        }
    };
    private IEclipseContext appContext;
    protected Shell testShell;
    protected MApplication theApp;
    @Inject
    @Optional
    protected IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    protected Logger logger;
    private Shell limbo;
    private List<MUIElement> renderedElements = new ArrayList<MUIElement>();
    private MUIElement removeRoot = null;

    @Inject
    public PartRenderingEngine(@Named(value="rendererFactoryUri") @Optional String factoryUrl) {
        if (factoryUrl == null) {
            factoryUrl = defaultFactoryUrl;
        }
        this.factoryUrl = factoryUrl;
    }

    protected void fixZOrder(MUIElement element) {
        Composite composite;
        EObject container;
        MElementContainer parent = element.getParent();
        if (parent == null && (container = ((EObject)element).eContainer()) instanceof MElementContainer) {
            parent = (MElementContainer)container;
        }
        if (parent == null || !(element.getWidget() instanceof Control)) {
            return;
        }
        Control elementCtrl = (Control)element.getWidget();
        Control prevCtrl = null;
        for (MUIElement kid : parent.getChildren()) {
            if (kid == element) {
                if (prevCtrl != null) {
                    elementCtrl.moveBelow(prevCtrl);
                    break;
                }
                elementCtrl.moveAbove(null);
                break;
            }
            if (!(kid.getWidget() instanceof Control)) continue;
            prevCtrl = (Control)kid.getWidget();
        }
        Object widget = parent.getWidget();
        if (widget instanceof Composite && (composite = (Composite)widget).getShell() == elementCtrl.getShell()) {
            Composite temp = elementCtrl.getParent();
            while (temp != composite) {
                if (temp == null) {
                    return;
                }
                temp = temp.getParent();
            }
            composite.layout(new Control[]{elementCtrl});
        }
    }

    @PostConstruct
    void initialize(IEclipseContext context) {
        this.appContext = context;
        KeyFormatterFactory.setDefault((IKeyFormatter)SWTKeySupport.getKeyFormatterForPlatform());
        context.set(IPresentationEngine.class.getName(), (Object)this);
        IRendererFactory factory = null;
        IContributionFactory contribFactory = (IContributionFactory)context.get(IContributionFactory.class);
        try {
            factory = (IRendererFactory)contribFactory.create(this.factoryUrl, context);
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Could not create rendering factory");
        }
        if (factory == null) {
            try {
                factory = (IRendererFactory)contribFactory.create(defaultFactoryUrl, context);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Could not create default rendering factory");
            }
        }
        if (factory == null) {
            throw new IllegalStateException("Could not create any rendering factory. Aborting ...");
        }
        this.curFactory = factory;
        context.set(IRendererFactory.class, (Object)this.curFactory);
        if (this.eventBroker != null) {
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"visible"), this.visibilityHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/basic/Window", (String)"windows"), this.windowsHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/advanced/Perspective", (String)"windows"), this.windowsHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/basic/TrimmedWindow", (String)"trimBars"), this.trimHandler);
        }
    }

    @PreDestroy
    void contextDisposed() {
        if (this.eventBroker == null) {
            return;
        }
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.visibilityHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.trimHandler);
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            PartRenderingEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    private String getContextName(MUIElement element) {
        StringBuilder builder = new StringBuilder(element.getClass().getSimpleName());
        String elementId = element.getElementId();
        if (elementId != null && elementId.length() != 0) {
            builder.append(" (").append(elementId).append(") ");
        }
        builder.append("Context");
        return builder.toString();
    }

    public Object createGui(final MUIElement element, final Object parentWidget, final IEclipseContext parentContext) {
        final Object[] gui = new Object[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (PartRenderingEngine.this.logger != null) {
                    String message = "Exception occurred while rendering: {0}";
                    PartRenderingEngine.this.logger.error(e, NLS.bind((String)message, (Object)element));
                }
            }

            public void run() throws Exception {
                gui[0] = PartRenderingEngine.this.safeCreateGui(element, parentWidget, parentContext);
            }
        });
        return gui[0];
    }

    public Object safeCreateGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
        MContext ctxt;
        IEclipseContext lclContext;
        Object newWidget;
        MContext ctxt2;
        if (!element.isToBeRendered()) {
            return null;
        }
        if (!this.renderedElements.contains(element)) {
            this.renderedElements.add(element);
        }
        if (this.removeRoot != null) {
            return null;
        }
        Object currentWidget = element.getWidget();
        if (currentWidget != null) {
            MElementContainer parentElement;
            AbstractPartRenderer parentRenderer;
            if (currentWidget instanceof Control) {
                Composite currentParent;
                Control control = (Control)currentWidget;
                control.setVisible(true);
                if (parentWidget instanceof Composite && (currentParent = control.getParent()) != parentWidget) {
                    CTabFolder folder;
                    if (currentParent instanceof CTabFolder && (folder = (CTabFolder)currentParent).getTopRight() == control) {
                        folder.setTopRight(null);
                    }
                    control.setParent((Composite)parentWidget);
                }
            }
            if (element.getParent() instanceof MUIElement && (parentRenderer = this.getRendererFor((MUIElement)(parentElement = element.getParent()))) != null) {
                parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, element);
            }
            return element.getWidget();
        }
        if (element instanceof MContext && (ctxt2 = (MContext)element).getContext() == null) {
            IEclipseContext lclContext2 = parentContext.createChild(this.getContextName(element));
            PartRenderingEngine.populateModelInterfaces(ctxt2, lclContext2, element.getClass().getInterfaces());
            ctxt2.setContext(lclContext2);
            for (String variable : ctxt2.getVariables()) {
                lclContext2.declareModifiable(variable);
            }
            Map props = ctxt2.getProperties();
            for (String key : props.keySet()) {
                lclContext2.set(key, props.get(key));
            }
            E4Workbench.processHierarchy((Object)element);
        }
        if ((newWidget = this.createWidget(element, parentWidget)) != null) {
            MElementContainer parentElement;
            AbstractPartRenderer parentRenderer;
            AbstractPartRenderer renderer = this.getRendererFor(element);
            renderer.hookControllerLogic(element);
            if (element instanceof MElementContainer) {
                renderer.processContents((MElementContainer<MUIElement>)((MElementContainer)element));
            }
            renderer.postProcess(element);
            if (element.getParent() instanceof MUIElement && (parentRenderer = this.getRendererFor((MUIElement)(parentElement = element.getParent()))) != null) {
                parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, element);
            }
        } else if (element instanceof MContext && (lclContext = (ctxt = (MContext)element).getContext()) != null) {
            lclContext.dispose();
            ctxt.setContext(null);
        }
        return newWidget;
    }

    private IEclipseContext getContext(MUIElement parent) {
        if (parent instanceof MContext) {
            return ((MContext)parent).getContext();
        }
        return this.modelService.getContainingContext(parent);
    }

    public Object createGui(final MUIElement element) {
        final Object[] gui = new Object[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (PartRenderingEngine.this.logger != null) {
                    String message = "Exception occurred while rendering: {0}";
                    PartRenderingEngine.this.logger.error(e, NLS.bind((String)message, (Object)element));
                }
            }

            public void run() throws Exception {
                gui[0] = PartRenderingEngine.this.safeCreateGui(element);
            }
        });
        return gui[0];
    }

    private Object safeCreateGui(MUIElement element) {
        AbstractPartRenderer renderer;
        Object parent = null;
        MElementContainer parentME = element.getParent();
        if (parentME == null) {
            parentME = (MUIElement)((EObject)element).eContainer();
        }
        if (parentME != null && (renderer = this.getRendererFor((MUIElement)parentME)) != null) {
            parent = !element.isVisible() ? this.getLimboShell() : renderer.getUIContainer(element);
        }
        IEclipseContext parentContext = null;
        if (element.getCurSharedRef() != null) {
            MPlaceholder ph = element.getCurSharedRef();
            parentContext = this.getContext((MUIElement)ph.getParent());
        } else if (parentContext == null && element.getParent() != null) {
            parentContext = this.getContext((MUIElement)element.getParent());
        } else if (parentContext == null && element.getParent() == null) {
            parentContext = this.getContext((MUIElement)((EObject)element).eContainer());
        }
        return this.safeCreateGui(element, parent, parentContext);
    }

    private Shell getLimboShell() {
        if (this.limbo == null) {
            this.limbo = new Shell(Display.getCurrent(), 0);
            this.limbo.setBackgroundMode(1);
            this.limbo.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        }
        return this.limbo;
    }

    public void removeGui(final MUIElement element) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (PartRenderingEngine.this.logger != null) {
                    String message = "Exception occurred while unrendering: {0}";
                    PartRenderingEngine.this.logger.error(e, NLS.bind((String)message, (Object)element));
                }
            }

            public void run() throws Exception {
                PartRenderingEngine.this.safeRemoveGui(element);
            }
        });
    }

    private void safeRemoveGui(MUIElement element) {
        AbstractPartRenderer renderer;
        AbstractPartRenderer parentRenderer;
        if (this.removeRoot == null) {
            this.removeRoot = element;
        }
        this.renderedElements.remove(element);
        MElementContainer parent = element.getParent();
        AbstractPartRenderer abstractPartRenderer = parentRenderer = parent != null ? this.getRendererFor((MUIElement)parent) : null;
        if (parentRenderer != null) {
            parentRenderer.hideChild((MElementContainer<MUIElement>)element.getParent(), element);
        }
        if ((renderer = this.getRendererFor(element)) != null) {
            if (element instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)element;
                MUIElement selectedElement = container.getSelectedElement();
                Iterator children = container.getChildren();
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    MUIElement child = (MUIElement)iterator.next();
                    if (child == selectedElement) continue;
                    this.removeGui(child);
                }
                if (selectedElement != null && children.contains(selectedElement)) {
                    this.removeGui(selectedElement);
                }
            }
            if (element instanceof MPerspective) {
                MPerspective perspective = (MPerspective)element;
                for (MWindow subWindow : perspective.getWindows()) {
                    this.removeGui((MUIElement)subWindow);
                }
            } else if (element instanceof MWindow) {
                MWindow window = (MWindow)element;
                for (MWindow subWindow : window.getWindows()) {
                    this.removeGui((MUIElement)subWindow);
                }
                if (window instanceof MTrimmedWindow) {
                    MTrimmedWindow trimmedWindow = (MTrimmedWindow)window;
                    for (MUIElement trimBar : trimmedWindow.getTrimBars()) {
                        this.removeGui(trimBar);
                    }
                }
            }
            renderer.disposeWidget(element);
            if (element instanceof MContribution) {
                MContribution contribution;
                block19: {
                    contribution = (MContribution)element;
                    Object client = contribution.getObject();
                    IEclipseContext parentContext = renderer.getContext(element);
                    if (parentContext != null && client != null) {
                        try {
                            ContextInjectionFactory.uninject((Object)client, (IEclipseContext)parentContext);
                        }
                        catch (Exception e) {
                            if (this.logger == null) break block19;
                            this.logger.error((Throwable)e);
                        }
                    }
                }
                contribution.setObject(null);
            }
            if (element instanceof MContext) {
                this.clearContext((MContext)element);
            }
        }
        if (this.removeRoot == element) {
            this.removeRoot = null;
        }
    }

    private void clearContext(MContext contextME) {
        MContext ctxt = contextME;
        IEclipseContext lclContext = ctxt.getContext();
        if (lclContext != null) {
            IEclipseContext parentContext = lclContext.getParent();
            IEclipseContext child = parentContext.getActiveChild();
            if (child == lclContext) {
                child.deactivate();
            }
            ctxt.setContext(null);
            lclContext.dispose();
        }
    }

    protected Object createWidget(MUIElement element, Object parent) {
        AbstractPartRenderer renderer = this.getRenderer(element, parent);
        if (renderer != null) {
            element.setRenderer((Object)renderer);
            Object newWidget = renderer.createWidget(element, parent);
            if (newWidget != null) {
                renderer.bindWidget(element, newWidget);
                return newWidget;
            }
        }
        return null;
    }

    private AbstractPartRenderer getRenderer(MUIElement uiElement, Object parent) {
        return this.curFactory.getRenderer(uiElement, parent);
    }

    protected AbstractPartRenderer getRendererFor(MUIElement element) {
        return (AbstractPartRenderer)element.getRenderer();
    }

    public Object run(final MApplicationElement uiRoot, final IEclipseContext runContext) {
        Display display;
        if (runContext.get(Display.class) != null) {
            display = (Display)runContext.get(Display.class);
        } else {
            display = Display.getDefault();
            runContext.set(Display.class, (Object)display);
        }
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                TestableObject testableObject;
                PartRenderingEngine.initializeStyling(display, runContext);
                runContext.set(IResourceUtilities.class.getName(), (Object)new ResourceUtility());
                KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)runContext);
                runContext.set(KeyBindingDispatcher.class.getName(), (Object)dispatcher);
                PartRenderingEngine.this.keyListener = dispatcher.getKeyDownFilter();
                display.addFilter(1, PartRenderingEngine.this.keyListener);
                display.addFilter(31, PartRenderingEngine.this.keyListener);
                Shell limbo = PartRenderingEngine.this.getLimboShell();
                runContext.set("limbo", (Object)limbo);
                PartRenderingEngine.this.testShell = null;
                PartRenderingEngine.this.theApp = null;
                boolean spinOnce = true;
                if (uiRoot instanceof MApplication) {
                    ShellActivationListener shellDialogListener = new ShellActivationListener((MApplication)uiRoot);
                    display.addFilter(26, (Listener)shellDialogListener);
                    display.addFilter(27, (Listener)shellDialogListener);
                    spinOnce = false;
                    PartRenderingEngine.this.theApp = (MApplication)uiRoot;
                    MWindow selected = (MWindow)PartRenderingEngine.this.theApp.getSelectedElement();
                    if (selected == null) {
                        for (MWindow window : PartRenderingEngine.this.theApp.getChildren()) {
                            PartRenderingEngine.this.createGui((MUIElement)window);
                        }
                    } else {
                        PartRenderingEngine.this.createGui((MUIElement)selected);
                        for (MWindow window : PartRenderingEngine.this.theApp.getChildren()) {
                            if (selected == window) continue;
                            PartRenderingEngine.this.createGui((MUIElement)window);
                        }
                    }
                    IApplicationContext ac = (IApplicationContext)PartRenderingEngine.this.appContext.get(IApplicationContext.class);
                    if (ac != null) {
                        ac.applicationRunning();
                    }
                } else if (uiRoot instanceof MUIElement) {
                    if (uiRoot instanceof MWindow) {
                        PartRenderingEngine.this.testShell = (Shell)PartRenderingEngine.this.createGui((MUIElement)uiRoot);
                    } else {
                        PartRenderingEngine.this.testShell = new Shell(display, 1264);
                        PartRenderingEngine.this.createGui((MUIElement)uiRoot, PartRenderingEngine.this.testShell, null);
                    }
                }
                if ((testableObject = (TestableObject)runContext.get(TestableObject.class.getName())) instanceof E4Testable) {
                    ((E4Testable)testableObject).init(display, (IWorkbench)runContext.get(IWorkbench.class.getName()));
                }
                while ((PartRenderingEngine.this.testShell != null && !PartRenderingEngine.this.testShell.isDisposed() || !PartRenderingEngine.this.theApp.getChildren().isEmpty() && PartRenderingEngine.this.someAreVisible(PartRenderingEngine.this.theApp.getChildren())) && !display.isDisposed()) {
                    try {
                        if (display.readAndDispatch()) continue;
                        runContext.processWaiting();
                        if (spinOnce) {
                            return;
                        }
                        display.sleep();
                    }
                    catch (ThreadDeath th) {
                        throw th;
                    }
                    catch (Exception ex) {
                        this.handle(ex, runContext);
                    }
                    catch (Error err) {
                        this.handle(err, runContext);
                    }
                }
                if (!spinOnce) {
                    PartRenderingEngine.this.cleanUp();
                }
            }

            private void handle(Throwable ex, IEclipseContext appContext) {
                try {
                    this.safeHandle(ex, appContext);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    t.printStackTrace();
                }
            }

            private void safeHandle(Throwable ex, IEclipseContext appContext) {
                StatusReporter statusReporter = (StatusReporter)appContext.get(StatusReporter.class.getName());
                if (statusReporter != null) {
                    statusReporter.show(4, "Internal Error", ex, new Object[0]);
                } else if (PartRenderingEngine.this.logger != null) {
                    PartRenderingEngine.this.logger.error(ex);
                }
            }
        });
        return IApplication.EXIT_OK;
    }

    protected boolean someAreVisible(List<MWindow> windows) {
        for (MWindow win : windows) {
            if (!win.isToBeRendered() || !win.isVisible() || win.getWidget() == null) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        this.cleanUp();
        if (this.theApp != null) {
            for (MWindow window : this.theApp.getChildren()) {
                if (window.getWidget() == null) continue;
                ((Shell)window.getWidget()).close();
            }
        } else if (this.testShell != null && !this.testShell.isDisposed()) {
            Object model = this.testShell.getData("modelElement");
            if (model instanceof MUIElement) {
                this.removeGui((MUIElement)model);
            } else {
                this.testShell.close();
            }
        }
    }

    private void cleanUp() {
        Display display;
        if (this.keyListener != null && !(display = Display.getDefault()).isDisposed()) {
            display.removeFilter(1, this.keyListener);
            display.removeFilter(31, this.keyListener);
            this.keyListener = null;
        }
    }

    public static void initializeStyling(Display display, IEclipseContext appContext) {
        String cssTheme = (String)appContext.get("cssTheme");
        String cssURI = (String)appContext.get("applicationCSS");
        if (cssTheme != null) {
            String cssResourcesURI = (String)appContext.get("applicationCSSResources");
            Bundle bundle = WorkbenchSWTActivator.getDefault().getBundle();
            BundleContext context = bundle.getBundleContext();
            ServiceReference ref = context.getServiceReference(IThemeManager.class.getName());
            IThemeManager mgr = (IThemeManager)context.getService(ref);
            final IThemeEngine engine2 = mgr.getEngineForDisplay(display);
            IContributionFactory contribution = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
            IEclipseContext cssContext = EclipseContextFactory.create();
            cssContext.set(IContributionFactory.class.getName(), (Object)contribution);
            display.setData("org.eclipse.e4.ui.css.context", (Object)cssContext);
            if (cssResourcesURI != null) {
                engine2.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(cssResourcesURI), new String[0]);
            }
            engine2.restore(cssTheme);
            appContext.set(IThemeEngine.class.getName(), (Object)engine2);
            appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                public void setClassname(Object widget, String classname) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                    engine2.applyStyles((Widget)widget, true);
                }

                public void setId(Object widget, String id) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                    engine2.applyStyles((Widget)widget, true);
                }

                public void style(Object widget) {
                    engine2.applyStyles((Widget)widget, true);
                }

                public CSSStyleDeclaration getStyle(Object widget) {
                    return engine2.getStyle((Widget)widget);
                }

                public void setClassnameAndId(Object widget, String classname, String id) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                    engine2.applyStyles((Widget)widget, true);
                }
            });
        } else if (cssURI != null) {
            Shell[] shells;
            CSSSWTEngineImpl engine;
            block27: {
                String cssResourcesURI = (String)appContext.get("applicationCSSResources");
                engine = new CSSSWTEngineImpl(display, true);
                if (cssResourcesURI != null) {
                    engine.getResourcesLocatorManager().registerResourceLocator((IResourceLocator)new OSGiResourceLocator(cssResourcesURI.toString()));
                }
                display.setData("org.eclipse.e4.ui.css.context", (Object)appContext);
                appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                    public void setClassname(Object widget, String classname) {
                        ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                        engine.applyStyles((Object)((Widget)widget), true);
                    }

                    public void setId(Object widget, String id) {
                        ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                        engine.applyStyles((Object)((Widget)widget), true);
                    }

                    public void style(Object widget) {
                        engine.applyStyles((Object)((Widget)widget), true);
                    }

                    public CSSStyleDeclaration getStyle(Object widget) {
                        Element e = engine.getCSSElementContext(widget).getElement();
                        if (e == null) {
                            return null;
                        }
                        return engine.getViewCSS().getComputedStyle(e, null);
                    }

                    public void setClassnameAndId(Object widget, String classname, String id) {
                        ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                        ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                        engine.applyStyles((Object)((Widget)widget), true);
                    }
                });
                InputStream stream = null;
                try {
                    URL url = FileLocator.resolve((URL)new URL(cssURI));
                    stream = url.openStream();
                    engine.parseStyleSheet(stream);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block27;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        break block27;
                    }
                    catch (Throwable engine2) {
                        throw engine2;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                if (stream == null) break block27;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    Shell s = shellArray[n2];
                    try {
                        try {
                            s.setRedraw(false);
                            s.reskin(1);
                            engine.applyStyles((Object)s, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            s.setRedraw(true);
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        s.setRedraw(true);
                        throw throwable;
                    }
                    s.setRedraw(true);
                }
                ++n2;
            }
        }
    }
}

