/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal.contributors.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.compatibility.internal.contributors.ContributionFailedException;
import org.eclipse.platform.discovery.compatibility.internal.contributors.IDynamicRegistryContributor;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.DynamicRegistryContributor;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageDescription;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageParser;
import org.w3c.dom.Element;

public class DynamicObjectTypeContributor
extends DynamicRegistryContributor
implements IDynamicRegistryContributor {
    private final ISearchPageParser searchPageParser;

    public DynamicObjectTypeContributor(ISearchPageParser searchPageParser) {
        this.searchPageParser = searchPageParser;
    }

    @Override
    public void contribute(IExtensionRegistry registry, IContributor contributor, Object token) throws ContributionFailedException {
        ArrayList<ISearchPageDescription> failedContributors = new ArrayList<ISearchPageDescription>();
        for (ISearchPageDescription pageDescription : this.searchPageParser.readContributions()) {
            Element plugin = this.xmlUtils().createPluginSnippet("org.eclipse.platform.discovery.runtime.objecttype");
            this.addObjectTypeElement(pageDescription, plugin);
            String name = MessageFormat.format("Dynamic ObjectType for search page: {0}", pageDescription.toString());
            boolean success = this.writeToRegistry(plugin, registry, contributor, token, name);
            if (success) continue;
            failedContributors.add(pageDescription);
        }
        if (!failedContributors.isEmpty()) {
            throw new ContributionFailedException("Dynamic object type contribution failed", failedContributors);
        }
    }

    private void addObjectTypeElement(ISearchPageDescription pageDescription, Element plugin) {
        Element objecttype = plugin.getOwnerDocument().createElement("objecttype");
        objecttype.setAttribute("id", pageDescription.getId());
        objecttype.setAttribute("displayname", pageDescription.getDisplayName());
        Element extension = (Element)plugin.getFirstChild();
        extension.appendChild(objecttype);
    }
}

