/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.team;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.team.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;

public class RepositoryConfigurationWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private ISemanticFileSystem mySfs;

    public boolean performFinish() {
        if (this.mySfs == null) {
            Status error = new Status(4, "org.eclipse.ui.resources.semantic", Messages.RepositoryConfigurationWizard_SFSNotInitialized_XMSG);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RepositoryConfigurationWizard_SFSError_XGRP, null, (IStatus)error);
            return false;
        }
        try {
            RepositoryProvider.map((IProject)this.project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
            return true;
        }
        catch (TeamException e) {
            this.mySfs.getLog().log((CoreException)((Object)e));
            return false;
        }
    }

    public void init(IWorkbench workbench, IProject actProject) {
        this.project = actProject;
        try {
            this.mySfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
        }
        catch (CoreException coreException) {}
    }
}

