/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.internal;

import org.eclipse.e4.core.deeplink.DeepLinkURLException;

public class ParsedDeepLinkURL {
    private static final String PROTOCOL_STRING = "deeplink://";
    public final String installation;
    public final String restOfURL;

    public ParsedDeepLinkURL(String urlString) throws DeepLinkURLException {
        if (!urlString.startsWith(PROTOCOL_STRING)) {
            throw new DeepLinkURLException("Invalid deep link URL: " + urlString);
        }
        String urlWithoutProtocol = urlString.replace(PROTOCOL_STRING, "").trim();
        if (urlWithoutProtocol.length() < 1 || urlWithoutProtocol.startsWith("/")) {
            throw new DeepLinkURLException("Invalid deep link URL: " + urlString);
        }
        this.installation = urlWithoutProtocol.split("/+")[0];
        this.restOfURL = urlWithoutProtocol.replaceFirst(this.installation, "").trim();
    }
}

