/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.palette.customize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomWidgetManager {
    private static final String CUSTOM_PALETTE_EXTENSION_ID = "org.eclipse.e4.xwt.vex.customPalette";
    private static final String WIDGET_CATEGORY_ELEMENT = "category";
    private static final String WIDGET_CATEGORY_NAME_ATTR = "name";
    private static final String WIDGET_CATEGORY_ICON_ATTR = "icon";
    private static final String WIDGET_ELEMENT = "tool";
    private static final String WIDGET_NAME_ATTR = "name";
    private static final String WIDGET_CLASS_ATTR = "class";
    private static final String WIDGET_SCOPE_ATTR = "scope";
    private static final String WIDGET_ICON_ATTR = "icon";
    private static final String WIDGET_TOOLTIP_ATTR = "tooltip";
    private static final String WIDGET_CONTENT_ATTR = "content";
    private static CustomWidgetManager __instance;
    private Map<Category, List<Tool>> widgetMap = null;
    private Collection<Class<?>> widgetClassList = null;

    private CustomWidgetManager() {
        this.initWidgetCategories();
    }

    public static CustomWidgetManager getInstance() {
        if (__instance == null) {
            __instance = new CustomWidgetManager();
        }
        return __instance;
    }

    public Map<Category, List<Tool>> getWidgetCategories() {
        return this.widgetMap;
    }

    public Collection<Class<?>> getWidgetClassList() {
        return this.widgetClassList;
    }

    private void initWidgetCategories() {
        this.widgetMap = new HashMap<Category, List<Tool>>();
        this.widgetClassList = new ArrayList();
        List<Tool> widgetList = null;
        List<IConfigurationElement> confEltList = this.getExtensions(CUSTOM_PALETTE_EXTENSION_ID);
        if (confEltList != null && !confEltList.isEmpty()) {
            for (IConfigurationElement cfgElt : confEltList) {
                IConfigurationElement[] widgetElts;
                String nameCat;
                String eltName = cfgElt.getName();
                if (!WIDGET_CATEGORY_ELEMENT.equals(eltName) || (nameCat = cfgElt.getAttribute("name")) == null || nameCat.length() == 0) continue;
                String extPlugInID = cfgElt.getContributor().getName();
                WidgetIcon iconCat = new WidgetIcon(extPlugInID, cfgElt.getAttribute("icon"));
                Category widgetCat = new Category(nameCat, iconCat);
                widgetList = this.widgetMap.get(widgetCat);
                if (widgetList == null) {
                    widgetList = new ArrayList<Tool>();
                    this.widgetMap.put(widgetCat, widgetList);
                }
                if ((widgetElts = cfgElt.getChildren(WIDGET_ELEMENT)) == null || widgetElts.length <= 0) continue;
                IConfigurationElement[] iConfigurationElementArray = widgetElts;
                int n = widgetElts.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement widgetElt = iConfigurationElementArray[n2];
                    try {
                        String bundleName = widgetElt.getContributor().getName();
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        String className = widgetElt.getAttribute(WIDGET_CLASS_ATTR);
                        if (className != null) {
                            Class theClass = bundle.loadClass(widgetElt.getAttribute(WIDGET_CLASS_ATTR));
                            this.widgetClassList.add(theClass);
                        }
                        WidgetIcon icon = new WidgetIcon(extPlugInID, widgetElt.getAttribute("icon"));
                        String name = widgetElt.getAttribute("name");
                        String scope = widgetElt.getAttribute(WIDGET_SCOPE_ATTR);
                        String tooltip = widgetElt.getAttribute(WIDGET_TOOLTIP_ATTR);
                        String content = widgetElt.getAttribute(WIDGET_CONTENT_ATTR);
                        widgetList.add(new Tool(name, scope, tooltip, content, icon));
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
        }
    }

    private List<IConfigurationElement> getExtensions(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<IConfigurationElement> resList = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                resList.add(elements[j]);
                ++j;
            }
            ++i;
        }
        return resList;
    }

    public class Category {
        private String name = null;
        private WidgetIcon icon = null;

        public Category(String name, WidgetIcon icon) {
            this.name = name;
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public WidgetIcon getIcon() {
            return this.icon;
        }

        public boolean equals(Object obj) {
            boolean equals = super.equals(obj);
            if (!equals && obj instanceof Category) {
                Category widgetCat = (Category)obj;
                equals = this.name == null && widgetCat.name == null || this.name != null && this.name.equals(widgetCat.name);
            }
            return equals;
        }

        public int hashCode() {
            if (this.name != null) {
                return this.name.hashCode();
            }
            return super.hashCode();
        }
    }

    public class Tool {
        private String name = null;
        private String scope = null;
        private String tooltip = null;
        private String content = null;
        private WidgetIcon icon = null;

        public Tool(String name, String scope, String tooltip, String content, WidgetIcon icon) {
            this.name = name;
            this.scope = scope;
            this.tooltip = tooltip;
            this.content = content;
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public String getContent() {
            return this.content;
        }

        public WidgetIcon getIcon() {
            return this.icon;
        }
    }

    public class WidgetIcon {
        private String bundleID = null;
        private String path = null;

        public WidgetIcon(String bundleID, String path) {
            this.bundleID = bundleID;
            this.path = path;
        }

        public String getBundleID() {
            return this.bundleID;
        }

        public String getPath() {
            return this.path;
        }
    }
}

