/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class PLayer
extends PNode {
    public static final String PROPERTY_CAMERAS = "cameras";
    public static final int PROPERTY_CODE_CAMERAS = 8192;
    private transient List cameras = new ArrayList();

    public List getCamerasReference() {
        return this.cameras;
    }

    public int getCameraCount() {
        if (this.cameras == null) {
            return 0;
        }
        return this.cameras.size();
    }

    public PCamera getCamera(int index) {
        return (PCamera)this.cameras.get(index);
    }

    public void addCamera(PCamera camera) {
        this.addCamera(this.cameras.size(), camera);
    }

    public void addCamera(int index, PCamera camera) {
        this.cameras.add(index, camera);
        this.invalidatePaint();
        this.firePropertyChange(8192, PROPERTY_CAMERAS, null, this.cameras);
    }

    public PCamera removeCamera(PCamera camera) {
        return this.removeCamera(this.cameras.indexOf(camera));
    }

    public PCamera removeCamera(int index) {
        PCamera result = (PCamera)this.cameras.remove(index);
        this.invalidatePaint();
        this.firePropertyChange(8192, PROPERTY_CAMERAS, null, this.cameras);
        return result;
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (childOrThis != this) {
            this.localToParent(localBounds);
        }
        this.notifyCameras(localBounds);
        if (this.getParent() != null) {
            this.getParent().repaintFrom(localBounds, childOrThis);
        }
    }

    protected void notifyCameras(PBounds parentBounds) {
        int count = this.getCameraCount();
        int i = 0;
        while (i < count) {
            PCamera each = (PCamera)this.cameras.get(i);
            each.repaintFromLayer(parentBounds, this);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int count = this.getCameraCount();
        int i = 0;
        while (i < count) {
            ((PObjectOutputStream)out).writeConditionalObject(this.cameras.get(i));
            ++i;
        }
        out.writeObject(Boolean.FALSE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cameras = new ArrayList();
        while (true) {
            Object each;
            if ((each = in.readObject()) == null) {
                continue;
            }
            if (each.equals(Boolean.FALSE)) break;
            this.cameras.add(each);
        }
    }
}

