/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.objectdata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.JavaAttribute;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObject {
    private Object instance;
    private List<JavaAttribute> attributes;
    private List<JavaMethod> methods;

    public JavaObject(Object instance) {
        this.instance = instance;
    }

    public Object getInstance() {
        return this.instance;
    }

    public List<JavaAttribute> getAttributes() {
        if (this.attributes == null) {
            this.initAttributes();
        }
        return this.attributes;
    }

    private void initAttributes() {
        this.attributes = new ArrayList<JavaAttribute>();
        if (this.instance == null) {
            return;
        }
        Class<?> clazz = this.instance.getClass();
        this.addDeclaredFields(clazz);
        clazz = clazz.getSuperclass();
        while (clazz != null) {
            this.addDeclaredFields(clazz);
            clazz = clazz.getSuperclass();
        }
    }

    private void addDeclaredFields(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            this.attributes.add(new JavaAttribute(this, f));
            ++n2;
        }
    }

    public String getName() {
        return this.instance.getClass().getSimpleName();
    }
}

