/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Filter
implements IFilter {
    FilterDescription description;
    IProject project;
    IFilterType provider = null;

    public Filter(IProject project, FilterDescription description) {
        this.description = description;
        this.project = project;
    }

    public boolean match(IFileInfo fileInfo) throws CoreException {
        if (this.provider == null) {
            this.provider = FilterTypeManager.getDefault().instantiate(this.getId(), this.project, this.getArguments());
            if (this.provider == null) {
                String message = NLS.bind((String)Messages.filters_missingFilterType, (Object)this.getId());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources", 2, message, (Throwable)new Error()));
            }
        }
        if (this.provider != null) {
            return this.provider.matches(fileInfo);
        }
        return false;
    }

    public boolean isFirst() {
        FilterTypeManager.Descriptor descriptor = FilterTypeManager.getDefault().findDescriptor(this.getId());
        if (descriptor != null) {
            return descriptor.isFirstOrdering();
        }
        return false;
    }

    public String getArguments() {
        return this.description.getArguments();
    }

    public String getId() {
        return this.description.getFilterID();
    }

    public IPath getPath() {
        return this.description.getProjectRelativePath();
    }

    public IProject getProject() {
        return this.project;
    }

    public int getType() {
        return this.description.getType();
    }

    public boolean isIncludeOnly() {
        return (this.getType() & 1) != 0;
    }

    public boolean appliesTo(IFileInfo info) {
        if (info.isDirectory()) {
            return (this.getType() & 8) != 0;
        }
        return (this.getType() & 4) != 0;
    }

    public static IFileInfo[] filter(IProject project, LinkedList includeFilters, LinkedList excludeFilters, IFileInfo[] list) throws CoreException {
        IFileInfo[] result = Filter.filterIncludes(project, includeFilters, list);
        return Filter.filterExcludes(project, excludeFilters, result);
    }

    public static IFileInfo[] filterIncludes(IProject project, LinkedList filters, IFileInfo[] list) throws CoreException {
        if (filters.size() > 0) {
            IFileInfo[] result = new IFileInfo[list.length];
            int outputIndex = 0;
            int i = 0;
            while (i < list.length) {
                IFileInfo info = list[i];
                Iterator objIt = filters.iterator();
                boolean filtersWereApplicable = false;
                while (objIt.hasNext()) {
                    Filter filter = (Filter)objIt.next();
                    if (!filter.appliesTo(info)) continue;
                    filtersWereApplicable = true;
                    if (!filter.match(info)) continue;
                    result[outputIndex++] = info;
                    break;
                }
                if (!filtersWereApplicable) {
                    result[outputIndex++] = info;
                }
                ++i;
            }
            if (outputIndex != result.length) {
                IFileInfo[] tmp = new IFileInfo[outputIndex];
                System.arraycopy(result, 0, tmp, 0, outputIndex);
                result = tmp;
            }
            return result;
        }
        return list;
    }

    public static IFileInfo[] filterExcludes(IProject project, LinkedList filters, IFileInfo[] list) throws CoreException {
        if (filters.size() > 0) {
            IFileInfo[] result = new IFileInfo[list.length];
            int outputIndex = 0;
            int i = 0;
            while (i < list.length) {
                IFileInfo info = list[i];
                Iterator objIt = filters.iterator();
                boolean shouldBeExcluded = false;
                while (objIt.hasNext()) {
                    Filter filter = (Filter)objIt.next();
                    if (!filter.appliesTo(info) || !filter.match(info)) continue;
                    shouldBeExcluded = true;
                    break;
                }
                if (!shouldBeExcluded) {
                    result[outputIndex++] = info;
                }
                ++i;
            }
            if (outputIndex != result.length) {
                IFileInfo[] tmp = new IFileInfo[outputIndex];
                System.arraycopy(result, 0, tmp, 0, outputIndex);
                result = tmp;
            }
            return result;
        }
        return list;
    }
}

