/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FilterDescription
implements Comparable {
    private String id;
    private String arguments;
    private IPath path;
    private int type;
    static /* synthetic */ Class class$0;

    public FilterDescription() {
        this.path = Path.EMPTY;
        this.type = -1;
        this.id = null;
        this.arguments = null;
    }

    public FilterDescription(IResource resource, int type, String filterID, String arguments) {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)filterID);
        this.type = type;
        this.path = resource.getProjectRelativePath();
        this.id = filterID;
        this.arguments = arguments;
    }

    public FilterDescription(IPath projectRelativePath, int type, String filterID, String arguments) {
        Assert.isNotNull((Object)projectRelativePath);
        Assert.isNotNull((Object)filterID);
        this.type = type;
        this.path = projectRelativePath;
        this.id = filterID;
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        Class<?> clazz = o.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.FilterDescription");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            return false;
        }
        FilterDescription other = (FilterDescription)o;
        return this.path.equals((Object)other.path) && this.type == other.type && this.id.equals(other.id) && (this.arguments == null ? this.arguments == other.arguments : this.arguments.equals(other.arguments));
    }

    public String getFilterID() {
        return this.id;
    }

    public String getArguments() {
        return this.arguments;
    }

    public IPath getProjectRelativePath() {
        return this.path;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type + this.path.hashCode() + this.id.hashCode();
    }

    public void setFilterID(String id) {
        this.id = id;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int compareTo(Object o) {
        FilterDescription that = (FilterDescription)o;
        IPath path1 = this.getProjectRelativePath();
        IPath path2 = that.getProjectRelativePath();
        int count1 = path1.segmentCount();
        int compare = count1 - path2.segmentCount();
        if (compare != 0) {
            return compare;
        }
        int i = 0;
        while (i < count1) {
            compare = path1.segment(i).compareTo(path2.segment(i));
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
        return 0;
    }

    public boolean isInheritable() {
        return (this.getType() & 0x10) != 0;
    }

    public static LinkedList copy(LinkedList originalDescriptions, IPath projectRelativePath) {
        LinkedList<FilterDescription> copy = new LinkedList<FilterDescription>();
        Iterator it = originalDescriptions.iterator();
        while (it.hasNext()) {
            FilterDescription desc = (FilterDescription)it.next();
            FilterDescription newDesc = new FilterDescription(projectRelativePath, desc.getType(), desc.getFilterID(), desc.getArguments());
            copy.add(newDesc);
        }
        return copy;
    }
}

