/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IFilterTypeFactory;
import org.eclipse.core.resources.IProject;

public class RegexFilterTypeFactory
implements IFilterTypeFactory {
    public IFilterType instantiate(IProject project, String arguments) {
        return new RegexFilterType(project, arguments);
    }

    static class RegexFilterType
    implements IFilterType {
        Pattern pattern = null;

        public RegexFilterType(IProject project, String arguments) {
            if (arguments != null) {
                this.pattern = Pattern.compile(arguments);
            }
        }

        public boolean matches(IFileInfo fileInfo) {
            Matcher m = this.pattern.matcher(fileInfo.getName());
            return m.matches();
        }
    }
}

