/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IContextFunction;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.internal.context.Computation;
import org.eclipse.e4.core.services.internal.context.EclipseContext;

public class ValueComputation
extends Computation {
    Object cachedValue;
    IEclipseContext context;
    String name;
    boolean valid;
    IContextFunction function;
    EclipseContext originatingContext;
    private boolean computing;

    public ValueComputation(IEclipseContext context, IEclipseContext originatingContext, String name, IContextFunction computedValue) {
        this.context = context;
        this.originatingContext = (EclipseContext)originatingContext;
        this.name = name;
        this.function = computedValue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.originatingContext == null ? 0 : this.originatingContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueComputation other = (ValueComputation)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.originatingContext == null ? other.originatingContext != null : !this.originatingContext.equals(other.originatingContext));
    }

    protected final void doClear() {
        this.valid = false;
        this.cachedValue = null;
    }

    protected final void doHandleInvalid(ContextChangeEvent event) {
        int eventType = event.getEventType();
        this.originatingContext.invalidate(this.name, eventType == 3 ? 2 : eventType, event.getOldValue());
    }

    final Object get(Object[] arguments) {
        if (this.valid) {
            return this.cachedValue;
        }
        if (this.computing) {
            throw new CycleException(this.toString());
        }
        Computation oldComputation = (Computation)EclipseContext.currentComputation.get();
        EclipseContext.currentComputation.set(this);
        this.computing = true;
        try {
            try {
                this.cachedValue = this.function.compute(this.originatingContext, arguments);
                this.valid = true;
            }
            catch (CycleException ex) {
                throw new CycleException(String.valueOf(ex.getCycleMessage()) + "\n" + this.toString());
            }
        }
        finally {
            this.computing = false;
            EclipseContext.currentComputation.set(oldComputation);
        }
        this.startListening();
        return this.cachedValue;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ValueComputation(");
        result.append(this.context);
        result.append('/');
        result.append(this.originatingContext);
        result.append(',');
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    static class CycleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String cycleMessage;

        CycleException(String cycleMessage) {
            super("cycle while computing value");
            this.cycleMessage = cycleMessage;
        }

        String getCycleMessage() {
            return this.cycleMessage;
        }

        public String toString() {
            return "\n" + this.cycleMessage + "\n";
        }
    }
}

