/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.model.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.demo.contacts.model.Contact;
import org.eclipse.e4.demo.contacts.model.IContactsRepository;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardContactsRepository
implements IContactsRepository {
    private final Collection<Contact> contacts = Collections.synchronizedCollection(new ArrayList());

    public VCardContactsRepository() {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.e4.demo.contacts"), (IPath)new Path("vcards"), null);
        try {
            URI uri = FileLocator.toFileURL((URL)url).toURI();
            File directory = new File(uri);
            String[] stringArray = directory.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.endsWith(".vcf")) {
                    Contact contact = this.readFromVCard(String.valueOf(directory.getAbsolutePath()) + File.separator + file);
                    this.contacts.add(contact);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addContact(Contact contact) {
        this.contacts.add(contact);
    }

    @Override
    public Collection<Contact> getAllContacts() {
        return Collections.unmodifiableCollection(this.contacts);
    }

    @Override
    public void removeContact(Contact contact) {
        this.contacts.remove(contact);
    }

    private void saveAsVCard(Contact contact, String fileName) {
        String charSet = "CHARSET=" + Charset.defaultCharset().name();
        String vCard = "BEGIN:VCARD\nVERSION:2.1\nN;" + charSet + ":" + contact.getLastName() + ";" + contact.getFirstName() + "\nFN;" + charSet + ":" + contact.getFirstName() + " " + contact.getLastName() + "\nORG;" + charSet + ":" + contact.getCompany() + "\nTITLE:" + contact.getJobTitle() + "\nTEL;WORK;VOICE:" + contact.getPhone() + "\nTEL;CELL;VOICE:" + contact.getMobile() + "\nADR;WORK;" + charSet + ":" + ";;" + contact.getStreet() + ";" + contact.getCity() + ";" + contact.getState() + ";" + contact.getZip() + ";" + contact.getCountry() + "\nURL;WORK:" + contact.getWebPage() + "\nEMAIL;PREF;INTERNET:" + contact.getEmail() + "\nEND:VCARD\n";
        try {
            PrintWriter out = new PrintWriter(fileName);
            out.println(vCard);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Contact readFromVCard(String fileName) {
        Contact contact = new Contact();
        BufferedReader bufferedReader = null;
        String charSet = "Cp1252";
        try {
            try {
                String line;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(fileName), charSet);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    String[] result;
                    String value = this.getVCardValue(line, "N");
                    if (value != null) {
                        result = value.split(";");
                        if (result.length > 0) {
                            contact.setLastName(result[0]);
                        }
                        if (result.length > 1) {
                            contact.setFirstName(result[1]);
                        }
                        if (result.length > 2) {
                            contact.setMiddleName(result[2]);
                        }
                        if (result.length <= 3) continue;
                        contact.setTitle(result[3]);
                        continue;
                    }
                    value = this.getVCardValue(line, "TEL;WORK");
                    if (value != null) {
                        contact.setPhone(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "TEL;CELL");
                    if (value != null) {
                        contact.setMobile(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "ADR;WORK");
                    if (value != null) {
                        result = value.split(";");
                        if (result.length > 2) {
                            contact.setStreet(result[2]);
                        }
                        if (result.length > 3) {
                            contact.setCity(result[3]);
                        }
                        if (result.length > 4) {
                            contact.setState(result[4]);
                        }
                        if (result.length > 5) {
                            contact.setZip(result[5]);
                        }
                        if (result.length <= 6) continue;
                        contact.setCountry(result[6]);
                        continue;
                    }
                    value = this.getVCardValue(line, "EMAIL;PREF;INTERNET");
                    if (value != null) {
                        contact.setEmail(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "URL;WORK");
                    if (value != null) {
                        contact.setWebPage(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "ORG");
                    if (value != null) {
                        contact.setCompany(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "TITLE");
                    if (value != null) {
                        contact.setJobTitle(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "NOTE");
                    if (value != null) {
                        contact.setNote(value);
                        continue;
                    }
                    value = this.getVCardValue(line, "PHOTO;TYPE=JPEG;ENCODING=BASE64");
                    if (value == null) continue;
                    line = bufferedReader.readLine();
                    String base64 = "";
                    while (line != null && line.length() > 0 && line.charAt(0) == ' ') {
                        base64 = String.valueOf(base64) + line.trim();
                        line = bufferedReader.readLine();
                    }
                    byte[] imageBytes = Base64.decode((byte[])base64.getBytes());
                    ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                    ImageData imageData = new ImageData((InputStream)is);
                    contact.setImage(new Image((Device)Display.getCurrent(), imageData));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contact;
    }

    private String getVCardValue(String line, String token) {
        if (line.startsWith(String.valueOf(token) + ":") || line.startsWith(String.valueOf(token) + ";")) {
            String value = line.substring(line.indexOf(":") + 1);
            return value;
        }
        return null;
    }
}

