/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.views;

import java.net.URL;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.demo.contacts.model.Contact;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class DetailComposite
extends Composite {
    private Label imageLabel;
    private Image dummyPortrait;
    private boolean generalGroup;
    private final DataBindingContext dbc;
    private final WritableValue contactValue = new WritableValue();
    private final IObservableValue scaledImage;

    public DetailComposite(Composite parent, int style, boolean isEnabled, ModifyListener modifyListener, Contact contact) {
        super(parent, style);
        parent.getShell().setBackgroundMode(1);
        this.dbc = new DataBindingContext();
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.e4.demo.contacts"), (IPath)new Path("images/dummy.png"), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        if (imageDescriptor != null) {
            this.dummyPortrait = imageDescriptor.createImage();
        }
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 5;
        this.setLayout((Layout)layout);
        Composite composite = DetailComposite.createComposite(this);
        this.createSeparator(composite, "General");
        Text fullNameText = this.createText(composite, "Full Name:", null);
        final IObservableValue titleObservableValue = PojoObservables.observeDetailValue((IObservableValue)this.contactValue, (String)"title", String.class);
        final IObservableValue firstNameObservableValue = PojoObservables.observeDetailValue((IObservableValue)this.contactValue, (String)"firstName", String.class);
        final IObservableValue middleNameObservableValue = PojoObservables.observeDetailValue((IObservableValue)this.contactValue, (String)"middleName", String.class);
        final IObservableValue lastNameObservableValue = PojoObservables.observeDetailValue((IObservableValue)this.contactValue, (String)"lastName", String.class);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)fullNameText, (int)24), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                StringBuilder fullName = new StringBuilder();
                if (DetailComposite.this.checkEmptyString(titleObservableValue.getValue())) {
                    fullName.append(titleObservableValue.getValue());
                    fullName.append(" ");
                }
                if (DetailComposite.this.checkEmptyString(firstNameObservableValue.getValue())) {
                    fullName.append(firstNameObservableValue.getValue());
                    fullName.append(" ");
                }
                if (DetailComposite.this.checkEmptyString(middleNameObservableValue.getValue())) {
                    fullName.append(middleNameObservableValue.getValue());
                    fullName.append(" ");
                }
                if (DetailComposite.this.checkEmptyString(lastNameObservableValue.getValue())) {
                    fullName.append(lastNameObservableValue.getValue());
                }
                return fullName.toString();
            }
        });
        this.createText(composite, "Company:", "company");
        this.createText(composite, "Job Title:", "jobTitle");
        this.createText(composite, "Note:", "note");
        this.createVerticalSpace(composite);
        this.createSeparator(composite, "Business Address ");
        this.createText(composite, "Street:", "street");
        this.createText(composite, "City:", "city");
        this.createText(composite, "ZIP:", "zip");
        this.createText(composite, "State/Prov:", "state");
        this.createText(composite, "Country:", "country");
        this.createVerticalSpace(composite);
        this.createSeparator(composite, "Business Phones ");
        this.createText(composite, "Phone:", "phone");
        this.createText(composite, "Mobile:", "mobile");
        this.createVerticalSpace(composite);
        this.createSeparator(composite, "Business Internet");
        this.createText(composite, "Email:", "email");
        this.createText(composite, "Web Page:", "webPage");
        this.createVerticalSpace(composite);
        final IObservableValue imageObservableValue = PojoObservables.observeDetailValue((IObservableValue)this.contactValue, (String)"image", Image.class);
        this.scaledImage = new ComputedValue(){
            private Image currentImage;

            protected Object calculate() {
                Image image = (Image)imageObservableValue.getValue();
                if (image == null) {
                    image = DetailComposite.this.dummyPortrait;
                }
                ImageData imageData = image.getImageData();
                double ratio = (double)imageData.height / 68.0;
                int width = (int)((double)imageData.width / ratio);
                int height = (int)((double)imageData.height / ratio);
                ImageData scaledImageData = imageData.scaledTo(width, height);
                if (this.currentImage != null) {
                    this.currentImage.dispose();
                    this.currentImage = null;
                }
                this.currentImage = new Image((Device)Display.getCurrent(), scaledImageData);
                return this.currentImage;
            }

            public void dispose() {
                if (this.currentImage != null) {
                    this.currentImage.dispose();
                    this.currentImage = null;
                }
                super.dispose();
            }
        };
        this.dbc.bindValue((IObservableValue)SWTObservables.observeImage((Widget)this.imageLabel), this.scaledImage, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
    }

    public boolean checkEmptyString(Object testString) {
        return testString != null && testString instanceof String && ((String)testString).trim().length() != 0;
    }

    public void dispose() {
        this.dummyPortrait.dispose();
        this.scaledImage.dispose();
        super.dispose();
    }

    private void createSeparator(Composite parent, String text) {
        this.generalGroup = text.equals("General");
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(text) + "     ");
        label.setData("org.eclipse.e4.ui.css.id", (Object)"SeparatorLabel");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void createVerticalSpace(Composite parent) {
        Label label2 = new Label(parent, 258);
        label2.setVisible(false);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        label2.setLayoutData((Object)gridData);
    }

    private static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        return composite;
    }

    private Text createText(Composite parent, String labelText, String property) {
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(labelText) + "   ");
        GridData gridData = new GridData(256);
        gridData.horizontalIndent = 20;
        label.setLayoutData((Object)gridData);
        Text text = new Text(parent, 0);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalIndent = 0;
        if (!this.generalGroup) {
            gridData2.horizontalSpan = 2;
        } else {
            gridData2.horizontalSpan = 1;
            if (labelText.equals("Full Name:")) {
                this.imageLabel = new Label(parent, 0);
                GridData gridData3 = new GridData();
                gridData3.verticalSpan = 4;
                this.imageLabel.setLayoutData((Object)gridData3);
            }
        }
        text.setLayoutData((Object)gridData2);
        if (property != null) {
            this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), PojoObservables.observeDetailValue((IObservableValue)this.contactValue, (String)property, String.class));
        }
        return text;
    }

    public void update(Contact contact) {
        this.contactValue.setValue((Object)contact);
    }
}

