/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.views;

import java.util.ArrayList;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.demo.contacts.model.Contact;
import org.eclipse.e4.demo.contacts.model.ContactsRepositoryFactory;
import org.eclipse.e4.demo.contacts.views.ContactViewerComparator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ListView
implements IDisposable {
    private final TableViewer contactsViewer;

    public ListView(Composite parent, final IEclipseContext outputContext) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.contactsViewer = new TableViewer(tableComposite, 65536);
        this.contactsViewer.getTable().setHeaderVisible(true);
        this.contactsViewer.setComparator((ViewerComparator)new ContactViewerComparator());
        this.contactsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                outputContext.set("selection", (Object)(selection.size() == 1 ? selection.getFirstElement() : selection.toArray()));
            }
        });
        TableViewerColumn firstNameColumn = new TableViewerColumn(this.contactsViewer, 0);
        firstNameColumn.getColumn().setText("First Name");
        tableColumnLayout.setColumnData((Widget)firstNameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(40));
        TableViewerColumn lastNameColumn = new TableViewerColumn(this.contactsViewer, 0);
        lastNameColumn.getColumn().setText("Last Name");
        tableColumnLayout.setColumnData((Widget)lastNameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(60));
        ArrayList<Contact> contactList = new ArrayList<Contact>(ContactsRepositoryFactory.getContactsRepository().getAllContacts());
        IObservableList observableList = Observables.staticObservableList(contactList);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.contactsViewer.setContentProvider((IContentProvider)contentProvider);
        IObservableMap[] attributes = PojoObservables.observeMaps((IObservableSet)contentProvider.getKnownElements(), Contact.class, (String[])new String[]{"firstName", "lastName"});
        this.contactsViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributes));
        this.contactsViewer.setInput((Object)observableList);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    public void dispose() {
    }
}

