/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MSashForm;
import org.eclipse.e4.workbench.ui.internal.UISchedulerStrategy;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.e4.workbench.ui.renderers.PartRenderingEngine;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageDialogHandler {
    public void execute(Shell shell, MApplication<?> app, PartRenderingEngine renderer) {
        ImageDialog dlg = new ImageDialog(shell, app, renderer);
        dlg.open();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageDialog
    extends Dialog {
        private PartRenderingEngine theRenderer;
        private IEclipseContext dlgContext;

        public ImageDialog(Shell shell, MApplication<?> app, PartRenderingEngine renderer) {
            super(shell);
            this.theRenderer = renderer;
            this.dlgContext = EclipseContextFactory.create((IEclipseContext)app.getContext(), (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
            this.dlgContext.set("input", (Object)new ContextFunction(){

                public Object compute(IEclipseContext context, Object[] arguments) {
                    Object adapted;
                    IAdapterManager adapters;
                    Class adapterType = null;
                    if (arguments.length > 0 && arguments[0] instanceof Class) {
                        adapterType = (Class)arguments[0];
                    }
                    Object newInput = null;
                    Object newValue = ImageDialog.this.dlgContext.get("selection");
                    if (adapterType == null || adapterType.isInstance(newValue)) {
                        newInput = newValue;
                    } else if (newValue != null && adapterType != null && (adapters = (IAdapterManager)ImageDialog.this.dlgContext.get(IAdapterManager.class.getName())) != null && (adapted = adapters.loadAdapter(newValue, adapterType.getName())) != null) {
                        newInput = adapted;
                    }
                    return newInput;
                }
            });
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FillLayout());
            comp.setLayoutData((Object)new GridData(1808));
            MPart<MPart<?>> dlgModel = this.createDlgModel();
            Workbench.initializeContext((IEclipseContext)this.dlgContext, dlgModel);
            this.theRenderer.createGui(dlgModel, (Object)comp);
            this.dlgContext.set("activeChild", (Object)dlgModel.getContext());
            return comp;
        }

        private MPart<MPart<?>> createDlgModel() {
            MSashForm sash = ApplicationFactory.eINSTANCE.createMSashForm();
            sash.setPolicy("Horizontal");
            MContributedPart library = ApplicationFactory.eINSTANCE.createMContributedPart();
            library.setURI("platform:/plugin/org.eclipse.e4.demo.e4photo/org.eclipse.e4.demo.e4photo.Library");
            library.setName("Library");
            MContributedPart preview = ApplicationFactory.eINSTANCE.createMContributedPart();
            preview.setURI("platform:/plugin/org.eclipse.e4.demo.e4photo/org.eclipse.e4.demo.e4photo.Preview");
            preview.setName("Preview");
            sash.getChildren().add((Object)library);
            sash.getChildren().add((Object)preview);
            return sash;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Image Dialog");
            shell.setSize(600, 400);
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(true);
        }

        protected boolean isResizable() {
            return true;
        }
    }
}

