/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.viewer;

import org.eclipse.e4.core.services.annotations.In;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class TabAdvanced {
    private static final String[] booleanValues = new String[]{"true", "false"};
    private TableViewer tableViewer;

    public TabAdvanced(Composite parent) {
        Table table = new Table(parent, 65536);
        table.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(table);
        TableViewerColumn columnName = new TableViewerColumn(this.tableViewer, 0);
        columnName.getColumn().setText("Property");
        columnName.getColumn().setResizable(true);
        TableViewerColumn columnValue = new TableViewerColumn(this.tableViewer, 0);
        columnValue.getColumn().setText("Value");
        columnValue.getColumn().setResizable(true);
        columnValue.setEditingSupport((EditingSupport)new PropertiesEditingSupport((ColumnViewer)this.tableViewer));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layoutLayout = new TableLayout();
        layoutLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        layoutLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        table.setLayout((Layout)layoutLayout);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private EObject eObj;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.eObj = (EObject)newInput;
            }

            public Object[] getElements(Object inputElement) {
                EList features = this.eObj.eClass().getEAllStructuralFeatures();
                Object[] result = new EObjectFeature[features.size()];
                int pos = 0;
                for (EStructuralFeature feature : features) {
                    result[pos] = new EObjectFeature(this.eObj, feature);
                    ++pos;
                }
                return result;
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((EObjectFeature)element).feature.getName();
                    }
                    case 1: {
                        return TabAdvanced.this.getPropertyValue((EObjectFeature)element);
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    private Object getProperty(EObject eObj, String id) {
        if (eObj == null) {
            return null;
        }
        EStructuralFeature eFeature = eObj.eClass().getEStructuralFeature(id);
        if (eFeature == null) {
            return null;
        }
        return eObj.eGet(eFeature);
    }

    @In
    public void setSelection(EObject selection) {
        if (selection == null) {
            return;
        }
        this.tableViewer.setInput((Object)selection);
    }

    private String getPropertyValue(EObjectFeature eDataObj) {
        Class clazz = eDataObj.feature.getEType().getInstanceClass();
        String clsStr = clazz.getName();
        Object propVal = this.getProperty(eDataObj.eObj, eDataObj.feature.getName());
        if (clsStr.equals("java.lang.String") || clsStr.equals("int")) {
            if (propVal == null) {
                return "<null> ";
            }
            return propVal.toString();
        }
        if (clsStr.equals("boolean")) {
            if (propVal == null) {
                return "<null> ";
            }
            return propVal.toString();
        }
        if (propVal == null) {
            return "<null> ";
        }
        return propVal.getClass().getName();
    }

    private boolean isBoolean(EObjectFeature eDataObj) {
        Class clazz = eDataObj.feature.getEType().getInstanceClass();
        String clsStr = clazz.getName();
        return clsStr.equals("boolean");
    }

    public void dispose() {
    }

    private class EObjectFeature {
        public EObject eObj;
        public EStructuralFeature feature;

        public EObjectFeature(EObject eObj, EStructuralFeature feature) {
            this.eObj = eObj;
            this.feature = feature;
        }
    }

    private class PropertiesEditingSupport
    extends EditingSupport {
        private CellEditor textEditor;
        private ComboBoxCellEditor booleanEditor;

        public PropertiesEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.textEditor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
            this.booleanEditor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), booleanValues, 8){

                public boolean isActivated() {
                    return true;
                }
            };
        }

        protected boolean canEdit(Object element) {
            Class clazz = ((EObjectFeature)element).feature.getEType().getInstanceClass();
            String clsStr = clazz.getName();
            if (clsStr.equals("java.lang.String")) {
                return true;
            }
            return clsStr.equals("boolean");
        }

        protected CellEditor getCellEditor(Object element) {
            if (TabAdvanced.this.isBoolean((EObjectFeature)element)) {
                return this.booleanEditor;
            }
            return this.textEditor;
        }

        protected Object getValue(Object element) {
            String result = TabAdvanced.this.getPropertyValue((EObjectFeature)element);
            if (TabAdvanced.this.isBoolean((EObjectFeature)element)) {
                if (result.equals("true")) {
                    return new Integer(0);
                }
                return new Integer(1);
            }
            return result;
        }

        protected void setValue(Object element, Object value) {
            EObjectFeature dataObject = (EObjectFeature)element;
            if (TabAdvanced.this.isBoolean(dataObject)) {
                CCombo combo = (CCombo)this.booleanEditor.getControl();
                int selection = combo.getSelectionIndex();
                value = new Boolean(selection == 0);
            }
            dataObject.eObj.eSet(dataObject.feature, value);
            TabAdvanced.this.tableViewer.refresh(true);
        }
    }
}

