/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.emf.ecore.javascript.EObjectWrapper;
import org.eclipse.e4.emf.ecore.javascript.EmfContextFactory;
import org.eclipse.e4.emf.ecore.javascript.FunctionCall;
import org.eclipse.e4.emf.ecore.javascript.JavascriptNotificationSupport;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupportWrapper;
import org.eclipse.e4.emf.ecore.javascript.ListWrapper;
import org.eclipse.e4.emf.ecore.javascript.MapWrapper;
import org.eclipse.e4.emf.ecore.javascript.NameSupport;
import org.eclipse.e4.emf.ecore.javascript.ResourceSetWrapper;
import org.eclipse.e4.emf.ecore.javascript.ResourceWrapper;
import org.eclipse.e4.emf.ecore.javascript.Script;
import org.eclipse.e4.emf.ecore.javascript.ScriptClassLoader;
import org.eclipse.e4.emf.ecore.javascript.functions.AdaptTo;
import org.eclipse.e4.emf.ecore.javascript.functions.BindingApply;
import org.eclipse.e4.emf.ecore.javascript.functions.LoadEPackageFunction;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptSupport
extends WrapFactory {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final String JAVASCRIPT_EXTENSION = "js";
    private final URI ecoreJsUri = URI.createURI((String)String.valueOf(((Object)((Object)this)).getClass().getResource("Ecore.js")));
    private URIConverter uriConverter;
    public static final String SCRIPTING_OPERATION_SOURCE_URI = "http://www.eclipse.org/e4/emf/ecore/javascript/operationBody";
    public static final String SCRIPTING_SOURCE_FEATURE_URI = "http://www.eclipse.org/e4/emf/ecore/javascript/scriptSourceFeature";
    public static final String SCRIPTING_EXTERNAL_SOURCE_URI = "http://www.eclipse.org/e4/emf/ecore/javascript/externalSource";
    private Context context;
    private ScriptableObject rootScope;
    public static final URI ECORE_SCRIPT_URI = URI.createURI((String)EcorePackage.eINSTANCE.getNsURI()).appendFileExtension("js");
    private NameSupport nameSupport = new NameSupport(this);
    private Map<URI, Script> resourceScripts = new HashMap<URI, Script>();
    private ScriptClassLoader scriptClassLoader = null;
    private Map<Object, Scriptable> classPrototypes = new IdentityHashMap<Object, Scriptable>();
    private Map<Object, Scriptable> instancePrototypes = new IdentityHashMap<Object, Scriptable>();
    private ResourceSet packagesResourceSet = null;
    private Map<Object, Scriptable> wrappers = new IdentityHashMap<Object, Scriptable>();

    public static URI createParentFolderUri(URI uri) {
        return uri.lastSegment().length() == 0 ? uri : uri.trimSegments(1).appendSegment("");
    }

    public void setUriConverter(URIConverter uriConverter) {
        uriConverter.getURIMap().put(JavascriptSupport.createParentFolderUri(ECORE_SCRIPT_URI), JavascriptSupport.createParentFolderUri(this.ecoreJsUri));
        this.uriConverter = uriConverter;
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.setUriConverter((URIConverter)new ExtensibleURIConverterImpl());
        }
        return this.uriConverter;
    }

    public JavascriptSupport() {
        this.context = EmfContextFactory.getEmfContextFactory().makeContext();
        this.context.setWrapFactory((WrapFactory)this);
        URI ecoreJsUri = URI.createURI((String)String.valueOf(((Object)((Object)this)).getClass().getResource("Ecore.js")));
        this.rootScope = this.createScope(ecoreJsUri);
        this.context.initStandardObjects(this.rootScope);
        this.initStandardObjects((Scriptable)this.rootScope);
    }

    private Context enterContext() {
        return Context.enter((Context)this.context);
    }

    private void exitContext() {
        Context.exit();
    }

    public void setApplicationClassLoader(ClassLoader classLoader) {
        Context context = this.enterContext();
        context.setApplicationClassLoader(classLoader);
        this.exitContext();
    }

    private void initStandardObjects(Scriptable scope) {
        ScriptableObject.putProperty((Scriptable)scope, (String)"loadEPackage", (Object)((Object)new LoadEPackageFunction(this)));
        ScriptableObject.putProperty((Scriptable)scope, (String)"adaptTo", (Object)((Object)new AdaptTo()));
        ScriptableObject.putProperty((Scriptable)scope, (String)"applyAsBinding", (Object)((Object)new BindingApply(null)));
    }

    private Object evaluate(String script, String name, Scriptable scope, boolean rethrowException) {
        Object result;
        block6: {
            Context context = this.enterContext();
            result = null;
            try {
                try {
                    result = context.evaluateString(scope, script, name, -1, null);
                }
                catch (RuntimeException re) {
                    this.log.log(Level.SEVERE, "Exception when evaluating " + script + ": " + re, re);
                    if (rethrowException) {
                        throw re;
                    }
                    this.exitContext();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.exitContext();
                throw throwable;
            }
            this.exitContext();
        }
        return this.unwrap(result);
    }

    public Object evaluate(String script, Object scope, boolean rethrowException) {
        return this.evaluate(script, null, scope instanceof Scriptable ? (Scriptable)scope : this.getScope(scope), rethrowException);
    }

    public Scriptable getScope(Object object) {
        if (object instanceof Resource) {
            return this.getResourceScope((Resource)object);
        }
        if (object instanceof EObject) {
            return this.getResourceScope((EObject)object);
        }
        return this.rootScope;
    }

    public Object wrap(Object object) {
        this.enterContext();
        try {
            Object object2 = Context.javaToJS((Object)object, (Scriptable)this.getScope(object));
            return object2;
        }
        finally {
            this.exitContext();
        }
    }

    public Object unwrap(Object value) {
        return this.unwrapTo(value, Object.class);
    }

    public Object unwrapTo(Object value, Class<?> c) {
        this.enterContext();
        try {
            Object object = Context.jsToJava((Object)value, c != null ? c : Object.class);
            return object;
        }
        finally {
            this.exitContext();
        }
    }

    public Scriptable newObject(String constructorName, Object[] args) {
        Context context = this.enterContext();
        Scriptable result = null;
        try {
            try {
                result = context.newObject(this.getScope(null), constructorName, args);
            }
            catch (RuntimeException e) {
                this.log.log(Level.SEVERE, "Exception when invoking newObject: " + e, e);
                this.exitContext();
            }
        }
        finally {
            this.exitContext();
        }
        return result;
    }

    public Object getVariable(Resource res, String name) {
        return this.unwrap(this.getVariable(name, this.getResourceScope(res)));
    }

    public Object getProperty(EObject eObject, String name) {
        return this.unwrap(this.getProperty(name, (Scriptable)this.wrap(eObject)));
    }

    public void setVariable(Resource res, String name, Object value) {
        this.setProperty(name, this.getResourceScope(res), this.wrap(value));
    }

    public void setProperty(EObject eObject, String name, Object value) {
        this.setProperty(name, (Scriptable)this.wrap(eObject), this.wrap(value));
    }

    private Object getProperty(String name, Scriptable scope) {
        return ScriptableObject.getProperty((Scriptable)scope, (String)name);
    }

    private void setProperty(String name, Scriptable scope, Object value) {
        ScriptableObject.putProperty((Scriptable)scope, (String)name, (Object)this.wrap(value));
    }

    private Object getVariable(String name, Scriptable scope) {
        Object result = scope != null ? scope.get(name, scope) : null;
        return result == Scriptable.NOT_FOUND ? this.getVariable(name, scope.getParentScope()) : result;
    }

    public Object callMethod(Object object, String methodName, Object[] args, boolean rethrowException) {
        return this.call(object, methodName, args, object, rethrowException);
    }

    public Object callFunction(Resource res, String funName, Object[] args, boolean rethrowException) {
        return this.call(res, funName, args, null, rethrowException);
    }

    Object call(Object scopeObject, String functionName, Object[] args, Object thisEObject, boolean rethrowException) {
        Object result;
        block11: {
            Context context = this.enterContext();
            Scriptable scope = this.getScope(scopeObject);
            result = null;
            try {
                try {
                    Object fun;
                    Scriptable thisObject = scope;
                    if (thisEObject instanceof Scriptable) {
                        thisObject = (Scriptable)thisEObject;
                    } else if (thisEObject != null) {
                        thisObject = this.wrapAsJavaObject(context, scope, thisEObject, Object.class);
                    }
                    Object object = fun = thisEObject != null ? this.getProperty(functionName, thisObject) : this.getVariable(functionName, scope);
                    if (fun instanceof Function) {
                        result = ((Function)fun).call(context, scope, thisObject, this.wrap(args, context, scope));
                    } else {
                        this.log.log(Level.SEVERE, String.valueOf(functionName) + " not found (" + result + ") for " + thisObject);
                        result = Scriptable.NOT_FOUND;
                    }
                }
                catch (RuntimeException re) {
                    String objectRef = this.toString(thisEObject);
                    this.log.log(Level.SEVERE, "Exception when calling " + functionName + " on " + objectRef + ": " + re, re);
                    if (rethrowException) {
                        throw re;
                    }
                    this.exitContext();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.exitContext();
                throw throwable;
            }
            this.exitContext();
        }
        return this.unwrap(result);
    }

    String toString(Object thisObject) {
        String objectRef = "";
        if (thisObject instanceof EObject) {
            EObject thisEObject = (EObject)thisObject;
            objectRef = "a " + thisEObject.eClass().getName();
            EStructuralFeature nameFeature = thisEObject.eClass().getEStructuralFeature("name");
            if (nameFeature != null) {
                objectRef = String.valueOf(objectRef) + " named " + thisEObject.eGet(nameFeature);
            }
        } else {
            String.valueOf(objectRef);
        }
        return objectRef;
    }

    private Object[] wrap(Object[] args, Context context, Scriptable scope) {
        if (args == null) {
            return new Object[0];
        }
        Object[] wrappedArgs = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            wrappedArgs[i] = this.wrap(context, scope, args[i], Object.class);
            ++i;
        }
        return wrappedArgs;
    }

    public FunctionCall createFunctionCall(Resource res, String funName, Object[] args) {
        return new FunctionCall(res, funName, args);
    }

    public FunctionCall createMethodCall(EObject eObject, String methodName, Object[] args) {
        return new FunctionCall((Object)eObject.eClass().eResource(), eObject, methodName, args);
    }

    public Object call(FunctionCall functionCall, boolean rethrowException) {
        return functionCall.call(this, rethrowException);
    }

    public NativeObject createScope(URI uri) {
        return this.createScope(uri.toString());
    }

    public NativeObject createScope(String name) {
        return new NativeObject(name){
            private String scopeName;
            {
                this.scopeName = string;
            }

            public String toString() {
                return "[JS + " + this.scopeName + "]";
            }
        };
    }

    EStructuralFeature getNameFeature(EObject eObject) {
        return this.nameSupport.getNameFeature(eObject);
    }

    public String getName(EObject eObject) {
        return this.nameSupport.getName(eObject);
    }

    public boolean hasName(String name, EObject eObject) {
        return this.nameSupport.hasName(name, eObject);
    }

    public String getNamePropertyName(EObject eObject) {
        return this.nameSupport.getNamePropertyName(this.getName(eObject));
    }

    private Scriptable getResourceScope(EObject eObject) {
        return this.getResourceScope(eObject.eResource());
    }

    public Scriptable getResourceScope(Resource res) {
        if (res == null) {
            return this.rootScope;
        }
        Scriptable scope = this.getResourceScope(res.getURI());
        if (!(scope.get("resource", scope) instanceof Function)) {
            this.defineConstantFunction("resource", res, null, scope);
            this.nameSupport.handleResource(res);
        }
        return scope;
    }

    public void defineConstantFunction(String name, Object constant, String property, Scriptable scope) {
        scope.put(name, scope, (Object)this.createConstantFunction(name, constant, property));
    }

    private Scriptable getResourceScope(URI uri) {
        if (uri == null) {
            return this.rootScope;
        }
        Script script = this.getScript(uri, null);
        return script.scope;
    }

    Script getScript(URI uri, Scriptable scope) {
        Script script;
        Script script2 = script = scope == null ? this.resourceScripts.get(uri) : null;
        if (script == null) {
            URI scriptUri = uri.trimFileExtension().appendFileExtension(JAVASCRIPT_EXTENSION);
            if (scope == null) {
                Object object = scope = scriptUri.equals((Object)ECORE_SCRIPT_URI) ? this.rootScope : this.createScope(scriptUri);
            }
            if (scope != this.rootScope) {
                scope.setParentScope(this.getResourceScope(URI.createURI((String)EcorePackage.eINSTANCE.getNsURI())));
            }
            script = new Script(scriptUri, scope);
            if (this.scriptClassLoader == null) {
                Context context = this.enterContext();
                this.scriptClassLoader = new ScriptClassLoader(context.getApplicationClassLoader());
                this.exitContext();
            }
            script.loadScript(this.getURIConverter(), this.scriptClassLoader);
            this.resourceScripts.put(uri, script);
            this.resourceScripts.put(scriptUri, script);
        } else if (script.shouldLoadScript()) {
            script.loadScript(this.getURIConverter(), this.scriptClassLoader);
        }
        return script;
    }

    private Function createConstantFunction(final String name, final Object constant, final String property) {
        return new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                Object result = JavascriptSupport.this.wrap(constant);
                if (property != null && result instanceof Scriptable) {
                    result = ((Scriptable)result).get(property, (Scriptable)result);
                }
                return result;
            }

            public int getArity() {
                return 0;
            }

            public String getFunctionName() {
                return name;
            }
        };
    }

    void initWrapper(JavascriptSupportWrapper wrapper, Scriptable scope, final Object wrappedObject, EClassifier prototypeClass) {
        this.wrappers.put(wrappedObject, (Scriptable)wrapper);
        Object prototype = this.instancePrototypes.get(wrappedObject);
        if (prototype == null) {
            prototype = new InstancePrototype(){

                public String toString() {
                    return JavascriptSupportWrapper.toString("JSPrototypeWrapper", wrappedObject);
                }

                public String getClassName() {
                    return "JSPrototypeWrapper";
                }
            };
            this.instancePrototypes.put(wrappedObject, (Scriptable)prototype);
            prototype.setPrototype(this.getPrototype(prototypeClass));
            prototype.setParentScope(scope);
            if (wrappedObject instanceof EObject) {
                EObject eObject = (EObject)wrappedObject;
                this.evaluateInstanceScript(eObject, (Scriptable)prototype);
            }
            wrapper.setPrototype((Scriptable)prototype);
            Object initFun = ScriptableObject.getProperty((Scriptable)wrapper, (String)"init");
            if (initFun instanceof Function) {
                Context context = this.enterContext();
                try {
                    try {
                        Object[] initFunArgs = new Object[]{};
                        ((Function)initFun).call(context, scope, (Scriptable)wrapper, initFunArgs);
                    }
                    catch (RuntimeException e) {
                        this.log.log(Level.SEVERE, "Exception when calling init() on " + wrappedObject + ": " + e, e);
                        this.exitContext();
                    }
                }
                finally {
                    this.exitContext();
                }
            }
        }
    }

    public static EAttribute getScriptSourceAttribute(EObject eObject, String lang) {
        for (EAttribute attrFeature : eObject.eClass().getEAllAttributes()) {
            String sourceAttrAnnotation = JavascriptSupport.getAnnotation((EModelElement)attrFeature, SCRIPTING_SOURCE_FEATURE_URI, lang, null);
            if (sourceAttrAnnotation == null) continue;
            return attrFeature;
        }
        return null;
    }

    private void evaluateInstanceScript(final EObject eObject, final Scriptable scope) {
        for (final EAttribute attrFeature : eObject.eClass().getEAllAttributes()) {
            String sourceAttrAnnotation = JavascriptSupport.getAnnotation((EModelElement)attrFeature, SCRIPTING_SOURCE_FEATURE_URI, JAVASCRIPT_EXTENSION, null);
            if (sourceAttrAnnotation == null) continue;
            if (sourceAttrAnnotation.contains("eval")) {
                this.evaluateInstanceScript(eObject, attrFeature, scope);
            }
            if (!sourceAttrAnnotation.contains("listen")) continue;
            eObject.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == attrFeature) {
                        JavascriptSupport.this.evaluateInstanceScript(eObject, attrFeature, scope);
                    }
                }
            });
        }
    }

    private void evaluateInstanceScript(EObject eObject, EAttribute attrFeature, Scriptable scope) {
        Object attrValue = eObject.eGet((EStructuralFeature)attrFeature);
        if (attrValue != null) {
            this.evaluate(String.valueOf(attrValue), attrFeature.getName(), scope, false);
        }
    }

    private Scriptable loadPrototypeScript(EClassifier prototypeClass, Scriptable scope) {
        URI prototypeScriptUri = null;
        String sourceUri = JavascriptSupport.getAnnotation((EModelElement)prototypeClass, SCRIPTING_EXTERNAL_SOURCE_URI, JAVASCRIPT_EXTENSION, null);
        if (sourceUri != null) {
            prototypeScriptUri = URI.createURI((String)sourceUri);
        }
        if (prototypeScriptUri == null) {
            prototypeScriptUri = this.getEClassifierUri(prototypeClass);
        }
        Script script = this.getScript(prototypeScriptUri, scope);
        return script.scope;
    }

    private Scriptable getPrototype(List<EClass> prototypeClasses) {
        if (prototypeClasses.size() == 1) {
            return this.getPrototype((EClassifier)prototypeClasses.get(0));
        }
        Scriptable prototype = this.classPrototypes.get(prototypeClasses);
        if (prototype == null) {
            prototype = this.createScope(prototypeClasses.toString());
            for (EClassifier eClassifier : prototypeClasses) {
                prototype = this.loadPrototypeScript(eClassifier, prototype);
            }
            EClassifier eClassifier = (EClassifier)prototypeClasses.get(0);
            if (eClassifier instanceof EClass) {
                this.initEClassPrototype(prototype, (EClass)eClassifier);
            }
            this.classPrototypes.put(prototypeClasses, prototype);
        }
        return prototype;
    }

    private Scriptable getPrototype(EClassifier prototypeClass) {
        Scriptable prototype = this.classPrototypes.get(prototypeClass);
        if (prototype == null) {
            prototype = this.loadPrototypeScript(prototypeClass, null);
            this.classPrototypes.put(prototypeClass, prototype);
            if (prototypeClass instanceof EClass) {
                EClass prototypeEClass = (EClass)prototypeClass;
                this.initEClassPrototype(prototype, prototypeEClass);
                this.addEPackageVariable(prototypeClass);
            }
        }
        return prototype;
    }

    private void addEPackageVariable(EClassifier prototypeClass) {
        EPackage ePack = prototypeClass.getEPackage();
        this.addEPackageVariable(ePack);
    }

    public EPackage loadEPackage(String packageUri, String schemaUri) {
        EPackage ePack = this.getEPackage(packageUri, schemaUri);
        if (ePack == null) {
            throw new IllegalArgumentException("No package with URI " + packageUri + (schemaUri != null ? " @ " + schemaUri : "") + " found");
        }
        this.addEPackageVariable(ePack);
        return ePack;
    }

    private EPackage getEPackage(String packageUriString, String schemaUriString) {
        EPackage.Registry ePackageRegistry = EPackage.Registry.INSTANCE;
        EPackage ePack = ePackageRegistry.getEPackage(packageUriString);
        if (ePack != null) {
            return ePack;
        }
        if (this.packagesResourceSet == null) {
            this.packagesResourceSet = new ResourceSetImpl();
            this.packagesResourceSet.setURIConverter(this.getURIConverter());
        }
        for (Resource packageResource : this.packagesResourceSet.getResources()) {
            ePack = this.getResourcePackage(packageResource, packageUriString);
            if (ePack == null) continue;
            return ePack;
        }
        URI packageUri = URI.createURI((String)packageUriString);
        URI schemaUri = this.getURIConverter().normalize(schemaUriString != null ? URI.createURI((String)schemaUriString) : packageUri);
        Resource packageResource = this.packagesResourceSet.getResource(schemaUri, true);
        ePack = this.getResourcePackage(packageResource, packageUriString);
        if (ePack != null) {
            ePackageRegistry.put((Object)packageUriString, (Object)ePack);
            if (schemaUri != null && !schemaUri.equals((Object)packageUri)) {
                this.getURIConverter().getURIMap().put(JavascriptSupport.createParentFolderUri(packageUri), JavascriptSupport.createParentFolderUri(schemaUri));
            }
        }
        return ePack;
    }

    private EPackage getResourcePackage(Resource packageResource, String packageUri) {
        EObject eObject;
        if (packageResource != null && packageResource.getContents().size() > 0 && (eObject = (EObject)packageResource.getContents().get(0)) instanceof EPackage) {
            EPackage ePack = (EPackage)eObject;
            if (packageUri == null || packageUri.equals(ePack.getNsURI())) {
                return ePack;
            }
        }
        return null;
    }

    private void addEPackageVariable(EPackage ePack) {
        String packVariableName = this.getNamePropertyName((EObject)ePack);
        if (packVariableName != null && this.getVariable(null, packVariableName) == null) {
            this.setVariable(null, packVariableName, ePack.getNsURI());
            this.setVariable(null, packVariableName, ePack);
        }
    }

    private String getScriptSourceCodeAnnotation(EOperation op) {
        return JavascriptSupport.getAnnotation((EModelElement)op, SCRIPTING_OPERATION_SOURCE_URI, JAVASCRIPT_EXTENSION, null);
    }

    private static String getAnnotation(EModelElement modelElement, String uri, String key, String def) {
        String annotation = EcoreUtil.getAnnotation((EModelElement)modelElement, (String)uri, (String)key);
        return annotation != null && annotation.trim().length() > 0 ? annotation : def;
    }

    protected void initEClassPrototype(Scriptable prototype, EClass prototypeClass) {
        this.addEOperationFunctions(prototype, prototypeClass);
        if (prototypeClass != EcorePackage.eINSTANCE.getEObject()) {
            Scriptable prototype2;
            Object superClasses = prototypeClass.getESuperTypes();
            if (superClasses.size() == 0) {
                superClasses = Collections.singletonList(EcorePackage.eINSTANCE.getEObject());
            }
            if ((prototype2 = this.getPrototype((List<EClass>)superClasses)) == prototype) {
                System.err.println("Circular prototype chain!!!");
            }
            prototype.setPrototype(prototype2);
        }
        prototype.setParentScope(this.getResourceScope((EObject)prototypeClass));
    }

    private void addEOperationFunctions(Scriptable prototype, EClass prototypeClass) {
        for (EOperation op : prototypeClass.getEOperations()) {
            String source = this.getScriptSourceCodeAnnotation(op);
            if (source == null) continue;
            this.defineEOperationFunction(op, source, prototype);
        }
    }

    protected URI getEClassifierUri(EClassifier prototypeClass) {
        URI uri = URI.createURI((String)prototypeClass.getEPackage().getNsURI());
        if (uri.equals((Object)"http://www.eclipse.org/emf/2002/Ecore")) {
            uri = ECORE_SCRIPT_URI;
        }
        return uri.trimSegments(1).appendSegment(prototypeClass.getName());
    }

    public String functionSource(EOperation op, String source) {
        if (!source.startsWith("function ")) {
            if (!source.startsWith("{")) {
                source = "{\n" + source + "\n}";
            }
            String argList = null;
            Iterator params = op.getEParameters().iterator();
            while (params.hasNext()) {
                String name = ((EParameter)params.next()).getName();
                argList = argList == null ? name : String.valueOf(argList) + "," + name;
            }
            source = "function " + op.getName() + "(" + argList + ")" + source;
        }
        return source;
    }

    public BaseFunction defineEOperationFunction(EOperation op, String source, Scriptable scope) {
        try {
            Context context = this.enterContext();
            String def = this.functionSource(op, source);
            context.evaluateString(scope, def, op.getName(), -1, null);
            Object fun = scope.get(op.getName(), scope);
            if (fun instanceof BaseFunction) {
                BaseFunction baseFunction = (BaseFunction)fun;
                return baseFunction;
            }
            throw new IllegalArgumentException(String.valueOf(source) + " evaluated to " + fun + ", which is not a BaseFunction");
        }
        finally {
            this.exitContext();
        }
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
        Object wrapper = this.wrappers.get(javaObject);
        if (wrapper != null) {
            return wrapper;
        }
        if (javaObject instanceof EObject) {
            wrapper = new EObjectWrapper(this, scope, (EObject)javaObject, staticType);
        } else if (javaObject instanceof Resource) {
            wrapper = new ResourceWrapper(this, scope, (Resource)javaObject, staticType);
        } else if (javaObject instanceof ResourceSet) {
            wrapper = new ResourceSetWrapper(this, scope, (ResourceSet)javaObject, staticType);
        } else if (javaObject instanceof List) {
            wrapper = new ListWrapper(this, scope, (List)javaObject, staticType);
        } else if (javaObject instanceof Map) {
            wrapper = new MapWrapper(this, scope, (Map)javaObject, staticType);
        } else if (javaObject instanceof EMap) {
            wrapper = new MapWrapper(this, scope, (EMap)javaObject, staticType);
        } else {
            return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
        return wrapper;
    }

    public JavascriptNotificationSupport supportNotifications(Notifier notifier) {
        return new JavascriptNotificationSupport(this, notifier);
    }

    protected class CurriedFunction
    extends BaseFunction {
        private BaseFunction fun;
        private EObject arg1;

        public CurriedFunction(Scriptable scope, BaseFunction fun, EObject arg1) {
            super(scope, ScriptableObject.getFunctionPrototype((Scriptable)scope));
            this.fun = fun;
            this.arg1 = arg1;
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            Object[] realArgs = new Object[1 + args.length];
            realArgs[0] = this.arg1;
            System.arraycopy(args, 0, realArgs, 1, args.length);
            return this.fun.call(cx, scope, thisObj, realArgs);
        }

        public int getArity() {
            return this.fun.getArity() - 1;
        }
    }

    private abstract class InstancePrototype
    extends ScriptableObject {
        private InstancePrototype() {
        }

        public Object[] getIds() {
            Object[] ids1 = super.getIds();
            Object[] ids2 = this.getPrototype().getIds();
            Object[] ids = new Object[ids1.length + ids2.length];
            System.arraycopy(ids1, 0, ids, 0, ids1.length);
            System.arraycopy(ids2, 0, ids, ids1.length, ids2.length);
            return ids;
        }
    }
}

