/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.languages.javascript.JSONUtil;

public class JSONUtilTest
extends TestCase {
    public void testNull() {
        String result = JSONUtil.write(null);
        JSONUtilTest.assertEquals((String)result, (String)"null");
        JSONUtilTest.assertNull((Object)JSONUtil.read((String)result));
    }

    public void testTrue() {
        String result = JSONUtil.write((Object)Boolean.TRUE);
        JSONUtilTest.assertEquals((String)result, (String)Boolean.TRUE.toString());
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)result), (Object)Boolean.TRUE);
    }

    public void testFalse() {
        String result = JSONUtil.write((Object)Boolean.FALSE);
        JSONUtilTest.assertEquals((String)result, (String)Boolean.FALSE.toString());
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)result), (Object)Boolean.FALSE);
    }

    public void testNumber() {
        String result = JSONUtil.write((Object)new Integer(-38));
        JSONUtilTest.assertEquals((String)result, (String)"-38");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)result), (Object)new BigDecimal(-38));
        result = JSONUtil.write((Object)new Double(-3.56E-5));
        JSONUtilTest.assertEquals((String)result, (String)"-3.56E-5");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)result), (Object)new BigDecimal("-3.56E-5"));
    }

    public void testString() {
        String result = JSONUtil.write((Object)"test");
        JSONUtilTest.assertEquals((String)result, (String)"\"test\"");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)result), (Object)"test");
        result = JSONUtil.write((Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals((String)result, (String)"\"\\\\\\/\\\"\\b\\f\\n\\r\\t\\u0000\"");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)result), (Object)"\\/\"\b\f\n\r\t\u0000");
    }

    public void testMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", new Integer(8675309));
        map.put("string", "goog");
        map.put("escape", "\\/\"\b\f\n\r\t\u0000");
        map.put("true", Boolean.TRUE);
        map.put("false", Boolean.FALSE);
        map.put("null", null);
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("test", "test\n");
        map.put("object", object);
        ArrayList<String> array = new ArrayList<String>();
        array.add("anothertest");
        map.put("array", array);
        String result = JSONUtil.write(map);
        Map resultMap = (Map)JSONUtil.read((String)result);
        JSONUtilTest.assertEquals(resultMap.get("number"), (Object)new BigDecimal(8675309));
        JSONUtilTest.assertEquals(resultMap.get("string"), (Object)"goog");
        JSONUtilTest.assertEquals(resultMap.get("escape"), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(resultMap.get("true"), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(resultMap.get("false"), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(resultMap.get("null"), null);
        Map objectResult = (Map)resultMap.get("object");
        JSONUtilTest.assertEquals(objectResult.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)objectResult.size());
        Collection arrayResult = (Collection)resultMap.get("array");
        JSONUtilTest.assertTrue((boolean)arrayResult.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)arrayResult.size());
    }

    public void testWhiteSpaceMap() {
        String result = "\t\r\n  {\t\r\n  \"string\"\t\r\n  :\t\r\n  \"goog\"\t\r\n  ,\t\r\n  \"false\"\t\r\n  :\t\r\n  false\t\r\n  ,\t\r\n  \"true\"\t\r\n  :\t\r\n  true\t\r\n  ,\t\r\n  \"number\"\t\r\n  :\t\r\n  8675309\t\r\n  ,\t\r\n  \"object\"\t\r\n  :\t\r\n  {\t\r\n  \"test\"\t\r\n  :\t\r\n  \"test\\n\"\t\r\n  }\t\r\n  ,\t\r\n  \"null\"\t\r\n  :\t\r\n  null\t\r\n  ,\t\r\n  ";
        result = String.valueOf(result) + "\t\r\n  \"escape\"\t\r\n  :\t\r\n  \"\\\\\\/\\\"\\b\\f\\n\\r\\t\\u0000\"\t\r\n  ";
        result = String.valueOf(result) + "\t\r\n  ,\t\r\n  \"array\"\t\r\n  :\t\r\n  [\t\r\n  \"anothertest\"\t\r\n  ]\t\r\n  }\t\r\n  ";
        Map resultMap = (Map)JSONUtil.read((String)result);
        JSONUtilTest.assertEquals(resultMap.get("number"), (Object)new BigDecimal(8675309));
        JSONUtilTest.assertEquals(resultMap.get("string"), (Object)"goog");
        JSONUtilTest.assertEquals(resultMap.get("escape"), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(resultMap.get("true"), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(resultMap.get("false"), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(resultMap.get("null"), null);
        Map objectResult = (Map)resultMap.get("object");
        JSONUtilTest.assertEquals(objectResult.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)objectResult.size());
        Collection arrayResult = (Collection)resultMap.get("array");
        JSONUtilTest.assertTrue((boolean)arrayResult.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)arrayResult.size());
    }

    public void testArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(8675309));
        list.add("goog");
        list.add("\\/\"\b\f\n\r\t\u0000");
        list.add(Boolean.TRUE);
        list.add(Boolean.FALSE);
        list.add(null);
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("test", "test\n");
        list.add(object);
        ArrayList<String> array = new ArrayList<String>();
        array.add("anothertest");
        list.add(array);
        String result = JSONUtil.write(list);
        List resultList = (List)JSONUtil.read((String)result);
        JSONUtilTest.assertEquals(resultList.get(0), (Object)new BigDecimal(8675309));
        JSONUtilTest.assertEquals(resultList.get(1), (Object)"goog");
        JSONUtilTest.assertEquals(resultList.get(2), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(resultList.get(3), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(resultList.get(4), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(resultList.get(5), null);
        Map objectResult = (Map)resultList.get(6);
        JSONUtilTest.assertEquals(objectResult.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)objectResult.size());
        Collection arrayResult = (Collection)resultList.get(7);
        JSONUtilTest.assertTrue((boolean)arrayResult.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)arrayResult.size());
    }

    public void testWhiteSpaceArray() {
        String result = "   \t\r\n   [   \t\r\n   8675309   \t\r\n   ,   \t\r\n   \"goog\"   \t\r\n   ,   \t\r\n   ";
        result = String.valueOf(result) + "\"\\\\\\/\\\"\\b\\f\\n\\r\\t\\u0000\"";
        result = String.valueOf(result) + "   \t\r\n   ,   \t\r\n   true   \t\r\n   ,   \t\r\n   false   \t\r\n   ,   \t\r\n   null   \t\r\n   ,{   \t\r\n   \"test\"   \t\r\n   :   \t\r\n   \"test\\n\"   \t\r\n   }   \t\r\n   ,   \t\r\n   [   \t\r\n   \"anothertest\"   \t\r\n   ]   \t\r\n   ]   \t\r\n   ";
        List resultList = (List)JSONUtil.read((String)result);
        JSONUtilTest.assertEquals(resultList.get(0), (Object)new BigDecimal(8675309));
        JSONUtilTest.assertEquals(resultList.get(1), (Object)"goog");
        JSONUtilTest.assertEquals(resultList.get(2), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(resultList.get(3), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(resultList.get(4), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(resultList.get(5), null);
        Map objectResult = (Map)resultList.get(6);
        JSONUtilTest.assertEquals(objectResult.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)objectResult.size());
        Collection arrayResult = (Collection)resultList.get(7);
        JSONUtilTest.assertTrue((boolean)arrayResult.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)arrayResult.size());
    }
}

