/*******************************************************************************
 * Copyright (c) 2008 Hallvard Traetteberg.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Hallvard Traetteberg - initial API and implementation
 ******************************************************************************/
package org.eclipse.e4.tm.builder.swt;

import org.eclipse.e4.tm.builder.AbstractBinder;
import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.IBinder;
import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.styles.Styled;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class SwtBinder extends AbstractBinder implements IBinder {

	protected Object convertValue(EStructuralFeature feature, Object value) {
		if (feature.getEType() == org.eclipse.e4.tm.swt.styles.StylesPackage.eINSTANCE.getSwtConstant()) {
			value = SwtBuilder.getStaticField(SWT.class, String.valueOf(value).toUpperCase(), Integer.class, SWT.DEFAULT);
		}
		return value;
	}

	protected void setDefaultLayout(Composite swtComposite) {
		swtComposite.setLayout(getDefaultLayout());
	}

	protected Layout getDefaultLayout() {
		return new FillLayout();
	}

	protected void updateInvalidFeature(EObject eObject, EStructuralFeature feature, Object object) {
		super.updateInvalidFeature(eObject, feature, object);
		if (eObject.eContainer() instanceof org.eclipse.e4.tm.widgets.Composite) {
			org.eclipse.e4.tm.widgets.Composite comp = (org.eclipse.e4.tm.widgets.Composite)eObject.eContainer();
			if (eObject == comp.getLayout()) {
				((Composite)context.getObject(comp, Composite.class)).layout();
			}
		}
		String invalidateStyle = AbstractBuilder.getClassAnnotation(feature.getEContainingClass(), AbstractBinder.ANNOTATION_URI, "invalidateStyle", null);
		if (invalidateStyle != null) {
			EObject parent = eObject;
			while (parent != null) {
				if (parent instanceof Styled) {
					context.updateStyle((Styled)parent);
					break;
				}
			}
		}
	}
	
	//
	
	public void updateStyle(EObject eObject, Object object, IBinderContext context) {
	}
}
