/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder.swt;

import java.util.StringTokenizer;
import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.builder.swt.SwtBinder;
import org.eclipse.e4.tm.builder.swt.SwtBuilder;
import org.eclipse.e4.tm.styles.Style;
import org.eclipse.e4.tm.styles.StyleItem;
import org.eclipse.e4.tm.styles.StyleSelector;
import org.eclipse.e4.tm.styles.Styled;
import org.eclipse.e4.tm.widgets.AbstractComposite;
import org.eclipse.e4.tm.widgets.Composite;
import org.eclipse.e4.tm.widgets.Control;
import org.eclipse.e4.tm.widgets.WidgetsPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ControlBinder
extends SwtBinder
implements Listener {
    private static final Class<?>[] constructorParameterTypes = new Class[]{org.eclipse.swt.widgets.Composite.class, Integer.TYPE};
    public static final String CONTROL_DATA_URI_KEY = "modelUri";

    public void dispose(EObject eObject, Object object, IBinderContext context) {
        if (object instanceof org.eclipse.swt.widgets.Control) {
            org.eclipse.swt.widgets.Control swtControl = (org.eclipse.swt.widgets.Control)object;
            swtControl.dispose();
        }
        super.dispose(eObject, object, context);
    }

    protected int getSwtStyle(String styleString) {
        int style = 0;
        StringTokenizer styles = SwtBuilder.getSeparatedTokens(styleString);
        while (styles.hasMoreTokens()) {
            style |= SwtBuilder.getStaticField(SWT.class, styles.nextToken(), Integer.class, 0).intValue();
        }
        return style;
    }

    protected int getSwtStyle(EObject control) {
        String styleString = this.getClassAnnotation(control);
        return this.getSwtStyle(styleString);
    }

    protected void update(EObject control, EStructuralFeature feature, Object object, boolean isInit) {
        org.eclipse.swt.widgets.Composite swtComposite;
        super.update(control, feature, object, isInit);
        if (control instanceof AbstractComposite && feature == WidgetsPackage.eINSTANCE.getAbstractComposite_Controls() && (swtComposite = this.context.getObject(control, org.eclipse.swt.widgets.Composite.class)) != null) {
            swtComposite.layout();
        }
        if (isInit) {
            this.updateStyle(control, object, this.context);
        }
    }

    protected void invalidateFeature(EObject eObject, EStructuralFeature feature, Object object, boolean isEvent) {
        if (eObject instanceof AbstractComposite && feature == WidgetsPackage.eINSTANCE.getAbstractComposite_Controls()) {
            AbstractComposite composite = (AbstractComposite)eObject;
            org.eclipse.swt.widgets.Composite swtComposite = this.context.getObject((EObject)composite, org.eclipse.swt.widgets.Composite.class);
            if (swtComposite != null) {
                org.eclipse.swt.widgets.Control[] swtControls = swtComposite.getChildren();
                int i = 0;
                while (i < swtControls.length) {
                    swtControls[i].dispose();
                    ++i;
                }
            }
            for (Control control : composite.getControls()) {
                this.context.dispose((EObject)control);
            }
        }
        super.invalidateFeature(eObject, feature, object, isEvent);
    }

    protected Object create(EObject control) {
        int style = this.getSwtStyle(control);
        Class<?> swtClass = this.getToolkitClass(control, true);
        org.eclipse.swt.widgets.Composite swtComposite = this.getParent(control, org.eclipse.swt.widgets.Composite.class);
        if (swtComposite != null && swtComposite.getLayout() == null) {
            this.setDefaultLayout(swtComposite);
        }
        Object swtObject = null;
        try {
            Object[] constructorArguments = new Object[]{swtComposite, style};
            swtObject = swtClass.getConstructor(constructorParameterTypes).newInstance(constructorArguments);
            if (swtObject instanceof org.eclipse.swt.widgets.Control) {
                org.eclipse.swt.widgets.Control swtControl = swtObject;
                swtControl.setData(CONTROL_DATA_URI_KEY, (Object)EcoreUtil.getURI((EObject)control));
            }
        }
        catch (Exception e) {
            System.err.println("Exception when creating widget for " + this + ": " + e);
        }
        return swtObject;
    }

    protected void handleEventFeature(EObject control, EStructuralFeature feature, Object object) {
        if (!(object instanceof org.eclipse.swt.widgets.Control)) {
            return;
        }
        org.eclipse.swt.widgets.Control swtControl = (org.eclipse.swt.widgets.Control)object;
        String name = this.getRealName(feature);
        int eventType = SwtBuilder.getStaticField(SWT.class, name, Integer.class, 0);
        swtControl.addListener(eventType, (Listener)this);
    }

    public void handleEvent(Event event) {
        EObject control = this.context.getEObject(event.widget);
        if (control == null) {
            return;
        }
        for (EStructuralFeature feature : control.eClass().getEAllAttributes()) {
            String name;
            if (!"event".equals(this.getAccessMethod(feature, control.eClass())) || event.type != SwtBuilder.getStaticField(SWT.class, name = this.getRealName(feature), Integer.class, 0)) continue;
            control.eSet(feature, (Object)event);
        }
    }

    public boolean validateFeature(EObject eObject, Object object, String featureName, IBinderContext context) {
        if ("Style".equals(featureName) && eObject instanceof Styled) {
            this.updateStyle(eObject, object, context);
            return true;
        }
        return super.validateFeature(eObject, object, featureName, context);
    }

    public void updateStyle(EObject eObject, Object object, IBinderContext context) {
        if (eObject instanceof Styled && object instanceof org.eclipse.swt.widgets.Control) {
            this.updateStyle((Styled)eObject, (org.eclipse.swt.widgets.Control)object, context);
        }
    }

    protected void updateStyle(Styled control, org.eclipse.swt.widgets.Control swtControl, IBinderContext context) {
        Style style = control.getStyle();
        if (style != null) {
            for (StyleSelector styleSelector : style.getStyleSelectors()) {
                this.applyStyleSelector(style, styleSelector, swtControl);
            }
        }
        if (control instanceof Composite) {
            for (Control child : ((Composite)control).getControls()) {
                context.updateStyle((EObject)child);
            }
        }
    }

    private void applyStyleSelector(Style style, StyleSelector styleSelector, org.eclipse.swt.widgets.Control object) {
        String property = styleSelector.getProperty();
        String selector = styleSelector.getSelector();
        Object value = this.getStyleValue(style.eContainer(), selector);
        try {
            this.context.setProperty(object, property, value);
        }
        catch (Exception exception) {}
    }

    private Object getStyleValue(EObject eObject, String selector) {
        while (eObject != null) {
            Object value;
            Style style;
            if (eObject instanceof Styled && (style = ((Styled)eObject).getStyle()) != null && (value = this.getStyleValue(style, selector)) != null) {
                return value;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    private Object getStyleValue(Style style, String selector) {
        for (StyleItem styleItem : style.getStyleItems()) {
            if (!selector.equals(styleItem.getName())) continue;
            Class<?> c = this.getToolkitClass((EObject)styleItem, true);
            Object value = this.context.getObject((EObject)styleItem, c);
            if (value == null) {
                try {
                    value = this.context.convert(styleItem.getSource(), c);
                    this.context.putObject((EObject)styleItem, value);
                }
                catch (Exception exception) {}
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

