/**
 * <copyright>
 * </copyright>
 *
 * $Id: ListViewerImpl.java,v 1.1 2009/08/27 08:55:33 htraetteb Exp $
 */
package org.eclipse.e4.tm.widgets.impl;

import java.util.Collection;

import org.eclipse.e4.tm.widgets.Control;
import org.eclipse.e4.tm.widgets.ListViewer;
import org.eclipse.e4.tm.widgets.WidgetsPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>List Viewer</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.e4.tm.widgets.impl.ListViewerImpl#getDataObjects <em>Data Objects</em>}</li>
 *   <li>{@link org.eclipse.e4.tm.widgets.impl.ListViewerImpl#getViewProvider <em>View Provider</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class ListViewerImpl extends ControlImpl implements ListViewer {
	/**
	 * The cached value of the '{@link #getDataObjects() <em>Data Objects</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataObjects()
	 * @generated
	 * @ordered
	 */
	protected EList<Object> dataObjects;

	/**
	 * The cached value of the '{@link #getViewProvider() <em>View Provider</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getViewProvider()
	 * @generated
	 * @ordered
	 */
	protected Control viewProvider;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListViewerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return WidgetsPackage.Literals.LIST_VIEWER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Object> getDataObjects() {
		if (dataObjects == null) {
			dataObjects = new EDataTypeEList<Object>(Object.class, this, WidgetsPackage.LIST_VIEWER__DATA_OBJECTS);
		}
		return dataObjects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Control getViewProvider() {
		return viewProvider;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetViewProvider(Control newViewProvider, NotificationChain msgs) {
		Control oldViewProvider = viewProvider;
		viewProvider = newViewProvider;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER, oldViewProvider, newViewProvider);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setViewProvider(Control newViewProvider) {
		if (newViewProvider != viewProvider) {
			NotificationChain msgs = null;
			if (viewProvider != null)
				msgs = ((InternalEObject)viewProvider).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER, null, msgs);
			if (newViewProvider != null)
				msgs = ((InternalEObject)newViewProvider).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER, null, msgs);
			msgs = basicSetViewProvider(newViewProvider, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER, newViewProvider, newViewProvider));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER:
				return basicSetViewProvider(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case WidgetsPackage.LIST_VIEWER__DATA_OBJECTS:
				return getDataObjects();
			case WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER:
				return getViewProvider();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case WidgetsPackage.LIST_VIEWER__DATA_OBJECTS:
				getDataObjects().clear();
				getDataObjects().addAll((Collection<? extends Object>)newValue);
				return;
			case WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER:
				setViewProvider((Control)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case WidgetsPackage.LIST_VIEWER__DATA_OBJECTS:
				getDataObjects().clear();
				return;
			case WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER:
				setViewProvider((Control)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case WidgetsPackage.LIST_VIEWER__DATA_OBJECTS:
				return dataObjects != null && !dataObjects.isEmpty();
			case WidgetsPackage.LIST_VIEWER__VIEW_PROVIDER:
				return viewProvider != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (dataObjects: ");
		result.append(dataObjects);
		result.append(')');
		return result.toString();
	}

} //ListViewerImpl
