/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.util.impl;

import org.eclipse.e4.tm.util.UtilFactory;
import org.eclipse.e4.tm.util.UtilPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UtilFactoryImpl
extends EFactoryImpl
implements UtilFactory {
    public static UtilFactory init() {
        try {
            UtilFactory theUtilFactory = (UtilFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/e4/tm/util.ecore");
            if (theUtilFactory != null) {
                return theUtilFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new UtilFactoryImpl();
    }

    public EObject create(EClass eClass) {
        eClass.getClassifierID();
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.createLimitedStringFromString(eDataType, initialValue);
            }
            case 1: {
                return this.createURIFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.convertLimitedStringToString(eDataType, instanceValue);
            }
            case 1: {
                return this.convertURIToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    private String createLimitedStringFromStringHelper(EDataType eDataType, String initialValue) {
        String pattern = EcoreUtil.getAnnotation((EModelElement)eDataType, (String)"http://www.eclipse.org/e4/tm/util.ecore", (String)"stringPattern");
        if (pattern == null || pattern.length() == 0) {
            pattern = ".+";
        }
        if (!initialValue.matches(pattern)) {
            return null;
        }
        return (String)super.createFromString(eDataType, initialValue);
    }

    private String convertLimitedStringToStringHelper(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public String createLimitedStringFromString(EDataType eDataType, String initialValue) {
        return this.createLimitedStringFromStringHelper(eDataType, initialValue);
    }

    public String convertLimitedStringToString(EDataType eDataType, Object instanceValue) {
        return this.convertLimitedStringToStringHelper(eDataType, instanceValue);
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return (URI)super.createFromString(eDataType, initialValue);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public UtilPackage getUtilPackage() {
        return (UtilPackage)this.getEPackage();
    }

    @Deprecated
    public static UtilPackage getPackage() {
        return UtilPackage.eINSTANCE;
    }
}

