/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.examples.css.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.exceptions.DOMExceptionImpl;
import org.eclipse.e4.ui.css.core.serializers.CSSHTMLSerializerConfiguration;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializer;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializerConfiguration;

public abstract class AbstractCSSEditor {
    protected CSSEngine engine;
    protected CSSSerializer serializer;
    protected String nativeWidgetDir;
    protected List cssFiles = new ArrayList();

    protected AbstractCSSEditor(String nativeWidgetDir) {
        this.nativeWidgetDir = nativeWidgetDir;
    }

    protected CSSEngine getCSSEngine() {
        if (this.engine == null) {
            this.engine = this.createCSSEngine();
            this.engine.setErrorHandler(new CSSErrorHandler(){

                public void error(Exception e) {
                    AbstractCSSEditor.this.handleExceptions(e);
                }
            });
        } else {
            this.engine.reset();
        }
        if (this.isHTMLSelector()) {
            this.engine.setElementProvider(this.getHTMLElementProvider());
        } else {
            this.engine.setElementProvider(this.getNativeWidgetElementProvider());
        }
        return this.engine;
    }

    protected void applyStyles(Object widget) {
        try {
            Date d1 = new Date();
            this.engine = this.getCSSEngine();
            StringReader reader = new StringReader(this.getStyleSheetContent());
            this.engine.parseStyleSheet((Reader)reader);
            this.engine.applyStyles(widget, true, true);
            Date d2 = new Date();
            this.setCSSEngineStatuts("Apply style with " + (d2.getTime() - d1.getTime()) + "ms.");
        }
        catch (Exception ex) {
            this.handleExceptions(ex);
        }
    }

    protected void applyStyles() {
        if (this.mustApplyStylesToWindow()) {
            this.applyStyles(this.getWindowNativeWidget());
        } else {
            this.applyStyles(this.getLeftPanelNativeWidget());
        }
    }

    protected void fillTextareaWithStyleSheetContent(File file) {
        try {
            this.fillTextareaWithStyleSheetContent(new FileInputStream(file));
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    protected void fillTextareaWithStyleSheetContent(InputStream stream) {
        try {
            StringWriter writer = new StringWriter();
            InputStreamReader streamReader = new InputStreamReader(stream);
            BufferedReader buffer = new BufferedReader(streamReader);
            String line = "";
            boolean b = false;
            while ((line = buffer.readLine()) != null) {
                if (b) {
                    writer.write("\n");
                }
                writer.write(line);
                b = true;
            }
            buffer.close();
            streamReader.close();
            String content = writer.toString();
            this.setStyleSheetContent(content);
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    protected void fillTextareaWithDefaultStyleSheetContent() {
        if (this.mustApplyStylesToWindow()) {
            this.fillTextareaWithDefaultStyleSheetContent(this.getWindowNativeWidget());
        } else {
            this.fillTextareaWithDefaultStyleSheetContent(this.getLeftPanelNativeWidget());
        }
    }

    protected void fillTextareaWithDefaultStyleSheetContent(Object widget) {
        if (this.serializer == null) {
            this.serializer = new CSSSerializer();
        }
        StringWriter writer = new StringWriter();
        try {
            CSSSerializerConfiguration configuration = this.isHTMLSelector() ? this.getCSSHTMLSerializerConfiguration() : this.getCSSNativeWidgetSerializerConfiguration();
            this.serializer.serialize((Writer)writer, this.getCSSEngine(), widget, true, configuration);
            this.setStyleSheetContent(writer.toString());
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    protected void applyStylesFromSelectedFile() {
        int index = this.getCSSFilesWidgetSelectionIndex();
        if (index == -1 && this.getCSSFilesWidgetItemCount() > 1) {
            index = 1;
            this.selectCSSFilesWidget(index);
        }
        if (index < 1) {
            this.setStyleSheetContent("");
            return;
        }
        File file = (File)this.cssFiles.get(index - 1);
        this.fillTextareaWithStyleSheetContent(file);
    }

    protected void populateCSSFiles() {
        this.removeAllCSSFilesWidget();
        int size = this.cssFiles.size();
        int i = 0;
        while (i < size) {
            this.cssFiles.remove(0);
            ++i;
        }
        this.addItemCSSFilesWidget("None");
        File baseDir = this.getBaseStyleDir();
        File[] files = baseDir.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            File file = files[i2];
            if (file.isFile()) {
                this.addItemCSSFilesWidget(file.getName());
                this.cssFiles.add(file);
            }
            ++i2;
        }
    }

    protected void handleExceptions(Exception e) {
        if (this.isPropertyValueError(e)) {
            return;
        }
        e.printStackTrace();
    }

    protected boolean isPropertyValueError(Exception e) {
        if (!(e instanceof DOMExceptionImpl)) {
            return false;
        }
        DOMExceptionImpl domE = (DOMExceptionImpl)e;
        return domE.code == 15;
    }

    protected File getBaseStyleDir() {
        if (this.isHTMLSelector()) {
            return new File(String.valueOf(this.getBaseStyleDirName()) + "/html");
        }
        if (this.nativeWidgetDir != null) {
            return new File(String.valueOf(this.getBaseStyleDirName()) + "/" + this.nativeWidgetDir);
        }
        return new File(this.getBaseStyleDirName());
    }

    protected String getBaseStyleDirName() {
        return "styles";
    }

    protected abstract CSSEngine createCSSEngine();

    protected abstract boolean isHTMLSelector();

    protected abstract IElementProvider getNativeWidgetElementProvider();

    protected abstract IElementProvider getHTMLElementProvider();

    protected abstract String getStyleSheetContent();

    protected abstract void setStyleSheetContent(String var1);

    protected abstract void setCSSEngineStatuts(String var1);

    protected abstract boolean mustApplyStylesToWindow();

    protected abstract Object getWindowNativeWidget();

    protected abstract Object getLeftPanelNativeWidget();

    protected abstract CSSSerializerConfiguration getCSSNativeWidgetSerializerConfiguration();

    protected CSSSerializerConfiguration getCSSHTMLSerializerConfiguration() {
        return CSSHTMLSerializerConfiguration.INSTANCE;
    }

    protected abstract int getCSSFilesWidgetSelectionIndex();

    protected abstract int getCSSFilesWidgetItemCount();

    protected abstract void selectCSSFilesWidget(int var1);

    protected abstract void removeAllCSSFilesWidget();

    protected abstract void addItemCSSFilesWidget(String var1);
}

