/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.SWTElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.e4.ui.widgets.ETabFolder;
import org.eclipse.e4.ui.widgets.ETabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ETabItemTest
extends CSSSWTTestCase {
    private CSSEngine engine;
    private Shell shell;

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        super.tearDown();
    }

    private void spinEventLoop() {
        while (this.shell.getDisplay().readAndDispatch()) {
        }
    }

    private ETabFolder createFolder(Composite composite) {
        ETabFolder folderToTest = new ETabFolder(composite, 2048);
        int i = 0;
        while (i < 4) {
            ETabItem item = new ETabItem(folderToTest, 0);
            item.setText("Item " + i);
            Button control = new Button((Composite)folderToTest, 8);
            item.setControl((Control)control);
            ++i;
        }
        return folderToTest;
    }

    private ETabFolder createTestTabFolder() {
        return this.createTestTabFolder(true);
    }

    private ETabFolder createTestTabFolder(boolean open) {
        Display display = Display.getDefault();
        this.shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        ETabFolder folderToTest = this.createFolder((Composite)this.shell);
        if (open) {
            this.shell.open();
        }
        return folderToTest;
    }

    private ETabFolder createTestTabFolder(String styleSheet) {
        return this.createTestTabFolder(styleSheet, true);
    }

    protected ETabFolder createTestTabFolder(String styleSheet, boolean open) {
        ETabFolder folder = this.createTestTabFolder(open);
        this.engine = this.createEngine(styleSheet, folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        return folder;
    }

    public void testFontRegular() throws Exception {
        ETabFolder folder = this.createTestTabFolder("Button { font-family: Verdana; font-size: 12 }\nETabItem { font-family: Verdana; font-size: 16 }");
        this.spinEventLoop();
        ETabItem[] items = folder.getETabItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            ETabItemTest.assertEquals((String)"Verdana", (String)fontData.getName());
            ETabItemTest.assertEquals((int)16, (int)fontData.getHeight());
            ETabItemTest.assertEquals((int)0, (int)fontData.getStyle());
            ETabItemTest.assertEquals((String)"Verdana", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-family", null));
            ETabItemTest.assertEquals((String)"16", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-size", null));
            Control button = items[i].getControl();
            fontData = button.getFont().getFontData()[0];
            ETabItemTest.assertEquals((String)"Verdana", (String)fontData.getName());
            ETabItemTest.assertEquals((int)12, (int)fontData.getHeight());
            ETabItemTest.assertEquals((int)0, (int)fontData.getStyle());
            ++i;
        }
    }

    public void testFontBold() throws Exception {
        ETabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nETabItem { font-weight: bold }");
        this.spinEventLoop();
        ETabItem[] items = folder.getETabItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            ETabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            ETabItemTest.assertEquals((String)"bold", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-weight", null));
            Control button = items[i].getControl();
            fontData = button.getFont().getFontData()[0];
            ETabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            ++i;
        }
    }

    public void testFontItalic() throws Exception {
        ETabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nETabItem { font-style: italic }");
        this.spinEventLoop();
        ETabItem[] items = folder.getETabItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            ETabItemTest.assertEquals((int)2, (int)fontData.getStyle());
            ETabItemTest.assertEquals((String)"italic", (String)this.engine.retrieveCSSProperty((Object)items[i], "font-style", null));
            Control button = items[i].getControl();
            fontData = button.getFont().getFontData()[0];
            ETabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            ++i;
        }
    }

    private void testSelectedFontBold(ETabFolder folder, int selectionIndex) throws Exception {
        folder.setSelection(selectionIndex);
        this.spinEventLoop();
        ETabItem[] items = folder.getETabItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            if (i == selectionIndex) {
                ETabItemTest.assertEquals((int)1, (int)fontData.getStyle());
            } else {
                ETabItemTest.assertEquals((int)0, (int)fontData.getStyle());
            }
            ++i;
        }
    }

    public void testSelectedFontBold() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedFontBold(folder, i);
            ++i;
        }
    }

    public void testSelectedFontMerged() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { font-weight: normal; font-style: italic }\nETabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItem item = folder.getETabItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                ETabItemTest.assertEquals((int)3, (int)fd.getStyle());
            } else {
                ETabItemTest.assertEquals((int)2, (int)fd.getStyle());
            }
            ++i;
        }
    }

    public void testSelectedFontMerged2() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { font-style: italic }\nETabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItem item = folder.getETabItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                ETabItemTest.assertEquals((int)3, (int)fd.getStyle());
            } else {
                ETabItemTest.assertEquals((int)2, (int)fd.getStyle());
            }
            ++i;
        }
    }

    public void testSelectedFontMerged3() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { font-weight: bold }\nETabItem:selected { font-style: italic; font-weight: normal }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItem item = folder.getETabItem(i);
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                ETabItemTest.assertEquals((int)2, (int)fd.getStyle());
            } else {
                ETabItemTest.assertEquals((int)1, (int)fd.getStyle());
            }
            ++i;
        }
    }

    private void testShowClose(boolean showClose) throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { show-close: " + Boolean.toString(showClose) + " }");
        ETabItem[] items = folder.getETabItems();
        int i = 0;
        while (i < items.length) {
            ETabItemTest.assertEquals((boolean)showClose, (boolean)items[i].getShowClose());
            ETabItemTest.assertEquals((String)Boolean.toString(showClose), (String)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            ++i;
        }
    }

    public void testShowCloseFalse() throws Exception {
        this.testShowClose(false);
    }

    public void testShowCloseTrue() throws Exception {
        this.testShowClose(true);
    }

    public void testShowClose() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((boolean)true, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
        this.engine = this.createEngine("ETabItem { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((boolean)false, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    public void testShowClose2() throws Exception {
        ETabFolder folder = this.createTestTabFolder();
        ETabFolder folder2 = this.createFolder((Composite)folder.getShell());
        this.engine = this.createEngine("ETabItem { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((boolean)true, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            ETabItemTest.assertEquals((boolean)true, (boolean)folder2.getItem(i).getShowClose());
            ++i;
        }
        this.engine = this.createEngine("ETabItem { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((boolean)false, (boolean)folder.getItem(i).getShowClose());
            ++i;
        }
        i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((boolean)false, (boolean)folder2.getItem(i).getShowClose());
            ++i;
        }
    }

    private void testSelectedShowClose(ETabFolder folder, int index) {
        ETabItem[] items = folder.getETabItems();
        folder.setSelection(index);
        this.spinEventLoop();
        int i = 0;
        while (i < items.length) {
            if (i == index) {
                ETabItemTest.assertEquals((boolean)true, (boolean)items[i].getShowClose());
                ETabItemTest.assertEquals((String)"true", (String)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            } else {
                ETabItemTest.assertEquals((boolean)false, (boolean)items[i].getShowClose());
                ETabItemTest.assertEquals((String)"false", (String)this.engine.retrieveCSSProperty((Object)items[i], "show-close", null));
            }
            ++i;
        }
    }

    public void testSelectedShowClose() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem:selected { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedShowClose(folder, i);
            ++i;
        }
        this.engine = this.createEngine("ETabItem:selected { show-close: false }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertFalse((boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    public void testSelectedShowClose2() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { show-close: false }\nETabItem:selected { show-close: true }");
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedShowClose(folder, i);
            ++i;
        }
    }

    public void testClassSelectedShowClose() throws Exception {
        ETabFolder folder = this.createTestTabFolder();
        SWTElement.setCSSClass((Widget)folder, (String)"editorStack");
        CSSEngine engine = this.createEngine("ETabFolder.editorStack ETabItem { show-close: true }", folder.getDisplay());
        engine.applyStyles((Object)folder.getShell(), true);
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertTrue((boolean)folder.getItem(i).getShowClose());
            ++i;
        }
    }

    public void testFontsEditorStackClass() {
        FontData data;
        ETabItem item;
        ETabFolder folder = this.createTestTabFolder(false);
        ETabFolder folder2 = this.createFolder((Composite)folder.getShell());
        SWTElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("ETabItem { font-size: 10 }ETabItem:selected { font-size: 14; font-weight: bold }ETabFolder.editorStack ETabItem { font-size: 11; }ETabFolder.editorStack ETabItem:selected { font-size: 13; font-style: italic }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        ETabItemTest.assertNotNull((Object)folder.getSelection());
        ETabItemTest.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getETabItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                ETabItemTest.assertEquals((int)14, (int)data.getHeight());
                ETabItemTest.assertEquals((int)1, (int)data.getStyle());
            } else {
                ETabItemTest.assertEquals((int)10, (int)data.getHeight());
                ETabItemTest.assertEquals((int)0, (int)data.getStyle());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            data = item.getFont().getFontData()[0];
            ETabItemTest.assertEquals((int)11, (int)data.getHeight());
            ETabItemTest.assertEquals((int)0, (int)data.getStyle());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder2.getSelection()) {
                ETabItemTest.assertEquals((int)13, (int)data.getHeight());
                ETabItemTest.assertEquals((int)3, (int)data.getStyle());
            } else {
                ETabItemTest.assertEquals((int)11, (int)data.getHeight());
                ETabItemTest.assertEquals((int)0, (int)data.getStyle());
            }
            ++i;
        }
    }

    public void testFontsEditorStackClass2() {
        FontData data;
        ETabItem item;
        ETabFolder folder = this.createTestTabFolder(false);
        ETabFolder folder2 = this.createFolder((Composite)folder.getShell());
        SWTElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("ETabItem { font-size: 10 }ETabItem:selected { font-size: 14; font-weight: bold }ETabFolder.editorStack ETabItem { font-size: 11; }ETabFolder.editorStack ETabItem:selected { font-size: 13; font-weight: normal; font-style: italic }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        ETabItemTest.assertNotNull((Object)folder.getSelection());
        ETabItemTest.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getETabItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                ETabItemTest.assertEquals((int)14, (int)data.getHeight());
                ETabItemTest.assertEquals((int)1, (int)data.getStyle());
            } else {
                ETabItemTest.assertEquals((int)10, (int)data.getHeight());
                ETabItemTest.assertEquals((int)0, (int)data.getStyle());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            data = item.getFont().getFontData()[0];
            ETabItemTest.assertEquals((int)11, (int)data.getHeight());
            ETabItemTest.assertEquals((int)0, (int)data.getStyle());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            data = item.getFont().getFontData()[0];
            if (item == folder2.getSelection()) {
                ETabItemTest.assertEquals((int)13, (int)data.getHeight());
                ETabItemTest.assertEquals((int)2, (int)data.getStyle());
            } else {
                ETabItemTest.assertEquals((int)11, (int)data.getHeight());
                ETabItemTest.assertEquals((int)0, (int)data.getStyle());
            }
            ++i;
        }
    }

    public void testShowCloseEditorStack() {
        ETabItem item;
        ETabFolder folder = this.createTestTabFolder(false);
        ETabFolder folder2 = this.createFolder((Composite)folder.getShell());
        SWTElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("ETabItem { show-close: false }ETabItem:selected { show-close: true }ETabFolder.editorStack ETabItem { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        ETabItemTest.assertNotNull((Object)folder.getSelection());
        ETabItemTest.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getETabItem(i);
            if (item == folder.getSelection()) {
                ETabItemTest.assertTrue((boolean)item.getShowClose());
            } else {
                ETabItemTest.assertFalse((boolean)item.getShowClose());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            ETabItemTest.assertTrue((boolean)item.getShowClose());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            ETabItemTest.assertTrue((boolean)item.getShowClose());
            ++i;
        }
    }

    public void testShowCloseViewStack() {
        ETabItem item;
        ETabFolder folder = this.createTestTabFolder(false);
        ETabFolder folder2 = this.createFolder((Composite)folder.getShell());
        SWTElement.setCSSClass((Widget)folder2, (String)"viewStack");
        this.engine = this.createEngine("ETabItem { show-close: false }ETabItem:selected { show-close: true }ETabFolder.viewStack ETabItem { show-close: false }ETabFolder.viewStack ETabItem.selected { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        ETabItemTest.assertNotNull((Object)folder.getSelection());
        ETabItemTest.assertNull((Object)folder2.getSelection());
        int i = 0;
        while (i < folder.getItemCount()) {
            item = folder.getETabItem(i);
            if (item == folder.getSelection()) {
                ETabItemTest.assertTrue((boolean)item.getShowClose());
            } else {
                ETabItemTest.assertFalse((boolean)item.getShowClose());
            }
            ++i;
        }
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder2.getETabItem(i);
            ETabItemTest.assertFalse((boolean)item.getShowClose());
            ++i;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        i = 0;
        while (i < folder2.getItemCount()) {
            item = folder.getETabItem(i);
            if (item == folder.getSelection()) {
                ETabItemTest.assertTrue((boolean)item.getShowClose());
            } else {
                ETabItemTest.assertFalse((boolean)item.getShowClose());
            }
            ++i;
        }
    }

    public void testBackground() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { background-color: #0000ff }", false);
        ETabItemTest.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getUnselectedTabBackgroundColor().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((String)"#0000ff", (String)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", null));
            ++i;
        }
    }

    public void testBackground2() throws Exception {
        ETabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionBackground = folder.getSelectionBackground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionBackground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("ETabItem { background-color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        ETabItemTest.assertEquals((Object)rgb, (Object)folder.getUnselectedTabBackgroundColor().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((String)colour, (String)engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", null));
            ++i;
        }
        ETabItemTest.assertEquals((Object)preStyledSelectionBackground.getRGB(), (Object)folder.getSelectionBackground().getRGB());
    }

    public void testSelectionBackground() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem:selected { background-color: #00ff00 }", false);
        ETabItemTest.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionBackground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((String)"#00ff00", (String)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "background-color", "selected"));
            ++i;
        }
    }

    public void testForeground() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem { color: #0000ff }", false);
        ETabItemTest.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getForeground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((String)"#0000ff", (String)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "color", null));
            ++i;
        }
    }

    public void testForeground2() throws Exception {
        ETabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionForeground = folder.getSelectionForeground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionForeground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("ETabItem { color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        ETabItemTest.assertEquals((Object)rgb, (Object)folder.getForeground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((String)colour, (String)engine.retrieveCSSProperty((Object)folder.getItem(i), "color", null));
            ++i;
        }
        ETabItemTest.assertEquals((Object)preStyledSelectionForeground.getRGB(), (Object)folder.getSelectionForeground().getRGB());
    }

    public void testSelectionForeground() throws Exception {
        ETabFolder folder = this.createTestTabFolder("ETabItem:selected { color: #00ff00 }", false);
        ETabItemTest.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionForeground().getRGB());
        int i = 0;
        while (i < folder.getItemCount()) {
            ETabItemTest.assertEquals((String)"#00ff00", (String)this.engine.retrieveCSSProperty((Object)folder.getItem(i), "color", "selected"));
            ++i;
        }
    }
}

