/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MSashForm;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.workbench.RenderingTestCase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSashTest
extends RenderingTestCase {
    public void testSashWeights() {
        MWindow<MPart<?>> window = this.createSashWithNViews(2);
        this.topWidget = this.createModel((MPart)window);
        ((Shell)this.topWidget).layout(true);
        MPart sash = (MPart)window.getChildren().get(0);
        MSashTest.assertTrue((String)"Should be an MSash", (boolean)(sash instanceof MSashForm));
        MSashForm sf = (MSashForm)sash;
        EList wgts = sf.getWeights();
        MSashTest.assertTrue((String)"weight list muct not be null", (wgts != null ? 1 : 0) != 0);
        MSashTest.assertTrue((String)("expected count 2, was " + wgts.size()), (wgts.size() == 2 ? 1 : 0) != 0);
        Integer first = (Integer)wgts.get(0);
        Integer second = (Integer)wgts.get(1);
        MSashTest.assertTrue((String)"Values should be equal", (first.intValue() == second.intValue() ? 1 : 0) != 0);
        MContributedPart v1 = (MContributedPart)sf.getChildren().get(0);
        Composite c1 = (Composite)v1.getWidget();
        Rectangle r1 = c1.getBounds();
        MContributedPart v2 = (MContributedPart)sf.getChildren().get(1);
        Composite c2 = (Composite)v2.getWidget();
        Rectangle r2 = c2.getBounds();
        MSashTest.assertTrue((String)"SWT controls should be equal:", (r1.width == r2.width ? 1 : 0) != 0);
        SashForm sfw = (SashForm)sf.getWidget();
        int[] w = new int[]{75, 25};
        sfw.setWeights(w);
        sfw.layout(true);
        this.testWeights(sf, 75.0, 25.0);
        sf.getWeights().clear();
        sf.getWeights().add((Object)new Integer(40));
        sf.getWeights().add((Object)new Integer(60));
        this.testWeights(sf, 40.0, 60.0);
    }

    private void testWeights(MSashForm sf, double w1, double w2) {
        double baseRatio = w1 / w2;
        Integer sf1 = (Integer)sf.getWeights().get(0);
        Integer sf2 = (Integer)sf.getWeights().get(1);
        this.checkRatio("MSashForm", sf1, sf2, baseRatio);
        SashForm sfw = (SashForm)sf.getWidget();
        int[] sfwWghts = sfw.getWeights();
        this.checkRatio("SWT SashForm", sfwWghts[0], sfwWghts[1], baseRatio);
        Composite c1 = (Composite)sfw.getChildren()[0];
        Composite c2 = (Composite)sfw.getChildren()[1];
        this.checkRatio("Control Bounds", c1.getSize().y, c2.getSize().y, baseRatio);
    }

    private void checkRatio(String label, int num, int div, double baseRatio) {
        double ratio = (double)num / (double)div;
        double TOLERANCE = 0.1;
        boolean withinTolerance = Math.abs(ratio - baseRatio) < TOLERANCE;
        MSashTest.assertTrue((String)("Ratio mismatch on" + label + "weights"), (boolean)withinTolerance);
    }

    private MWindow<MPart<?>> createSashWithNViews(int n) {
        MWindow window = ApplicationFactory.eINSTANCE.createMWindow();
        window.setHeight(300);
        window.setWidth(401);
        window.setName("MyWindow");
        MSashForm sash = ApplicationFactory.eINSTANCE.createMSashForm();
        window.getChildren().add((Object)sash);
        int i = 0;
        while (i < n) {
            MContributedPart contributedPart = ApplicationFactory.eINSTANCE.createMContributedPart();
            contributedPart.setName("Sample View" + i);
            contributedPart.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
            sash.getChildren().add((Object)contributedPart);
            ++i;
        }
        return window;
    }
}

