/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MSashForm;
import org.eclipse.e4.ui.model.application.MStack;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.widgets.ETabFolder;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.e4.workbench.ui.renderers.AbstractPartRenderer;
import org.eclipse.e4.workbench.ui.renderers.PartRenderingEngine;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWindowTest
extends TestCase {
    private IEclipseContext appContext;
    private static IContributionFactory contributionFactory;
    private Widget topWidget;
    private Display display;

    private IEclipseContext getAppContext() {
        if (this.appContext == null) {
            IEclipseContext serviceContext = EclipseContextFactory.createServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
            this.appContext = Workbench.createWorkbenchContext((IEclipseContext)serviceContext, (IExtensionRegistry)RegistryFactory.getRegistry(), null, null);
            MApplication app = ApplicationFactory.eINSTANCE.createMApplication();
            this.appContext.set(MApplication.class.getName(), (Object)app);
        }
        return this.appContext;
    }

    static IContributionFactory getCFactory() {
        if (contributionFactory == null) {
            contributionFactory = new ReflectionContributionFactory(RegistryFactory.getRegistry());
        }
        return contributionFactory;
    }

    private Display getDisplay() {
        this.display = Display.getCurrent();
        if (this.display == null) {
            this.display = new Display();
        }
        return this.display;
    }

    protected void processEventLoop() {
        if (this.display != null) {
            while (this.display.readAndDispatch()) {
            }
        }
    }

    protected void tearDown() throws Exception {
        if (this.topWidget != null) {
            this.topWidget.dispose();
            this.topWidget = null;
        }
    }

    public void testCreateWindow() {
        final MWindow window = ApplicationFactory.eINSTANCE.createMWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setName("MyWindow");
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext context = MWindowTest.this.getAppContext();
                Workbench.initializeContext((IEclipseContext)context, (MPart)window);
                PartRenderingEngine renderer = new PartRenderingEngine(MWindowTest.getCFactory(), context);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderingEngine)renderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.getCFactory());
                Object o = renderer.createGui((MPart)window);
                MWindowTest.assertNotNull((Object)o);
                MWindowTest.this.topWidget = (Widget)o;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                MWindowTest.assertEquals((String)"MyWindow", (String)((Shell)MWindowTest.this.topWidget).getText());
                MWindowTest.assertEquals((Object)MWindowTest.this.topWidget, (Object)context.get("activeShell"));
            }
        });
    }

    public void testCreateView() {
        final MWindow<MPart<?>> window = this.createWindowWithOneView();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext context = MWindowTest.this.getAppContext();
                Workbench.initializeContext((IEclipseContext)context, (MPart)window);
                PartRenderingEngine renderer = new PartRenderingEngine(MWindowTest.getCFactory(), context);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderingEngine)renderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.getCFactory());
                Object o = renderer.createGui((MPart)window);
                MWindowTest.assertNotNull((Object)o);
                MWindowTest.this.topWidget = (Widget)o;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                Shell shell = (Shell)MWindowTest.this.topWidget;
                MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
                Control[] controls = shell.getChildren();
                MWindowTest.assertEquals((int)1, (int)controls.length);
                SashForm sash = (SashForm)controls[0];
                Control[] sashChildren = sash.getChildren();
                MWindowTest.assertEquals((int)1, (int)sashChildren.length);
                Composite marginHolder = (Composite)sashChildren[0];
                MWindowTest.assertEquals((int)1, (int)marginHolder.getChildren().length);
                ETabFolder folder = (ETabFolder)marginHolder.getChildren()[0];
                MWindowTest.assertEquals((int)1, (int)folder.getItemCount());
                Control c = folder.getItem(0).getControl();
                MWindowTest.assertTrue((boolean)(c instanceof Composite));
                Control[] viewPart = ((Composite)c).getChildren();
                MWindowTest.assertEquals((int)1, (int)viewPart.length);
                MWindowTest.assertTrue((boolean)(viewPart[0] instanceof Tree));
            }
        });
    }

    public void testContextChildren() {
        final MWindow<MPart<?>> window = this.createWindowWithOneView();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext context = MWindowTest.this.getAppContext();
                Workbench.initializeContext((IEclipseContext)context, (MPart)window);
                PartRenderingEngine renderer = new PartRenderingEngine(MWindowTest.getCFactory(), context);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderingEngine)renderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.getCFactory());
                Object o = renderer.createGui((MPart)window);
                MWindowTest.assertNotNull((Object)o);
                MWindowTest.this.topWidget = (Widget)o;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                Shell shell = (Shell)MWindowTest.this.topWidget;
                MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
                IEclipseContext child = (IEclipseContext)MWindowTest.this.appContext.getLocal("activeChild");
                MWindowTest.assertNotNull((Object)child);
                MWindowTest.assertEquals((Object)window.getContext(), (Object)child);
                MContributedPart modelPart = MWindowTest.this.getContributedPart(window);
                MWindowTest.assertNotNull((Object)modelPart);
                MWindowTest.assertEquals((Object)window, (Object)modelPart.getParent().getParent().getParent());
                AbstractPartRenderer factory = (AbstractPartRenderer)modelPart.getOwner();
                factory.activate((MPart)modelPart);
                IEclipseContext next = (IEclipseContext)child.getLocal("activeChild");
                while (next != null) {
                    child = next;
                    next = (IEclipseContext)child.getLocal("activeChild");
                }
                MWindowTest.assertFalse((window.getContext() == child ? 1 : 0) != 0);
                MContributedPart contextPart = (MContributedPart)child.get(MContributedPart.class.getName());
                MWindowTest.assertNotNull((Object)contextPart);
                MWindowTest.assertEquals((Object)window, (Object)contextPart.getParent().getParent().getParent());
            }
        });
    }

    public void testCreateMenu() {
        final MWindow<MPart<?>> window = this.createWindowWithOneViewAndMenu();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext context = MWindowTest.this.getAppContext();
                Workbench.initializeContext((IEclipseContext)context, (MPart)window);
                PartRenderingEngine renderer = new PartRenderingEngine(MWindowTest.getCFactory(), context);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderingEngine)renderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.getCFactory());
                Object o = renderer.createGui((MPart)window);
                MWindowTest.assertNotNull((Object)o);
                MWindowTest.this.topWidget = (Widget)o;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                Shell shell = (Shell)MWindowTest.this.topWidget;
                Menu menuBar = shell.getMenuBar();
                MWindowTest.assertNotNull((Object)menuBar);
                MWindowTest.assertEquals((int)1, (int)menuBar.getItemCount());
                MenuItem fileItem = menuBar.getItem(0);
                MWindowTest.assertEquals((String)"File", (String)fileItem.getText());
                Menu fileMenu = fileItem.getMenu();
                fileMenu.notifyListeners(22, null);
                MWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
                fileMenu.notifyListeners(23, null);
                MMenuItem item2Model = (MMenuItem)((MMenuItem)window.getMenu().getItems().get(0)).getMenu().getItems().get(1);
                item2Model.setVisible(false);
                fileMenu.notifyListeners(22, null);
                MWindowTest.assertEquals((int)1, (int)fileMenu.getItemCount());
                fileMenu.notifyListeners(23, null);
                item2Model.setVisible(true);
                fileMenu.notifyListeners(22, null);
                MWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
                fileMenu.notifyListeners(23, null);
            }
        });
    }

    private MContributedPart<MPart<?>> getContributedPart(MWindow<MPart<?>> window) {
        MPart part = (MPart)((MPart)((MPart)window.getChildren().get(0)).getChildren().get(0)).getChildren().get(0);
        MWindowTest.assertTrue((String)("part is incorrect type " + part), (boolean)(part instanceof MContributedPart));
        return (MContributedPart)part;
    }

    private MWindow<MPart<?>> createWindowWithOneView() {
        MWindow window = ApplicationFactory.eINSTANCE.createMWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setName("MyWindow");
        MSashForm sash = ApplicationFactory.eINSTANCE.createMSashForm();
        window.getChildren().add((Object)sash);
        MStack stack = ApplicationFactory.eINSTANCE.createMStack();
        sash.getChildren().add((Object)stack);
        MContributedPart contributedPart = ApplicationFactory.eINSTANCE.createMContributedPart();
        stack.getChildren().add((Object)contributedPart);
        contributedPart.setName("Sample View");
        contributedPart.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    private MWindow<MPart<?>> createWindowWithOneViewAndMenu() {
        MWindow<MPart<?>> window = this.createWindowWithOneView();
        MMenu menuBar = ApplicationFactory.eINSTANCE.createMMenu();
        window.setMenu(menuBar);
        MMenuItem fileItem = ApplicationFactory.eINSTANCE.createMMenuItem();
        fileItem.setName("File");
        fileItem.setId("file");
        menuBar.getItems().add((Object)fileItem);
        MMenu fileMenu = ApplicationFactory.eINSTANCE.createMMenu();
        fileItem.setMenu(fileMenu);
        MMenuItem item1 = ApplicationFactory.eINSTANCE.createMMenuItem();
        item1.setId("item1");
        item1.setName("item1");
        fileMenu.getItems().add((Object)item1);
        MMenuItem item2 = ApplicationFactory.eINSTANCE.createMMenuItem();
        item2.setId("item2");
        item2.setName("item2");
        fileMenu.getItems().add((Object)item2);
        return window;
    }
}

