/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.internal.application.MContributedPartImpl;
import org.eclipse.e4.ui.model.internal.application.MSashFormImpl;
import org.eclipse.e4.ui.model.internal.application.MStackImpl;
import org.eclipse.e4.ui.model.internal.application.MWindowImpl;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.tests.workbench.SWTResult;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.e4.workbench.ui.renderers.PartRenderingEngine;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;

public class RenderingTestCase
extends TestCase {
    protected static IContributionFactory contributionFactory = new ReflectionContributionFactory(RegistryFactory.getRegistry());
    protected static IEclipseContext serviceContext = EclipseContextFactory.createServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
    protected static MApplication<MWindow<?>> app = ApplicationFactory.eINSTANCE.createMApplication();
    protected static Display display = Display.getCurrent() != null ? Display.getCurrent() : new Display();
    protected PartRenderingEngine renderer;
    protected IEclipseContext appContext;
    protected Widget topWidget;
    protected long startTime;

    protected void setUp() throws Exception {
        System.out.println("Setup");
        this.startTime = System.currentTimeMillis();
        super.setUp();
        this.appContext = Workbench.createWorkbenchContext((IEclipseContext)serviceContext, (IExtensionRegistry)RegistryFactory.getRegistry(), null, null);
        this.appContext.set(MApplication.class.getName(), app);
        this.renderer = new PartRenderingEngine(contributionFactory, this.appContext);
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderingEngine)RenderingTestCase.this.renderer, (IEclipseContext)RenderingTestCase.this.appContext, (IContributionFactory)contributionFactory);
            }
        });
    }

    protected void tearDown() throws Exception {
        System.out.print("tearDown");
        super.tearDown();
        this.appContext = null;
        this.renderer = null;
        if (this.topWidget != null) {
            if (!this.topWidget.isDisposed()) {
                this.topWidget.dispose();
            }
            this.topWidget = null;
        }
        System.out.println("  time: " + (System.currentTimeMillis() - this.startTime) + "ms");
    }

    protected void processEventLoop() {
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    protected Widget createModel(final MPart modelRoot) {
        final Widget[] renderedObject = new Widget[]{null};
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                SWTResult expectedResults = RenderingTestCase.createSWTResultTree(modelRoot);
                Workbench.initializeContext((IEclipseContext)RenderingTestCase.this.appContext, (MPart)modelRoot);
                Object o = RenderingTestCase.this.renderer.createGui(modelRoot);
                RenderingTestCase.assertTrue((String)("No widget rendered for: " + modelRoot.toString()), (o != null ? 1 : 0) != 0);
                RenderingTestCase.assertTrue((String)("Rendered object is not a Widget: " + o.getClass().getName()), (boolean)(o instanceof Widget));
                renderedObject[0] = (Widget)o;
                RenderingTestCase.this.checkResults(expectedResults, renderedObject[0]);
            }
        });
        return renderedObject[0];
    }

    public void checkResults(SWTResult expected, Widget renderedObject) {
        RenderingTestCase.assertNotNull((String)("The Control is Null " + expected.clazz.getName()), (Object)renderedObject);
        boolean classOK = expected.clazz == renderedObject.getClass();
        RenderingTestCase.assertTrue((String)("Class mismatch; expected: " + expected.clazz.getName() + " actual: " + renderedObject.getClass().getName()), (boolean)classOK);
        if (expected.text != null && renderedObject instanceof Shell) {
            String shellText = ((Shell)renderedObject).getText();
            RenderingTestCase.assertTrue((String)("Text mismatch; expected: " + expected.text + " actual: " + shellText), (boolean)expected.text.equals(shellText));
        }
        if (!expected.kids.isEmpty() && renderedObject instanceof Composite) {
            Control[] controlKids = ((Composite)renderedObject).getChildren();
            if (renderedObject instanceof SashForm) {
                ArrayList<Control> nonSashes = new ArrayList<Control>();
                int i = 0;
                while (i < controlKids.length) {
                    if (!(controlKids[i] instanceof Sash)) {
                        nonSashes.add(controlKids[i]);
                    }
                    ++i;
                }
                controlKids = new Control[nonSashes.size()];
                int count = 0;
                for (Control ctrl : nonSashes) {
                    controlKids[count++] = ctrl;
                }
            }
            RenderingTestCase.assertTrue((String)("Child count mismatch; expected: " + expected.kids.size() + "actual: " + controlKids.length), (expected.kids.size() == controlKids.length ? 1 : 0) != 0);
            Iterator kidIter = expected.kids.iterator();
            Control[] controlArray = controlKids;
            int n = controlKids.length;
            int n2 = 0;
            while (n2 < n) {
                Control kid = controlArray[n2];
                SWTResult currKid = (SWTResult)kidIter.next();
                this.checkResults(currKid, (Widget)kid);
                ++n2;
            }
        }
    }

    public static SWTResult createSWTResultTree(MPart element) {
        if (!element.isVisible()) {
            return null;
        }
        Class<?> elementClass = element.getClass();
        Class<Shell> expectedClass = null;
        if (elementClass == MWindowImpl.class) {
            expectedClass = Shell.class;
        } else if (elementClass == MSashFormImpl.class) {
            expectedClass = SashForm.class;
        } else if (elementClass == MStackImpl.class) {
            expectedClass = CTabFolder.class;
        } else if (elementClass == MContributedPartImpl.class) {
            expectedClass = Composite.class;
        }
        String theName = null;
        if (element instanceof MItem) {
            theName = ((MItem)element).getName();
        }
        EList list = element.getChildren();
        SWTResult[] childList = null;
        if (!list.isEmpty()) {
            childList = new SWTResult[list.size()];
            int i = 0;
            while (i < list.size()) {
                childList[i] = RenderingTestCase.createSWTResultTree((MPart)list.get(i));
                ++i;
            }
        }
        return new SWTResult(expectedClass, theName, childList);
    }
}

