/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.widgets;

import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.widgets.ETabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ETabItem
extends CTabItem {
    public ETabItem(ETabFolder parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public ETabItem(ETabFolder parent, int style, int index) {
        super(parent, style, index);
    }

    public ETabFolder getETabParent() {
        return (ETabFolder)this.parent;
    }

    boolean useEllipses() {
        return false;
    }

    void drawSelected(GC gc) {
        Image image;
        boolean tabInPaint;
        if (!this.getETabParent().webbyStyle || this.parent.onBottom || this.parent.single) {
            super.drawSelected(gc);
            return;
        }
        int topOffset = this.getETabParent().getSelectedTabTopOffset();
        Point size = this.parent.getSize();
        int rightEdge = Math.min(this.x + this.width, this.parent.getRightItemEdge());
        int xx = this.parent.borderLeft;
        int yy = this.parent.borderTop + this.height + 1;
        int ww = size.x - this.parent.borderLeft - this.parent.borderRight;
        int hh = this.parent.highlight_header - 1;
        int[] shape = new int[]{xx, yy, xx + ww, yy, xx + ww, yy + hh, xx, yy + hh};
        if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
            this.parent.drawBackground(gc, shape, true);
        } else {
            gc.setBackground(this.parent.selectionBackground);
            gc.fillRectangle(xx, yy, ww, hh);
        }
        if (!this.showing) {
            int x1 = Math.max(0, this.parent.borderLeft - 1);
            int y1 = this.y + this.height;
            int x2 = size.x - this.parent.borderRight;
            gc.setForeground(this.getETabParent().tabBorderColor);
            gc.drawLine(x1, y1, x2, y1);
            return;
        }
        shape = null;
        int[] left = ETabFolder.E_TOP_LEFT_CORNER;
        int[] right = ETabFolder.E_TOP_RIGHT_CORNER;
        shape = new int[left.length + right.length + 8];
        int index = 0;
        shape[index++] = this.x;
        shape[index++] = this.y + this.height + 1;
        shape[index++] = this.x;
        shape[index++] = this.y + this.height + 1;
        int i = 0;
        while (i < left.length / 2) {
            shape[index++] = this.x + left[2 * i];
            shape[index++] = this.y + left[2 * i + 1] + topOffset;
            ++i;
        }
        i = 0;
        while (i < right.length / 2) {
            shape[index++] = rightEdge - 1 + right[2 * i];
            shape[index++] = this.y + right[2 * i + 1] + topOffset;
            ++i;
        }
        shape[index++] = rightEdge - 1;
        shape[index++] = this.y + this.height + 1;
        shape[index++] = rightEdge - 1;
        shape[index++] = this.y + this.height + 1;
        Rectangle clipping = gc.getClipping();
        Rectangle bounds = this.getBounds();
        ++bounds.height;
        if (this.parent.onBottom) {
            --bounds.y;
        }
        if (tabInPaint = clipping.intersects(bounds)) {
            if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                this.parent.drawBackground(gc, shape, true);
            } else {
                Color defaultBackground = this.parent.selectionBackground;
                Image image2 = this.parent.selectionBgImage;
                Color[] colors = this.parent.selectionGradientColors;
                int[] percents = this.parent.selectionGradientPercents;
                boolean vertical = this.parent.selectionGradientVertical;
                xx = this.x;
                yy = this.y + 1;
                ww = this.width;
                hh = this.height;
                this.parent.drawBackground(gc, shape, xx, yy, ww, hh, defaultBackground, image2, colors, percents, vertical);
            }
        }
        shape[0] = Math.max(0, this.parent.borderLeft - 1);
        shape[shape.length - 2] = size.x - this.parent.borderRight + 1;
        RGB inside = this.parent.selectionBackground.getRGB();
        if (this.parent.selectionBgImage != null || this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1) {
            inside = null;
        }
        RGB outside = this.parent.getBackground().getRGB();
        if (this.parent.gradientColors != null && this.parent.gradientColors.length > 1) {
            outside = null;
        }
        Color borderColor = this.getETabParent().tabBorderColor;
        this.parent.antialias(shape, borderColor.getRGB(), inside, outside, gc);
        gc.setForeground(borderColor);
        gc.drawPolyline(shape);
        if (!tabInPaint) {
            return;
        }
        int xDraw = this.x + 4;
        if (this.parent.single && (this.parent.showClose || this.showClose)) {
            xDraw += 18;
        }
        if ((image = this.getImage()) != null) {
            Rectangle imageBounds = image.getBounds();
            int maxImageWidth = rightEdge - xDraw - 4;
            if (!this.parent.single && this.closeRect.width > 0) {
                maxImageWidth -= this.closeRect.width + 4;
            }
            if (imageBounds.width < maxImageWidth) {
                int imageX = xDraw;
                int imageY = this.y + this.getETabParent().getTextMidline() - imageBounds.height / 2;
                gc.drawImage(image, imageX, imageY += this.parent.onBottom ? -1 : 1);
                xDraw += imageBounds.width + 4;
            }
        }
        int textWidth = rightEdge - xDraw - 4;
        if (!this.parent.single && this.closeRect.width > 0) {
            textWidth -= this.closeRect.width + 4;
        }
        if (textWidth > 0) {
            Font gcFont = gc.getFont();
            gc.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
                this.shortenedText = this.shortenText(gc, this.getText(), textWidth);
                this.shortenedTextWidth = textWidth;
            }
            Point extent = gc.textExtent(this.shortenedText, 9);
            int textY = this.y + this.getETabParent().getTextMidline() - extent.y / 2;
            int n = this.parent.onBottom ? -1 : 1;
            gc.setForeground(this.parent.selectionForeground);
            gc.drawText(this.shortenedText, xDraw, textY += n, 9);
            gc.setFont(gcFont);
            if (this.parent.isFocusControl()) {
                Display display = this.getDisplay();
                if (this.parent.simple || this.parent.single) {
                    gc.setBackground(display.getSystemColor(2));
                    gc.setForeground(display.getSystemColor(1));
                    gc.drawFocus(xDraw - 1, textY - 1, extent.x + 2, extent.y + 2);
                } else {
                    gc.setForeground(display.getSystemColor(17));
                    gc.drawLine(xDraw, textY + extent.y + 1, xDraw + extent.x + 1, textY + extent.y + 1);
                }
            }
        }
        if (this.parent.showClose || this.showClose) {
            this.drawClose(gc);
        }
    }

    void drawUnselected(GC gc) {
        Rectangle bounds;
        if (!this.showing) {
            return;
        }
        ETabFolder eTabParent = (ETabFolder)this.parent;
        if (!eTabParent.webbyStyle || this.parent.onBottom || this.parent.single) {
            super.drawUnselected(gc);
            return;
        }
        if (!this.showing) {
            return;
        }
        Rectangle clipping = gc.getClipping();
        if (!clipping.intersects(bounds = this.getBounds())) {
            return;
        }
        int[] shape = this.getUnselectedShape();
        ++bounds.height;
        Color defaultBackground = this.getETabParent().unselectedTabBackgroundColor;
        Color[] colors = new Color[]{this.getETabParent().unselectedTabBackgroundColor};
        int[] percents = new int[]{};
        boolean vertical = this.parent.selectionGradientVertical;
        int xx = this.x;
        int yy = this.y + 1;
        int ww = this.width;
        int hh = this.height;
        this.parent.drawBackground(gc, shape, xx, yy, ww, hh, defaultBackground, null, colors, percents, vertical);
        this.drawUnselectedBorder(gc, shape);
        int xDraw = this.x + 4;
        Image image = this.getImage();
        if (image != null && this.parent.showUnselectedImage) {
            Rectangle imageBounds = image.getBounds();
            int maxImageWidth = this.x + this.width - xDraw - 4;
            if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                maxImageWidth -= this.closeRect.width + 4;
            }
            if (imageBounds.width < maxImageWidth) {
                int imageX = xDraw;
                int imageHeight = imageBounds.height;
                int imageY = this.y + this.getETabParent().getTextMidline() - imageHeight / 2;
                int n = this.parent.onBottom ? -1 : 1;
                int imageWidth = imageBounds.width * imageHeight / imageBounds.height;
                gc.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, imageX, imageY += n, imageWidth, imageHeight);
                xDraw += imageWidth + 4;
            }
        }
        int textWidth = this.x + this.width - xDraw - 4;
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            textWidth -= this.closeRect.width + 4;
        }
        if (textWidth > 0) {
            Font gcFont = gc.getFont();
            gc.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
                this.shortenedText = this.shortenText(gc, this.getText(), textWidth);
                this.shortenedTextWidth = textWidth;
            }
            Point extent = gc.textExtent(this.shortenedText, 9);
            int textY = this.y + this.getETabParent().getTextMidline() - extent.y / 2;
            int n = this.parent.onBottom ? -1 : 1;
            gc.setForeground(this.parent.getForeground());
            gc.drawText(this.shortenedText, xDraw, textY += n, 9);
            gc.setFont(gcFont);
        }
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            this.drawClose(gc);
        }
    }

    int[] getUnselectedShape() {
        int[] shape = null;
        int[] left = ETabFolder.E_TOP_LEFT_CORNER;
        int[] right = ETabFolder.E_TOP_RIGHT_CORNER;
        int topOffset = this.getETabParent().getUnselectedTabTopOffset();
        shape = new int[left.length + 2 + right.length + 2];
        int index = 0;
        shape[index++] = this.x;
        shape[index++] = this.y + this.height;
        int i = 0;
        while (i < left.length / 2) {
            shape[index++] = this.x + left[2 * i];
            shape[index++] = this.y + left[2 * i + 1] + topOffset;
            ++i;
        }
        int startX = this.x + this.width - 1;
        int i2 = 0;
        while (i2 < right.length / 2) {
            shape[index++] = startX + right[2 * i2];
            shape[index++] = this.y + right[2 * i2 + 1] + topOffset;
            ++i2;
        }
        shape[index++] = startX;
        shape[index++] = this.y + this.height;
        return shape;
    }

    void drawUnselectedBorder(GC gc, int[] shape) {
        Color borderColor = this.getETabParent().tabBorderColor;
        gc.setForeground(borderColor);
        gc.drawPolyline(shape);
    }

    int preferredHeight(GC gc) {
        if (!this.getETabParent().webbyStyle || this.parent.onBottom || this.parent.single) {
            return super.preferredHeight(gc);
        }
        Image image = this.getImage();
        int h = image == null ? 0 : image.getBounds().height;
        String text = this.getText();
        if (this.font == null) {
            h = Math.max(h, gc.textExtent((String)text, (int)9).y);
        } else {
            Font gcFont = gc.getFont();
            gc.setFont(this.font);
            h = Math.max(h, gc.textExtent((String)text, (int)9).y);
            gc.setFont(gcFont);
        }
        int prefHeight = h + this.getETabParent().tabTopMargin + this.getETabParent().getMaxTabTopPadding() + this.getETabParent().tabBottomPadding;
        return prefHeight;
    }

    public Rectangle getBounds() {
        if (!this.getETabParent().webbyStyle || this.parent.onBottom || this.parent.single) {
            return super.getBounds();
        }
        int yy = this.parent.indexOf(this) == this.parent.selectedIndex ? this.getETabParent().getSelectedTabTopOffset() : this.getETabParent().getUnselectedTabTopOffset();
        int w = this.width;
        int h = this.height - yy;
        return new Rectangle(this.x, yy, w, h);
    }

    void debugPrintPolyline(boolean selected, int[] shape) {
        System.out.println(String.valueOf(selected ? "selected" : "unselected") + " polyline (" + this.getText() + "): ");
        int i = 0;
        while (i < shape.length) {
            System.out.print(shape[i]);
            System.out.print("@");
            System.out.print(shape[i + 1]);
            if (i != shape.length - 2) {
                System.out.print(", ");
            } else {
                System.out.println();
            }
            i += 2;
        }
    }

    void drawClose(GC gc) {
        if (this.closeRect.width == 0 || this.closeRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int indent = Math.max(1, 4);
        int x = this.closeRect.x + indent;
        int y = this.closeRect.y + indent;
        y += this.parent.onBottom ? -1 : 1;
        Color closeBorder = display.getSystemColor(17);
        switch (this.closeImageState) {
            case 1: {
                int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(this.getETabParent().getUnselectedTabBackgroundColor());
                gc.fillPolygon(shape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(shape);
                break;
            }
            case 2: {
                int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(this.parent.getFillColor());
                gc.fillPolygon(shape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(shape);
                break;
            }
            case 3: {
                int[] shape = new int[]{x + 1, y + 1, x + 3, y + 1, x + 5, y + 3, x + 6, y + 3, x + 8, y + 1, x + 10, y + 1, x + 10, y + 3, x + 8, y + 5, x + 8, y + 6, x + 10, y + 8, x + 10, y + 10, x + 8, y + 10, x + 6, y + 8, x + 5, y + 8, x + 3, y + 10, x + 1, y + 10, x + 1, y + 8, x + 3, y + 6, x + 3, y + 5, x + 1, y + 3};
                gc.setBackground(this.parent.getFillColor());
                gc.fillPolygon(shape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(shape);
                break;
            }
            case 0: {
                int[] shape = new int[]{x, y, x + 10, y, x + 10, y + 10, x, y + 10};
                if (this.parent.gradientColors != null && !this.parent.gradientVertical) {
                    this.parent.drawBackground(gc, shape, false);
                    break;
                }
                Color defaultBackground = this.getETabParent().getUnselectedTabBackgroundColor();
                Color[] colors = this.parent.gradientColors;
                int[] percents = this.parent.gradientPercents;
                boolean vertical = this.parent.gradientVertical;
                this.parent.drawBackground(gc, shape, x, y, 10, 10, defaultBackground, null, colors, percents, vertical);
            }
        }
    }
}

