/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.internal.services.ContextCommandService;
import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.workbench.MWorkbenchWindow;
import org.eclipse.e4.ui.model.workbench.WorkbenchPackage;
import org.eclipse.e4.ui.services.ECommandService;
import org.eclipse.e4.ui.services.EHandlerService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.workbench.ui.IExceptionHandler;
import org.eclipse.e4.workbench.ui.IWorkbench;
import org.eclipse.e4.workbench.ui.IWorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.ActiveChildLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ActiveChildOutputFunction;
import org.eclipse.e4.workbench.ui.internal.ActivePartLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.UISchedulerStrategy;
import org.eclipse.e4.workbench.ui.internal.WorkbenchLogger;
import org.eclipse.e4.workbench.ui.renderers.AbstractPartRenderer;
import org.eclipse.e4.workbench.ui.renderers.PartRenderingEngine;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbench
implements IWorkbench {
    public static final String LOCAL_ACTIVE_SHELL = "localActiveShell";
    public static final String ID = "org.eclipse.e4.workbench.fakedWBWindow";
    private MApplication<? extends MWindow> workbench;
    private static final boolean saveAndRestore = true;
    private File workbenchData;
    private IWorkbenchWindowHandler windowHandler;
    private final IExtensionRegistry registry;
    private ResourceSetImpl resourceSet;
    private PartRenderingEngine renderer;
    private int rv;
    private ExceptionHandler exceptionHandler;
    private IEclipseContext workbenchContext;
    private ReflectionContributionFactory contributionFactory;

    public IEclipseContext getContext() {
        return this.workbenchContext;
    }

    public Workbench(Location instanceLocation, IExtensionRegistry registry, PackageAdmin packageAdmin, IEclipseContext applicationContext, IWorkbenchWindowHandler windowHandler) {
        this.windowHandler = windowHandler;
        this.exceptionHandler = new ExceptionHandler();
        this.registry = registry;
        try {
            this.workbenchData = new File(URIUtil.toURI((URL)instanceLocation.getURL()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.workbenchData = new File(this.workbenchData, ".metadata");
        this.workbenchData = new File(this.workbenchData, ".plugins");
        this.workbenchData = new File(this.workbenchData, "org.eclipse.e4.workbench");
        this.workbenchData = new File(this.workbenchData, "workbench.xmi");
        this.contributionFactory = new ReflectionContributionFactory(registry);
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2008/Workbench", (Object)WorkbenchPackage.eINSTANCE);
        this.workbenchContext = Workbench.createWorkbenchContext(applicationContext, registry, this.exceptionHandler, this.contributionFactory);
        this.workbenchContext.set(Workbench.class.getName(), (Object)this);
        this.workbenchContext.set(IWorkbench.class.getName(), (Object)this);
    }

    public void setWorkbenchModel(MApplication<? extends MWindow> model) {
        this.workbench = model;
        this.init();
    }

    public void setWorkbenchModelURI(URI workbenchXmiURI) {
        this.createWorkbenchModel(workbenchXmiURI);
    }

    public static IEclipseContext createWorkbenchContext(final IEclipseContext applicationContext, IExtensionRegistry registry, IExceptionHandler exceptionHandler, IContributionFactory contributionFactory) {
        Activator.trace("/trace/eclipse.context", "createWorkbenchContext: initialize the workbench context with needed services", null);
        final IEclipseContext mainContext = EclipseContextFactory.create((IEclipseContext)applicationContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
        mainContext.set(Logger.class.getName(), ContextInjectionFactory.inject((Object)((Object)new WorkbenchLogger()), (IEclipseContext)mainContext));
        mainContext.set("debugString", (Object)"WorkbenchContext");
        if (contributionFactory != null) {
            mainContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        }
        mainContext.set(CommandManager.class.getName(), (Object)new CommandManager());
        mainContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        mainContext.set(ECommandService.class.getName(), (Object)new ContextCommandService(mainContext));
        mainContext.set("activeContexts", (Object)new ActiveContextsFunction());
        mainContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        mainContext.runAndTrack(new Runnable(){

            public void run() {
                Object o = mainContext.get("e4ActivePart");
                if (o instanceof MContributedPart) {
                    mainContext.set("activePartId", (Object)((MContributedPart)o).getId());
                }
            }

            public String toString() {
                return "activePartId";
            }
        });
        mainContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        mainContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        mainContext.set("selection", (Object)new ActiveChildOutputFunction("selection"));
        mainContext.set("input", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                Object adapted;
                IAdapterManager adapters;
                Class adapterType = null;
                if (arguments.length > 0 && arguments[0] instanceof Class) {
                    adapterType = (Class)arguments[0];
                }
                Object newInput = null;
                Object newValue = mainContext.get("selection");
                if (adapterType == null || adapterType.isInstance(newValue)) {
                    newInput = newValue;
                } else if (newValue != null && adapterType != null && (adapters = (IAdapterManager)applicationContext.get(IAdapterManager.class.getName())) != null && (adapted = adapters.loadAdapter(newValue, adapterType.getName())) != null) {
                    newInput = adapted;
                }
                return newInput;
            }
        });
        mainContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", LOCAL_ACTIVE_SHELL));
        Workbench.initializeNullStyling(mainContext);
        return mainContext;
    }

    private MApplication<? extends MWindow> createWorkbenchModel(URI applicationDefinitionInstance) {
        boolean restore;
        URI restoreLocation = null;
        if (this.workbenchData != null) {
            restoreLocation = URI.createFileURI((String)this.workbenchData.getAbsolutePath());
        }
        long restoreLastModified = restoreLocation == null ? 0L : new File(restoreLocation.toFileString()).lastModified();
        long appLastModified = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map attributes = resourceSetImpl.getURIConverter().getAttributes(applicationDefinitionInstance, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object timestamp = attributes.get("timeStamp");
        if (timestamp instanceof Long) {
            appLastModified = (Long)timestamp;
        } else if (applicationDefinitionInstance.isPlatformPlugin()) {
            try {
                URL url = new URL(applicationDefinitionInstance.toString());
                Object[] obj = PlatformURLPluginConnection.parse((String)url.getFile().trim(), (URL)url);
                Bundle b = (Bundle)obj[0];
                URLConnection openConnection = b.getResource((String)obj[1]).openConnection();
                appLastModified = openConnection.getLastModified();
            }
            catch (Exception exception) {}
        }
        boolean bl = restore = restoreLastModified > appLastModified;
        if (restore) {
            Activator.trace("/trace/workbench", "Restoring workbench: " + restoreLocation, null);
            this.workbench = (MApplication)resourceSetImpl.getResource(restoreLocation, true).getContents().get(0);
        } else {
            Activator.trace("/trace/workbench", "Initializing workbench: " + applicationDefinitionInstance, null);
            XMIResourceImpl resource = new XMIResourceImpl();
            this.workbench = this.loadDefaultModel(applicationDefinitionInstance);
            resource.getContents().add(this.workbench);
            resource.setURI(restoreLocation);
        }
        this.init();
        return this.workbench;
    }

    private MApplication<? extends MWindow> loadDefaultModel(URI defaultModelPath) {
        Resource resource = new ResourceSetImpl().getResource(defaultModelPath, true);
        MApplication app = (MApplication)resource.getContents().get(0);
        EList windows = app.getWindows();
        for (MWindow window : windows) {
            this.processPartContributions(resource, window);
        }
        return app;
    }

    private void processPartContributions(Resource resource, MWindow mWindow) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        String extId = "org.eclipse.e4.workbench.parts";
        IConfigurationElement[] parts = registry.getConfigurationElementsFor(extId);
        int i = 0;
        while (i < parts.length) {
            MContributedPart part = ApplicationFactory.eINSTANCE.createMContributedPart();
            part.setName(parts[i].getAttribute("label"));
            part.setIconURI("platform:/plugin/" + parts[i].getContributor().getName() + "/" + parts[i].getAttribute("icon"));
            part.setURI("platform:/plugin/" + parts[i].getContributor().getName() + "/" + parts[i].getAttribute("class"));
            String parentId = parts[i].getAttribute("parentId");
            MPart parent = (MPart)this.findObject((TreeIterator<EObject>)resource.getAllContents(), parentId);
            if (parent != null) {
                parent.getChildren().add((Object)part);
            }
            ++i;
        }
    }

    private EObject findObject(TreeIterator<EObject> it, String id) {
        while (it.hasNext()) {
            EObject el = (EObject)it.next();
            if (!(el instanceof MApplicationElement) || !el.eResource().getURIFragment(el).equals(id)) continue;
            return el;
        }
        return null;
    }

    private void init() {
        Activator.trace("/trace/workbench", "init() workbench", null);
        this.workbenchContext.set(MApplication.class.getName(), this.workbench);
        this.workbench.setContext(this.workbenchContext);
        Activator.trace("/trace/commands", "Initialize service from model", null);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category cat = cs.getCategory(MApplication.class.getName());
        cat.define("Application Category", null);
        EList commands = this.workbench.getCommand();
        for (MCommand cmd : commands) {
            String id = cmd.getId();
            String name = cmd.getName();
            Command command = cs.getCommand(id);
            command.define(name, null, cat);
        }
        for (MWindow window : this.workbench.getWindows()) {
            Workbench.initializeContext(this.workbenchContext, window);
        }
        this.workbench.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (ApplicationPackage.Literals.MAPPLICATION__WINDOWS.equals(msg.getFeature()) && msg.getEventType() == 3) {
                    MPart added = (MPart)msg.getNewValue();
                    Workbench.initializeContext(Workbench.this.workbenchContext, added);
                }
            }
        });
    }

    public static void initializeContext(IEclipseContext parentContext, MPart<?> part) {
        Class<?>[] interfaces;
        IEclipseContext context;
        if (part.getContext() != null) {
            context = part.getContext();
        } else {
            context = EclipseContextFactory.create((IEclipseContext)parentContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
            context.set("debugString", (Object)("PartContext(" + part + ')'));
        }
        Activator.trace("/trace/eclipse.context", "initializeContext(" + parentContext.toString() + ", " + part + ")", null);
        Class<?>[] classArray = interfaces = part.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace("/trace/eclipse.context", "Adding " + intf.getName() + " for " + part.getClass().getName(), null);
            context.set(intf.getName(), part);
            ++n2;
        }
        part.setContext(context);
        for (MPart child : part.getChildren()) {
            Workbench.initializeContext(context, child);
        }
        part.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (ApplicationPackage.Literals.MPART__CHILDREN.equals(msg.getFeature()) && msg.getEventType() == 3) {
                    MPart added = (MPart)msg.getNewValue();
                    Workbench.initializeContext(context, added);
                }
            }
        });
    }

    public void createUIFromModel() {
        EList windows = this.workbench.getWindows();
        for (MWindow wbw : windows) {
            this.createGUI((MPart)wbw);
        }
    }

    @Override
    public int run() {
        Activator.trace("/trace/workbench", "running event loop", null);
        this.windowHandler.runEvenLoop(((MWindow)this.workbench.getWindows().get(0)).getWidget());
        if (this.workbenchData != null && this.workbench != null) {
            try {
                Activator.trace("/trace/workbench", "Saving workbench: " + this.workbench.eResource().getURI(), null);
                this.workbench.eResource().save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.rv;
    }

    private void processHandlers(MPart<MPart<?>> part) {
        IEclipseContext context = part.getContext();
        if (context != null) {
            EHandlerService hs = (EHandlerService)context.get(EHandlerService.class.getName());
            EList handlers = part.getHandlers();
            for (MHandler handler : handlers) {
                String commandId = handler.getCommand().getId();
                if (handler.getObject() == null) {
                    handler.setObject(this.contributionFactory.create(handler.getURI(), context));
                }
                hs.activateHandler(commandId, handler.getObject());
            }
        }
        EList children = part.getChildren();
        for (MPart child : children) {
            this.processHandlers(child);
        }
    }

    public static void initializeRenderer(IExtensionRegistry registry, PartRenderingEngine r, IEclipseContext context, IContributionFactory f) {
        IConfigurationElement[] factories = registry.getConfigurationElementsFor("org.eclipse.e4.workbench.partfactory");
        int offset = 0;
        int i = 0;
        while (i < factories.length) {
            String clsSpec = factories[i].getAttribute("class");
            if (clsSpec.indexOf("Legacy") >= 0 || clsSpec.indexOf("PartSash") >= 0) {
                IConfigurationElement tmp = factories[offset];
                factories[offset++] = factories[i];
                factories[i] = tmp;
            }
            ++i;
        }
        i = 0;
        while (i < factories.length) {
            AbstractPartRenderer factory = null;
            try {
                factory = (AbstractPartRenderer)factories[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (factory != null) {
                factory.init(r, context, f);
                ContextInjectionFactory.inject((Object)factory, (IEclipseContext)context);
                r.addPartFactory(factory);
            }
            ++i;
        }
        context.set(PartRenderingEngine.SERVICE_NAME, (Object)r);
    }

    public void createGUI(MPart part) {
        if (this.renderer == null) {
            this.renderer = new PartRenderingEngine(this.contributionFactory, this.workbenchContext);
            Workbench.initializeRenderer(this.registry, this.renderer, this.workbenchContext, this.contributionFactory);
        }
        this.renderer.createGui(part);
        if (part instanceof MWindow) {
            MWindow wbw = (MWindow)part;
            Object appWindow = wbw.getWidget();
            this.rv = 0;
            this.windowHandler.setBounds(appWindow, wbw.getX(), wbw.getY(), wbw.getWidth(), wbw.getHeight());
            this.windowHandler.layout(appWindow);
            this.windowHandler.open(appWindow);
            this.processHandlers((MPart<MPart<?>>)wbw);
        }
    }

    @Override
    public void close() {
        EList windows = this.workbench.getWindows();
        for (MWindow window : windows) {
            this.windowHandler.dispose(window.getWidget());
        }
    }

    public void closeWindow(MWorkbenchWindow workbenchWindow) {
        this.windowHandler.close(workbenchWindow.getWidget());
    }

    public Object getWindow() {
        return ((MWindow)this.workbench.getWindows().get(0)).getWidget();
    }

    private static void initializeNullStyling(IEclipseContext appContext) {
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }
        });
    }

    public MApplication getModel() {
        return this.workbench;
    }
}

