/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.renderers.AbstractPartRenderer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartRenderingEngine {
    private final List partFactories = new ArrayList();
    public static final String SERVICE_NAME = PartRenderingEngine.class.getName();
    public static final String FACTORY = "partFactory";
    private AdapterImpl visibilityListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (ApplicationPackage.Literals.MPART__VISIBLE.equals(msg.getFeature())) {
                AbstractPartRenderer parentFactory;
                if (msg.getOldBooleanValue() == msg.getNewBooleanValue()) {
                    return;
                }
                MPart changedPart = (MPart)msg.getNotifier();
                MPart parent = changedPart.getParent();
                AbstractPartRenderer abstractPartRenderer = parentFactory = parent != null ? PartRenderingEngine.this.getFactoryFor(parent) : null;
                if (parentFactory == null) {
                    return;
                }
                if (changedPart.isVisible()) {
                    Activator.trace("/trace/renderer", "visible -> true", null);
                    PartRenderingEngine.this.createGui(changedPart);
                } else {
                    Activator.trace("/trace/renderer", "visible -> false", null);
                    PartRenderingEngine.this.removeGui(changedPart);
                }
            }
        }
    };
    private AdapterImpl childrenListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (ApplicationPackage.Literals.MPART__CHILDREN.equals(msg.getFeature())) {
                MPart changedPart = (MPart)msg.getNotifier();
                AbstractPartRenderer factory = PartRenderingEngine.this.getFactoryFor(changedPart);
                if (factory == null) {
                    return;
                }
                if (msg.getEventType() == 3) {
                    Activator.trace("/trace/renderer", "Child Added", null);
                    MPart added = (MPart)msg.getNewValue();
                    if (!added.isVisible()) {
                        PartRenderingEngine.this.installLifeCycleHooks(added);
                        return;
                    }
                    if (added.getWidget() == null) {
                        PartRenderingEngine.this.createGui(added);
                    } else {
                        factory.childAdded(changedPart, added);
                    }
                } else if (msg.getEventType() == 4) {
                    Activator.trace("/trace/renderer", "Child Removed", null);
                    MPart removed = (MPart)msg.getOldValue();
                    if (!removed.isVisible()) {
                        return;
                    }
                    factory.childRemoved(changedPart, removed);
                }
            }
        }
    };
    private final IContributionFactory contributionFactory;
    private final IEclipseContext context;

    public PartRenderingEngine(IContributionFactory contributionFactory, IEclipseContext context) {
        this.contributionFactory = contributionFactory;
        this.context = context;
    }

    public void addPartFactory(AbstractPartRenderer factory) {
        this.partFactories.add(factory);
    }

    public Object createGui(MPart element, Object parent) {
        this.installLifeCycleHooks(element);
        if (!element.isVisible()) {
            return null;
        }
        Object newWidget = this.createWidget(element, parent);
        if (newWidget != null) {
            element.setWidget(newWidget);
            AbstractPartRenderer factory = this.getFactoryFor(element);
            factory.bindWidget(element, newWidget);
            this.hookControllerLogic(element);
            factory.processContents(element);
            factory.postProcess(element);
            if (element.getParent() instanceof MPart) {
                MPart parentElement = element.getParent();
                AbstractPartRenderer parentFactory = this.getFactoryFor(parentElement);
                parentFactory.childAdded(parentElement, element);
            }
        }
        return newWidget;
    }

    public Object createGui(MPart element) {
        Object parent = null;
        MPart parentME = element.getParent();
        if (parentME != null) {
            parent = parentME.getWidget();
        }
        return this.createGui(element, parent);
    }

    public void removeGui(MPart<?> element) {
        AbstractPartRenderer parentFactory;
        AbstractPartRenderer factory = this.getFactoryFor(element);
        assert (factory != null);
        MPart parent = element.getParent();
        AbstractPartRenderer abstractPartRenderer = parentFactory = parent != null ? this.getFactoryFor(parent) : null;
        if (parentFactory == null) {
            return;
        }
        parentFactory.childRemoved(element.getParent(), element);
        factory.disposeWidget(element);
    }

    private void installLifeCycleHooks(MPart<?> element) {
        if (!element.eAdapters().contains((Object)this.visibilityListener)) {
            element.eAdapters().add((Object)this.visibilityListener);
        }
        if (!element.eAdapters().contains((Object)this.childrenListener)) {
            element.eAdapters().add((Object)this.childrenListener);
        }
    }

    protected Object createWidget(MPart<?> element, Object parent) {
        for (AbstractPartRenderer factory : this.partFactories) {
            Object newWidget = factory.createWidget(element, parent);
            if (newWidget == null) continue;
            this.setFactoryFor(element, factory);
            this.processHandlers(element);
            return newWidget;
        }
        return null;
    }

    protected void processHandlers(MPart<?> element) {
        for (MHandler contributedHandler : element.getHandlers()) {
            if (contributedHandler.getURI() == null || contributedHandler.getObject() != null) continue;
            contributedHandler.setObject(this.contributionFactory.create(contributedHandler.getURI(), this.context));
        }
    }

    private void hookControllerLogic(MPart<?> element) {
        AbstractPartRenderer factory = this.getFactoryFor(element);
        if (factory != null) {
            factory.hookControllerLogic(element);
        }
    }

    protected void setFactoryFor(MPart element, AbstractPartRenderer factory) {
        element.setOwner((Object)factory);
    }

    protected AbstractPartRenderer getFactoryFor(MPart element) {
        return (AbstractPartRenderer)element.getOwner();
    }
}

