/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.emf;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.e4.xwt.emf.EMFBinding;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFDataProvider
extends AbstractDataProvider {
    private URI typeURI;
    private URI objectURI;
    private ResourceSet resourceSet;
    private String featureName;
    private EObject objectInstance;

    public IObservableValue createObservableValue(Object valueType, String path) {
        EObject eObj = this.getTarget();
        if (eObj != null && path != null) {
            EStructuralFeature feature;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = EMFBinding.getEObject(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                return EMFObservables.observeValue((Realm)XWT.getRealm(), (EObject)eObj, (EStructuralFeature)feature);
            }
        }
        return null;
    }

    public URI getObjectURI() {
        return this.objectURI;
    }

    public void setObjectURI(URI objectURI) {
        this.objectURI = objectURI;
    }

    public URI getTypeURI() {
        return this.typeURI;
    }

    public void setTypeURI(URI typeURI) {
        this.typeURI = typeURI;
    }

    public EObject getObjectInstance() {
        if (this.objectInstance == null) {
            if (this.objectURI != null) {
                this.objectInstance = this.getResourceSet().getEObject(this.objectURI, true);
            } else if (this.typeURI != null) {
                EClass eClass = (EClass)this.getResourceSet().getEObject(this.typeURI, true);
                this.objectInstance = eClass.getEPackage().getEFactoryInstance().create(eClass);
            }
        }
        return this.objectInstance;
    }

    protected ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    protected void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void setObjectInstance(EObject eObject) {
        this.objectInstance = eObject;
    }

    public EObject getTarget() {
        EObject eObj = this.getObjectInstance();
        if (eObj != null && this.featureName != null) {
            return EMFBinding.getEObject(eObj, this.featureName);
        }
        return eObj;
    }

    public Object getData(String path) {
        EObject eObj = this.getTarget();
        if (eObj != null && path != null) {
            EStructuralFeature feature;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = (EObject)this.getData(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                return eObj.eGet(feature);
            }
        }
        return null;
    }

    public boolean isPropertyReadOnly(String path) {
        EObject eObj = this.getTarget();
        if (eObj != null && path != null) {
            EStructuralFeature feature;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = (EObject)this.getData(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                return !feature.isChangeable();
            }
        }
        return true;
    }

    public Class<?> getDataType(String path) {
        EObject eObj = this.getTarget();
        if (eObj != null && path != null) {
            EStructuralFeature feature;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = EMFBinding.getEObject(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                return feature.getEType().getInstanceClass();
            }
        }
        return null;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Object getData(Object target, String path) {
        if (target instanceof EObject) {
            return EMFBinding.getEObject((EObject)target, path);
        }
        return null;
    }

    public void setData(String path, Object value) {
        this.setData(this.getTarget(), path, value);
    }

    public void setData(Object target, String path, Object value) {
        if (target instanceof EObject) {
            EStructuralFeature feature;
            EObject eObj = (EObject)target;
            String featureName = path;
            int index = path.lastIndexOf(".");
            if (index != -1) {
                String parent = path.substring(0, index);
                eObj = EMFBinding.getEObject(eObj, parent);
                featureName = path.substring(index + 1);
            }
            if ((feature = eObj.eClass().getEStructuralFeature(featureName)) != null) {
                eObj.eSet(feature, value);
            }
        }
    }
}

