/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.controls;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.controls.Control_Background;
import org.eclipse.e4.xwt.tests.controls.Control_Bounds;
import org.eclipse.e4.xwt.tests.controls.Control_Location;
import org.eclipse.e4.xwt.tests.controls.Control_Orientation;
import org.eclipse.e4.xwt.tests.controls.Control_Size;
import org.eclipse.e4.xwt.tests.controls.Control_Size_GridData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class ControlsTests
extends XWTTestCase {
    public void testControlLocation() throws Exception {
        URL url = ControlsTests.class.getResource(String.valueOf(Control_Location.class.getSimpleName()) + ".xwt");
        this.runTest(url);
    }

    public void testControlBackground() throws Exception {
        URL url = ControlsTests.class.getResource(String.valueOf(Control_Background.class.getSimpleName()) + ".xwt");
        this.runTest(url);
    }

    public void testControlBounds() throws Exception {
        URL url = ControlsTests.class.getResource(String.valueOf(Control_Bounds.class.getSimpleName()) + ".xwt");
        this.runTest(url);
    }

    public void testControlOrientation() throws Exception {
        URL url = ControlsTests.class.getResource(String.valueOf(Control_Orientation.class.getSimpleName()) + ".xwt");
        this.runTest(url);
    }

    public void testControlSize() throws Exception {
        URL url = ControlsTests.class.getResource(String.valueOf(Control_Size.class.getSimpleName()) + ".xwt");
        this.runTest(url, null, new Runnable(){

            public void run() {
                this.checkLabel();
                this.checkButton();
            }

            public void checkLabel() {
                Object element = XWT.findElementByName((Widget)ControlsTests.this.root, (String)"targetLabel");
                ControlsTests.assertTrue((boolean)(element instanceof Label));
                Label label = (Label)element;
                Point size = label.getSize();
                ControlsTests.assertTrue((size.x == 100 && size.y == 40 ? 1 : 0) != 0);
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Widget)ControlsTests.this.root, (String)"targetButton");
                ControlsTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                Point size = button.getSize();
                ControlsTests.assertTrue((size.x == 200 && size.y == 200 ? 1 : 0) != 0);
            }
        });
    }

    public void testControlSizeGridData() throws Exception {
        URL url = ControlsTests.class.getResource(String.valueOf(Control_Size_GridData.class.getSimpleName()) + ".xwt");
        this.runTest(url, null, new Runnable(){

            public void run() {
                this.checkLabel();
                this.checkButton();
            }

            public void checkLabel() {
                Object element = XWT.findElementByName((Widget)ControlsTests.this.root, (String)"targetLabel");
                ControlsTests.assertTrue((boolean)(element instanceof Label));
                Label label = (Label)element;
                Object data = label.getLayoutData();
                ControlsTests.assertTrue((boolean)(data instanceof GridData));
                GridData gridData = (GridData)data;
                ControlsTests.assertTrue((gridData.widthHint == 100 && gridData.heightHint == 40 ? 1 : 0) != 0);
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Widget)ControlsTests.this.root, (String)"targetButton");
                ControlsTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                Object data = button.getLayoutData();
                ControlsTests.assertTrue((boolean)(data instanceof GridData));
                GridData gridData = (GridData)data;
                ControlsTests.assertTrue((gridData.widthHint == 200 && gridData.heightHint == 200 ? 1 : 0) != 0);
            }
        });
    }
}

