/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.xml;

import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.e4.xwt.dataproviders.IXmlDataProvider;
import org.eclipse.e4.xwt.xml.XmlObservableValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDataProvider
extends AbstractDataProvider
implements IXmlDataProvider {
    static final String XDATA = "XData";
    private URL source;
    private String xPath;
    private Document document;

    public Document getDocument() {
        if (this.document == null) {
            try {
                String xdata;
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                if (this.source != null) {
                    this.document = builder.parse(this.source.openStream());
                }
                if ((xdata = this.getXDataContent()) != null) {
                    try {
                        this.document = builder.parse(new ByteArrayInputStream(xdata.getBytes()));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.document;
    }

    public URL getSource() {
        return this.source;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setSource(URL xmlSource) {
        this.source = xmlSource;
    }

    public void setXPath(String xPath) {
        this.xPath = xPath;
    }

    private Object getRoot() {
        Document doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        if (this.xPath != null) {
            return this.selectSingleNode(doc, this.xPath);
        }
        return doc;
    }

    private Object selectSingleNode(Node node, String path) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(path);
            return expr.evaluate(node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getData(Object object, String path) {
        if (object == null || path == null) {
            return null;
        }
        if (object instanceof Node) {
            Object selectObject = this.selectSingleNode((Node)object, path);
            return selectObject;
        }
        return object;
    }

    public Object getData(String path) {
        return this.getData(this.getRoot(), path);
    }

    public void setData(Object object, String path, Object value) {
    }

    public void setData(String path, Object value) {
    }

    public Class<?> getDataType(String path) {
        Object data = this.getData(path);
        if (data == null) {
            return null;
        }
        return data.getClass();
    }

    public IObservableValue createObservableValue(Object valueType, String path) {
        Object data = this.getData(path);
        if (data != null && data instanceof Node) {
            return new XmlObservableValue(valueType, (Node)data);
        }
        return null;
    }

    protected String getXDataContent() {
        Object xDataProperty = this.getProperty(XDATA);
        if (xDataProperty != null) {
            return xDataProperty.toString();
        }
        return null;
    }

    protected void setXDataContent(Object content) {
        this.setProperty(XDATA, content);
    }
}

