/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.animation;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class RepeatBehavior {
    private double iterationCount;
    private Duration repeatDuration;
    private RepeatBehaviorType type;

    RepeatBehavior() {
    }

    public RepeatBehavior(double count) {
        if (Double.isInfinite(count) || Double.isNaN(count) || count < 0.0) {
            throw new IllegalArgumentException("count: " + count);
        }
        try {
            this.repeatDuration = DatatypeFactory.newInstance().newDuration(0L);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        this.iterationCount = count;
        this.type = RepeatBehaviorType.IterationCount;
    }

    public RepeatBehavior(Duration duration) {
        this.iterationCount = 0.0;
        this.repeatDuration = duration;
        this.type = RepeatBehaviorType.RepeatDuration;
    }

    public boolean equals(Object value) {
        if (value instanceof RepeatBehavior) {
            return this.Equals((RepeatBehavior)value);
        }
        return false;
    }

    public boolean Equals(RepeatBehavior repeatBehavior) {
        if (this.type == repeatBehavior.type) {
            switch (this.type) {
                case IterationCount: {
                    return this.iterationCount == repeatBehavior.iterationCount;
                }
                case RepeatDuration: {
                    return this.repeatDuration == repeatBehavior.repeatDuration;
                }
                case Forever: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean Equals(RepeatBehavior repeatBehavior1, RepeatBehavior repeatBehavior2) {
        return repeatBehavior1.Equals(repeatBehavior2);
    }

    public int hashCode() {
        switch (this.type) {
            case IterationCount: {
                return (int)this.iterationCount;
            }
            case RepeatDuration: {
                return this.repeatDuration.hashCode();
            }
            case Forever: {
                return 2147483605;
            }
        }
        return super.hashCode();
    }

    String InternalToString(String format, IFormatProvider formatProvider) {
        switch (this.type) {
            case IterationCount: {
                StringBuilder builder1 = new StringBuilder();
                return builder1.toString();
            }
            case RepeatDuration: {
                return this.repeatDuration.toString();
            }
            case Forever: {
                return "Forever";
            }
        }
        return null;
    }

    public static boolean op_Equality(RepeatBehavior repeatBehavior1, RepeatBehavior repeatBehavior2) {
        return repeatBehavior1.Equals(repeatBehavior2);
    }

    public static boolean op_Inequality(RepeatBehavior repeatBehavior1, RepeatBehavior repeatBehavior2) {
        return !repeatBehavior1.Equals(repeatBehavior2);
    }

    public String toString(String format, IFormatProvider formatProvider) {
        return this.InternalToString(format, formatProvider);
    }

    public String toString() {
        return this.InternalToString(null, null);
    }

    public String ToString(IFormatProvider formatProvider) {
        return this.InternalToString(null, formatProvider);
    }

    public double getCount() {
        if (this.type != RepeatBehaviorType.IterationCount) {
            throw new UnsupportedOperationException();
        }
        return this.iterationCount;
    }

    public Duration getDuration() {
        if (this.type != RepeatBehaviorType.RepeatDuration) {
            throw new UnsupportedOperationException();
        }
        return this.repeatDuration;
    }

    public static RepeatBehavior getForever() {
        RepeatBehavior behavior1 = new RepeatBehavior();
        behavior1.type = RepeatBehaviorType.Forever;
        return behavior1;
    }

    public boolean getHasCount() {
        return this.type == RepeatBehaviorType.IterationCount;
    }

    public boolean getHasDuration() {
        return this.type == RepeatBehaviorType.RepeatDuration;
    }

    static interface IFormatProvider {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RepeatBehaviorType {
        IterationCount,
        RepeatDuration,
        Forever;

    }
}

