/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.core;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.core.EventTrigger;
import org.eclipse.e4.xwt.core.Setter;
import org.eclipse.e4.xwt.core.Trigger;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Style {
    protected Class<?> targetType;
    protected Collection<Setter> setters;
    protected Collection<TriggerBase> triggers;

    public Collection<TriggerBase> getTriggers() {
        if (this.triggers == null) {
            return Collections.EMPTY_LIST;
        }
        return this.triggers;
    }

    public void setTriggers(Collection<TriggerBase> triggers) {
        this.triggers = triggers;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }

    public Collection<Setter> getSetters() {
        if (this.setters == null) {
            return Collections.EMPTY_LIST;
        }
        return this.setters;
    }

    public void setSetters(Collection<Setter> setters) {
        this.setters = setters;
    }

    public void apply(Object target) {
        IMetaclass metaclass = XWT.getMetaclass(target);
        for (Setter setter : this.getSetters()) {
            String propName = setter.getProperty();
            String propValue = setter.getValue();
            IProperty prop = metaclass.findProperty(propName);
            if (prop == null || propValue == null) continue;
            Object value = XWT.convertFrom(prop.getType(), propValue);
            try {
                prop.setValue(target, value);
            }
            catch (Exception e) {
                LoggerManager.log(e);
            }
        }
        for (TriggerBase triggerBase : this.getTriggers()) {
            if (triggerBase instanceof EventTrigger) {
                EventTrigger eventTrigger = (EventTrigger)triggerBase;
                eventTrigger.apply(target);
                continue;
            }
            if (!(triggerBase instanceof Trigger)) continue;
            Trigger trigger = (Trigger)triggerBase;
            trigger.apply(target);
        }
    }
}

