/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.core.Setter;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.databinding.BeanObservableValue;
import org.eclipse.e4.xwt.databinding.ObservableValueUtil;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trigger
extends TriggerBase {
    protected String property;
    protected String sourceName;
    protected Object value;
    protected Collection<Setter> setters = new ArrayList<Setter>();

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Collection<Setter> getSetters() {
        return this.setters;
    }

    public void setSetters(Collection<Setter> setters) {
        this.setters = setters;
    }

    public void apply(final Object target) {
        if (this.property != null) {
            IObservableValue observableValue = ObservableValueUtil.createWidget(target, this.property);
            observableValue.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    Object newValue;
                    Class<?> valueType = BeanObservableValue.getValueType(target.getClass(), Trigger.this.property);
                    if (valueType == null) {
                        LoggerManager.log("Type of the property " + Trigger.this.property + " is not found in " + target.getClass().getName());
                        return;
                    }
                    IConverter converter = XWT.findConvertor(Trigger.this.value.getClass(), valueType);
                    Object realValue = Trigger.this.value;
                    if (converter != null) {
                        realValue = converter.convert(Trigger.this.value);
                    }
                    if (!(newValue = event.diff.getNewValue()).equals(realValue)) {
                        return;
                    }
                    IMetaclass metaclass = XWT.getMetaclass(target);
                    for (Setter setter : Trigger.this.getSetters()) {
                        String propName = setter.getProperty();
                        String propValue = setter.getValue();
                        IProperty prop = metaclass.findProperty(propName);
                        if (prop == null || propValue == null) continue;
                        Object toValue = XWT.convertFrom(prop.getType(), propValue);
                        try {
                            prop.setValue(target, toValue);
                        }
                        catch (Exception e) {
                            LoggerManager.log(e);
                        }
                    }
                }
            });
        }
    }
}

