/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IDataBindingInfo;
import org.eclipse.e4.xwt.databinding.BeanObservableValue;
import org.eclipse.e4.xwt.databinding.BeanObservableValueUtil;
import org.eclipse.e4.xwt.databinding.BindingContext;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;

public class ObjectBindingContext
extends BindingContext {
    private static Map<Object, ObjectBindingContext> bindingContext = new HashMap<Object, ObjectBindingContext>();
    private String propertyName;
    private Object observed;

    public void setNewValue(Object newValue) {
        if (newValue != null && newValue.getClass() == this.observed.getClass() && this.observeValue != null && this.propertyName != null && this.observeWidget != null) {
            Field[] fields;
            Field[] fieldArray = fields = this.observed.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectBindingContext bc;
                Field field = fieldArray[n2];
                Object oldPropertyValue = this.getPropertyValue(this.observed, field.getName());
                Object newPropertyValue = this.getPropertyValue(newValue, field.getName());
                if (oldPropertyValue != null && oldPropertyValue != newPropertyValue && (bc = bindingContext.get(oldPropertyValue)) != null) {
                    bc.setNewValue(newPropertyValue);
                }
                ++n2;
            }
            this.observeValue = BeanObservableValueUtil.observeValue(newValue, this.propertyName);
            this.addListener(newValue);
            this.observed = newValue;
            bindingContext.put(this.observed, this);
            if (this.observeWidget != null) {
                DataBindingContext bindingContext = new DataBindingContext();
                bindingContext.bindValue(this.observeWidget, this.observeValue, null, null);
            }
        }
    }

    private Object getPropertyValue(Object object, String propertyName) {
        try {
            Method getMethod1 = ObjectUtil.findGetter(object.getClass(), propertyName, null);
            if (getMethod1 != null) {
                return getMethod1.invoke(object, new Object[0]);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void applyNewValue(Object oldValue, Object newValue) {
        ObjectBindingContext bc = bindingContext.get(oldValue);
        if (bc == null) {
            if (oldValue.getClass() == newValue.getClass() && oldValue.getClass() != String.class) {
                Field[] fields;
                Field[] fieldArray = fields = oldValue.getClass().getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    Object oldPropertyValue = this.getPropertyValue(oldValue, field.getName());
                    Object newPropertyValue = this.getPropertyValue(newValue, field.getName());
                    if (oldPropertyValue != null && oldPropertyValue != newPropertyValue) {
                        this.applyNewValue(oldPropertyValue, newPropertyValue);
                    }
                    ++n2;
                }
            }
            return;
        }
        bc.setNewValue(newValue);
    }

    public void addListener(Object dataContext) {
        if (dataContext == null) {
            return;
        }
        PropertyChangeListener p = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue;
                Object oldValue = evt.getOldValue();
                if (oldValue == (newValue = evt.getNewValue())) {
                    return;
                }
                ObjectBindingContext.this.applyNewValue(oldValue, newValue);
            }
        };
        Class<?> dataContextClass = dataContext.getClass();
        Field[] fields = dataContextClass.getDeclaredFields();
        try {
            Method addListenerMethod = dataContextClass.getDeclaredMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            try {
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!PropertyChangeSupport.class.equals(field.getType())) {
                        addListenerMethod.invoke(dataContext, field.getName(), p);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                LoggerManager.log(e);
            }
        }
        catch (Exception exception) {}
    }

    public void addObservable(Object observable) {
        ObjectBindingContext bbc = new ObjectBindingContext();
        bbc.observed = observable;
        bbc.addListener(observable);
        bindingContext.put(observable, bbc);
    }

    public void bind(IObservableValue source, IObservableValue target, IDataBindingInfo dataBinding) {
        super.bind(source, target, dataBinding);
        if (source instanceof BeanObservableValue) {
            BeanObservableValue beanValue = (BeanObservableValue)source;
            this.propertyName = beanValue.getPropertyName();
        } else if (source instanceof IBeanObservable) {
            IBeanObservable beanValue = (IBeanObservable)source;
            this.propertyName = beanValue.getPropertyDescriptor().getName();
        }
        if (source instanceof IObserving) {
            this.observed = ((IObserving)source).getObserved();
            bindingContext.put(this.observed, this);
            this.addListener(this.observed);
        }
    }
}

