/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.databinding.Event;
import org.eclipse.e4.xwt.databinding.EventListener;
import org.eclipse.e4.xwt.databinding.EventManager;
import org.eclipse.jface.util.Util;

public abstract class XWTObservableValue
extends AbstractObservableValue
implements IObserving {
    public static final String VALUE_CHANGED_EVENT = "EVENT_NODE_VALUE_CHANGED";
    private Object observed;
    private Object valueType;
    private EventManager eventManager;
    private EventListener eventListener;
    private boolean updating = false;

    public XWTObservableValue(Object valueType, Object observed) {
        super(XWT.getRealm());
        this.valueType = valueType;
        this.observed = observed;
        this.init();
    }

    private void init() {
        if (this.eventListener == null) {
            this.eventListener = new EventListener(){

                public void handleEvent(Event evt) {
                    if (!XWTObservableValue.this.updating) {
                        final ValueDiff diff = Diffs.createValueDiff((Object)evt.getOldValue(), (Object)evt.getNewValue());
                        XWTObservableValue.this.getRealm().exec(new Runnable(){

                            public void run() {
                                XWTObservableValue.this.fireValueChange(diff);
                            }
                        });
                    }
                }
            };
        }
        this.eventManager = EventManager.getEventManager(this.observed, this.getRealm());
        this.eventManager.addEventListener(VALUE_CHANGED_EVENT, this.eventListener);
    }

    public Object getObserved() {
        return this.observed;
    }

    protected void doSetValue(Object value) {
        Object oldValue;
        this.updating = true;
        value = this.convert((oldValue = this.doGetValue()) == null ? null : oldValue.getClass(), value);
        if (!Util.equals((Object)oldValue, (Object)value)) {
            this.doSetApprovedValue(value);
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
            this.eventManager.dispatchEvent(new Event(this.observed, oldValue, value, VALUE_CHANGED_EVENT));
        }
        this.updating = false;
    }

    protected Object convert(Class type, Object value) {
        if (value != null) {
            if (type != null && type.isEnum() && value instanceof String) {
                return Enum.valueOf(type, (String)value);
            }
            IConverter c = XWT.findConvertor(value.getClass(), (Class)this.getValueType());
            if (c != null) {
                return c.convert(value);
            }
        }
        return value;
    }

    protected abstract void doSetApprovedValue(Object var1);

    protected Object doGetValue() {
        return this.observed;
    }

    public Object getValueType() {
        return this.valueType;
    }
}

