/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.dataproviders;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IBindingContext;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.databinding.BeanObservableValue;
import org.eclipse.e4.xwt.databinding.BeanObservableValueUtil;
import org.eclipse.e4.xwt.databinding.ObjectBindingContext;
import org.eclipse.e4.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.e4.xwt.dataproviders.IObjectDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDataProvider
extends AbstractDataProvider
implements IObjectDataProvider {
    private Object objectInstance;
    private Class<?> objectType;
    private String methodName;
    private List<Object> methodParameters;
    private ObjectBindingContext bindingContext = new ObjectBindingContext();

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<Object> getMethodParameters() {
        return this.methodParameters;
    }

    @Override
    public Object getObjectInstance() {
        if (this.objectInstance == null && this.objectType != null) {
            try {
                this.objectInstance = this.objectType.newInstance();
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
        return this.objectInstance;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.objectType == null && this.objectInstance != null) {
            this.objectType = this.objectInstance.getClass();
        }
        return this.objectType;
    }

    @Override
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void setMethodParameters(List<Object> parameters) {
        this.methodParameters = parameters;
    }

    @Override
    public void setObjectInstance(Object objectImstance) {
        this.objectInstance = objectImstance;
    }

    @Override
    public void setObjectType(Class<?> objectType) {
        this.objectType = objectType;
    }

    protected Object getTarget() {
        Object target = this.getObjectInstance();
        if (target == null) {
            return null;
        }
        Class<?> targetType = this.getObjectType();
        Method method = null;
        if (this.methodName != null) {
            ArrayList paras = new ArrayList();
            if (this.methodParameters != null) {
                for (Object p : this.methodParameters) {
                    paras.add(p.getClass());
                }
            }
            try {
                if (paras.isEmpty()) {
                    method = targetType.getDeclaredMethod(this.methodName, new Class[0]);
                    return method.invoke(target, new Object[0]);
                }
                method = targetType.getDeclaredMethod(this.methodName, paras.toArray(new Class[paras.size()]));
                return method.invoke(target, this.methodParameters.toArray(new Object[this.methodParameters.size()]));
            }
            catch (Exception exception) {}
        }
        return target;
    }

    @Override
    public Object getData(String path) {
        return this.getData(this.getTarget(), path);
    }

    @Override
    public Object getData(Object object, String path) {
        if (object instanceof IObservableValue) {
            object = ((IObservableValue)object).getValue();
        }
        int index = path.indexOf(".");
        while (index != -1 && object != null) {
            object = BeanObservableValue.getValue(object, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return BeanObservableValue.getValue(object, path);
    }

    @Override
    public void setData(Object object, String path, Object value) {
        if (object instanceof IObservableValue) {
            object = ((IObservableValue)object).getValue();
        }
        int index = path.indexOf(".");
        while (index != -1 && object != null) {
            object = BeanObservableValue.getValue(object, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        BeanObservableValue.setValue(object, path, value);
    }

    @Override
    public void setData(String path, Object value) {
        this.setData(this.getTarget(), path, value);
    }

    @Override
    public Class<?> getDataType(String path) {
        Object target = this.getTarget();
        if (target == null) {
            return null;
        }
        Class<?> type = target.getClass();
        if (path == null) {
            return type;
        }
        int index = path.indexOf(".");
        while (index != -1 && target != null) {
            type = BeanObservableValue.getValueType(type, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return BeanObservableValue.getValueType(type, path);
    }

    @Override
    public boolean isPropertyReadOnly(String path) {
        Object target = this.getTarget();
        if (target == null) {
            return true;
        }
        Class<?> type = target.getClass();
        if (path == null) {
            return true;
        }
        int index = path.indexOf(".");
        while (index != -1 && target != null) {
            type = BeanObservableValue.getValueType(type, path.substring(0, index));
            path = path.substring(index + 1);
            index = path.indexOf(".");
        }
        return BeanObservableValue.isPropertyReadOnly(type, path);
    }

    @Override
    public IObservableValue createObservableValue(Object valueType, String fullPath) {
        Object dataContext = this.getTarget();
        String propertyName = null;
        String[] paths = fullPath.trim().split("\\.");
        if (paths.length > 1) {
            int i = 0;
            while (i < paths.length - 1) {
                String path = paths[i];
                if (dataContext != null) {
                    this.bindingContext.addObservable(dataContext);
                    dataContext = BeanObservableValue.getValue(dataContext, path);
                }
                ++i;
            }
            propertyName = paths[paths.length - 1];
        } else if (paths.length == 1) {
            propertyName = fullPath;
        }
        return BeanObservableValueUtil.observeValue(dataContext, propertyName);
    }

    @Override
    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }
}

