/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.core.IElementLoaderFactory;
import org.eclipse.e4.xwt.core.IRenderingContext;
import org.eclipse.e4.xwt.core.IVisualElementLoader;
import org.eclipse.e4.xwt.internal.core.MetaclassManager;
import org.eclipse.e4.xwt.internal.core.MetaclassService;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.DocumentRoot;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.internal.xml.ElementManager;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Core {
    public static final String DEFAULT_STYLES_KEY = "XWT.DefaultStyles";
    public static boolean TRACE_BENCH = false;
    private HashMap<Class<?>, Object> registrations;
    private HashMap<DocumentObject, IVisualElementLoader> elementsLoaders = new HashMap();
    MetaclassService metaclassService;
    IElementLoaderFactory loaderFactory;
    private IXWTLoader xwtLoader;
    public static ILogger nullLog = new ILogger(){
        private Map<Tracking, String> messageMap = new HashMap<Tracking, String>();

        public void error(Throwable e) {
        }

        public void error(Throwable e, String message) {
        }

        public void message(String message) {
        }

        public void warning(String message) {
        }

        public void printInfo(String message, Tracking tracking, Set trackType) {
            String printMessage = "";
            if (trackType != null && trackType.size() > 0 && trackType.contains((Object)tracking)) {
                printMessage = this.messageMap.get((Object)tracking);
            }
            System.out.println(printMessage);
        }

        public void addMessage(String message, Tracking tracking) {
            if (this.messageMap.containsKey((Object)tracking)) {
                this.messageMap.remove((Object)tracking);
            }
            this.messageMap.put(tracking, message);
        }

        public void removeMessage(Tracking tracking) {
            if (this.messageMap.containsKey((Object)tracking)) {
                this.messageMap.remove((Object)tracking);
            }
        }
    };

    public Core(IElementLoaderFactory loaderFactory, IXWTLoader xwtLoader) {
        this.loaderFactory = loaderFactory;
        this.registrations = new HashMap();
        this.xwtLoader = xwtLoader;
        this.metaclassService = new MetaclassService(xwtLoader);
    }

    public IMetaclass getMetaclass(ILoadingContext context, String name, String namespace) {
        return this.getMetaclassService().getMetaclass(context, name, namespace);
    }

    public IMetaclass getMetaclass(Object object) {
        if (object instanceof Class) {
            return this.getMetaclassService().getMetaclass((Class)object);
        }
        return this.getMetaclassService().getMetaclass(object.getClass());
    }

    public IMetaclass getMetaclass(Object object, String namespace) {
        if (object instanceof Class) {
            return this.getMetaclassService().getMetaclass((Class)object, namespace);
        }
        return this.getMetaclassService().getMetaclass(object.getClass(), namespace);
    }

    public Collection<IMetaclass> getAllMetaclasses(String namespace) {
        return this.getMetaclassService().getAllMetaclasses(namespace);
    }

    public void registerMetaclass(IMetaclass metaclass, String namespace) {
        this.getMetaclassService().register(metaclass, namespace);
    }

    public void registerMetaclassFactory(IMetaclassFactory metaclassFactory) {
        this.getMetaclassService().registerFactory(metaclassFactory);
    }

    public IMetaclass registerMetaclass(Class<?> metaclass, String namespace) {
        return this.getMetaclassService().register(metaclass, namespace);
    }

    public void registerMetaclassManager(String namespace, MetaclassManager manager) {
        this.getMetaclassService().register(namespace, manager);
    }

    public Object getService(Class<?> type) {
        return this.registrations.get(type);
    }

    public void registerService(Class<?> serviceType, Object service) {
        this.registrations.put(serviceType, service);
    }

    protected Object createCLRElement(IRenderingContext context, Element element, Map<String, Object> options) {
        IVisualElementLoader loader = this.findElementLoader(element);
        if (loader != null) {
            return loader.createCLRElement(element, options);
        }
        loader = this.createElementLoader(context, element);
        Object visualObject = loader.createCLRElement(element, options);
        this.removeElementLoader(element);
        return visualObject;
    }

    protected IVisualElementLoader findElementLoader(DocumentObject element) {
        IVisualElementLoader loader = this.elementsLoaders.get(element);
        if (loader != null) {
            return loader;
        }
        if (element.getParent() != null) {
            return this.findElementLoader(element.getParent());
        }
        return null;
    }

    protected IVisualElementLoader createElementLoader(IRenderingContext context, DocumentObject element) {
        IVisualElementLoader creator = this.loaderFactory.createElementLoader(context, this.xwtLoader);
        this.elementsLoaders.put(element, creator);
        return creator;
    }

    protected void removeElementLoader(DocumentObject element) {
        this.elementsLoaders.remove(element);
    }

    public Control load(ILoadingContext loadingContext, URL input, Map<String, Object> options) throws Exception {
        return this.load(loadingContext, null, input, options);
    }

    public Control load(ILoadingContext loadingContext, InputStream stream, URL input, Map<String, Object> options) throws Exception {
        long start = System.currentTimeMillis();
        Control control = null;
        ElementManager manager = new ElementManager();
        if (input != null) {
            Element element = stream == null ? manager.load(input) : manager.load(stream, input);
            ExtensionContext context = new ExtensionContext(loadingContext, manager, manager.getRootElement().getNamespace());
            Object visual = this.createCLRElement(context, element, options);
            if (TRACE_BENCH) {
                System.out.println("Loaded: " + (System.currentTimeMillis() - start) + "  " + input.toString());
            }
            if (visual instanceof Control) {
                control = (Control)visual;
            } else if (visual instanceof Viewer) {
                control = ((Viewer)visual).getControl();
            } else {
                Class<?> jfaceWindow = Class.forName("org.eclipse.jface.window.Window");
                if (jfaceWindow != null && jfaceWindow.isInstance(visual)) {
                    Method createMethod = jfaceWindow.getDeclaredMethod("create", new Class[0]);
                    createMethod.invoke(visual, new Object[0]);
                    Method method = jfaceWindow.getDeclaredMethod("getShell", new Class[0]);
                    control = (Control)method.invoke(visual, new Object[0]);
                }
            }
            if (control instanceof Composite) {
                Object parent = options.get("XWT.Container");
                Object designMode = options.get("XWT.DesignMode");
                if (parent instanceof Composite) {
                    Composite parentComposite = (Composite)parent;
                    if (parentComposite.getLayout() == null || designMode == Boolean.TRUE) {
                        this.autoLayout(parentComposite, element);
                    }
                } else if (parent == null || designMode == Boolean.TRUE) {
                    if (control instanceof Shell) {
                        this.autoLayout((Composite)((Shell)control), element);
                    } else {
                        this.autoLayout((Composite)control.getShell(), element);
                    }
                }
            }
        }
        return control;
    }

    protected void autoLayout(Composite composite, Element element) {
        Attribute size;
        if (element == null) {
            return;
        }
        Attribute bounds = element.getAttribute("bounds");
        if (bounds == null) {
            bounds = element.getAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
        }
        if ((size = element.getAttribute("size")) == null) {
            size = element.getAttribute("size", "http://www.eclipse.org/xwt/presentation");
        }
        if (bounds == null && size == null) {
            composite.pack();
        }
    }

    public MetaclassService getMetaclassService() {
        return this.metaclassService;
    }

    private class ExtensionContext
    implements IRenderingContext {
        private Map<String, Object> properties = new HashMap<String, Object>();
        private URL resourcePath;
        private DocumentRoot documentRoot;
        private String namespace;
        private String encoding;
        protected ILoadingContext loadingContext;

        public ExtensionContext(ILoadingContext loadingContext, ElementManager elementManager, String namespace) {
            this.documentRoot = elementManager.getDocumentRoot();
            this.resourcePath = this.documentRoot.getPath();
            this.namespace = namespace;
            this.loadingContext = loadingContext;
            this.encoding = elementManager.getEncoding();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public InputStream openStream(String path) throws IOException {
            return this.documentRoot.openStream(path);
        }

        public URL getResourcePath() {
            return this.resourcePath;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public ILoadingContext getLoadingContext() {
            return this.loadingContext;
        }
    }
}

