/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.javabean.metadata.Binding;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.swt.widgets.Widget;

public class DataBindingTrack {
    private String bindingError = "";
    private Set<String> errorElements = null;
    private List<Element> widgetList = new ArrayList<Element>();
    private Map<Element, String> bindingMap;

    public DataBindingTrack() {
        this.errorElements = new HashSet<String>();
        this.bindingMap = new HashMap<Element, String>();
    }

    public void addWidgetElement(Element element) {
        this.widgetList.add(element);
    }

    private void addErrorWidgetId(String elementId) {
        this.errorElements.add(elementId);
    }

    private void addBindingMessageToMap(Element element, String bindingMessage) {
        this.bindingMap.put(element, bindingMessage);
    }

    private int validateParentElementError(Element bindingElement) {
        int isError = 0;
        if (!this.bindingError.equals("")) {
            DocumentObject parentObj = bindingElement.getParent();
            while (parentObj != null) {
                bindingElement = (Element)parentObj;
                if (this.errorElements.contains(bindingElement.getId())) {
                    isError = 1;
                    break;
                }
                parentObj = bindingElement.getParent();
            }
        }
        return isError;
    }

    private String getCurrentWidgetPosition(Element element) {
        if (element.getParent() != null) {
            return " " + this.getCurrentWidgetPosition((Element)element.getParent());
        }
        return "";
    }

    public String getDataBindMessage() {
        StringBuffer message = new StringBuffer("");
        Iterator<Element> widgetIt = this.widgetList.iterator();
        Set<Element> keys = this.bindingMap.keySet();
        while (widgetIt.hasNext()) {
            Element element = widgetIt.next();
            int parentHasError = this.validateParentElementError(element);
            if (parentHasError != 0) continue;
            String content = this.getCurrentWidgetPosition(element);
            if (!message.toString().equals("")) {
                content = String.valueOf(content) + "+ ";
            }
            content = String.valueOf(content) + element.getName();
            if (XWT.isTracking(Tracking.NAME)) {
                Attribute nameAttr = element.getAttribute("Name");
                if (nameAttr == null) {
                    nameAttr = element.getAttribute("http://www.eclipse.org/xwt", "Name");
                }
                if (nameAttr != null) {
                    content = String.valueOf(content) + " <" + nameAttr.getContent() + ">";
                }
            }
            message.append(content);
            if (!XWT.isTracking(Tracking.DATABINDING)) continue;
            if (keys.contains(element)) {
                message.append(this.bindingMap.get(element));
                continue;
            }
            message.append("\n");
        }
        return message.toString();
    }

    private void setBindingErrorMessage(String bindingError) {
        this.bindingError = bindingError;
    }

    public void tracking(Object swtObject, Element element, Object dataContext) {
        String bindingMessage = "";
        if (swtObject instanceof Binding) {
            String error = "";
            Binding newInstance = (Binding)swtObject;
            String path = null;
            Attribute attr = element.getAttribute("Path");
            if (attr == null) {
                attr = element.getAttribute("path");
            }
            if (attr != null) {
                path = attr.getContent();
            }
            Object dataContext2 = null;
            try {
                String[] paths;
                dataContext2 = newInstance.getValue();
                if (path != null && path.length() > 0 && (paths = path.trim().split("\\.")).length > 1) {
                    String path1 = "";
                    int i = 0;
                    while (i < paths.length - 1) {
                        path1 = paths[i];
                        if (dataContext2 != null) {
                            dataContext2 = DataBindingTrack.getObserveData(dataContext2, path1);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                this.addErrorWidgetId(element.getParent().getParent().getId());
                this.setBindingErrorMessage("-> Error");
                error = "-> Error";
            }
            if (dataContext2 != null) {
                bindingMessage = " (DataContext=" + dataContext2.getClass().getSimpleName() + ", Path=" + path + ")" + error + "\n";
                this.addBindingMessageToMap((Element)element.getParent().getParent(), bindingMessage);
            }
        } else if (swtObject instanceof Widget) {
            this.addWidgetElement(element);
            if (dataContext != null) {
                bindingMessage = " (DataContext=" + dataContext.getClass().getSimpleName() + ")\n";
                this.addBindingMessageToMap(element, bindingMessage);
            }
        } else if (JFacesHelper.isViewer(swtObject)) {
            if (dataContext != null) {
                bindingMessage = " (DataContext=" + dataContext.getClass().getSimpleName() + ")\n";
                this.addBindingMessageToMap(element, bindingMessage);
            }
        } else if (element.attributeNames("http://www.eclipse.org/xwt").length > 0 && element.getParent() != null && element.getParent().getParent() != null) {
            bindingMessage = " (DataContext=" + element.getName() + ")\n";
            this.addBindingMessageToMap((Element)element.getParent().getParent(), bindingMessage);
        }
    }

    public static Object getObserveData(Object dataContext, String path) {
        try {
            Class<?> dataContextClass = dataContext.getClass();
            Method getMethod = ObjectUtil.findGetter(dataContextClass, path, null);
            if (getMethod != null) {
                return getMethod.invoke(dataContext, new Object[0]);
            }
        }
        catch (SecurityException e) {
            LoggerManager.log(e);
        }
        catch (IllegalArgumentException e) {
            LoggerManager.log(e);
        }
        catch (IllegalAccessException e) {
            LoggerManager.log(e);
        }
        catch (InvocationTargetException e) {
            LoggerManager.log(e);
        }
        return null;
    }
}

