/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.internal.core.MetaclassManager;
import org.eclipse.e4.xwt.metadata.IMetaclass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassService {
    protected Map<String, MetaclassManager> map = new HashMap<String, MetaclassManager>();
    protected ArrayList<IMetaclassFactory> factories = new ArrayList();
    private IXWTLoader xwtLoader;

    public MetaclassService(IXWTLoader xwtLoader) {
        this.xwtLoader = xwtLoader;
    }

    public IMetaclass getMetaclass(ILoadingContext context, String name, String namespace) {
        MetaclassManager manager = this.map.get(namespace);
        if (manager == null) {
            manager = new MetaclassManager(this, this.map.get("http://www.eclipse.org/xwt/presentation"), this.xwtLoader);
            this.map.put(namespace, manager);
        }
        return manager.getMetaclass(context, name, namespace);
    }

    public IMetaclass getMetaclass(Class<?> type) {
        MetaclassManager manager = this.map.get("http://www.eclipse.org/xwt/presentation");
        if (manager == null) {
            return null;
        }
        IMetaclass metaclass = manager.getMetaclass(type);
        if (metaclass == null) {
            String key;
            MetaclassManager childManager;
            String packageName = "";
            Package packageObject = type.getPackage();
            if (packageObject != null) {
                packageName = packageObject.getName();
            }
            if ((childManager = this.map.get(key = "clr-namespace::" + packageName)) == null) {
                childManager = new MetaclassManager(this, manager, this.xwtLoader);
                this.map.put(key, childManager);
            }
            if ((metaclass = childManager.getMetaclass(type)) == null) {
                childManager.register(type);
                metaclass = childManager.getMetaclass(type);
            }
        }
        return metaclass;
    }

    public IMetaclass getMetaclass(Class<?> type, String namepsace) {
        IMetaclass metaclass;
        MetaclassManager manager = this.map.get(namepsace);
        if (manager == null) {
            manager = new MetaclassManager(this, manager, this.xwtLoader);
            this.map.put(namepsace, manager);
        }
        if ((metaclass = manager.getMetaclass(type)) == null && (metaclass = manager.getMetaclass(type)) == null) {
            manager.register(type);
            metaclass = manager.getMetaclass(type);
        }
        return metaclass;
    }

    public IMetaclass register(Class<?> metaclass, String namespace) {
        MetaclassManager manager = this.map.get(namespace);
        if (manager == null) {
            throw new IllegalStateException();
        }
        return manager.register(metaclass);
    }

    public void register(IMetaclass metaclass, String namespace) {
        MetaclassManager manager = this.map.get(namespace);
        if (manager == null) {
            throw new IllegalStateException();
        }
        manager.register(metaclass);
    }

    public Collection<IMetaclass> getAllMetaclasses(String namespace) {
        MetaclassManager manager = this.map.get(namespace);
        if (manager == null) {
            throw new IllegalStateException();
        }
        return manager.getAllMetaclasses();
    }

    public void register(String namespace, MetaclassManager manager) {
        this.map.put(namespace, manager);
    }

    public void registerFactory(IMetaclassFactory metaclassFactory) {
        this.factories.add(metaclassFactory);
    }

    public IMetaclassFactory findFactory(Class<?> javaClass) {
        int i = this.factories.size() - 1;
        while (i >= 0) {
            IMetaclassFactory factory = this.factories.get(i);
            if (factory.isFactoryOf(javaClass)) {
                return factory;
            }
            --i;
        }
        return null;
    }
}

