/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends DocumentObject {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static String[] EMPTY = new String[0];
    private Map<String, Attribute> originalAttributes;
    private Map<String, Map<String, Attribute>> externalAttributes;
    private String[] xmlnsMapping;

    public String getXmlns(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.xmlnsMapping != null) {
            int i = 0;
            while (i < this.xmlnsMapping.length) {
                if (prefix.equals(this.xmlnsMapping[i++])) {
                    return this.xmlnsMapping[i];
                }
                ++i;
            }
        }
        return null;
    }

    public Element(String namespace, String name, Map<String, String> xmlnsMapping) {
        this(namespace, name, null, xmlnsMapping);
    }

    public Element(String namespace, String name, Collection<Attribute> attributes, Map<String, String> xmlnsMapping) {
        super(namespace, name);
        if (xmlnsMapping != null) {
            this.xmlnsMapping = new String[xmlnsMapping.size() * 2];
            int i = 0;
            for (String key : xmlnsMapping.keySet()) {
                if (key == null) {
                    key = "";
                }
                this.xmlnsMapping[i++] = key;
                this.xmlnsMapping[i++] = xmlnsMapping.get(key);
            }
        }
        this.originalAttributes = Collections.EMPTY_MAP;
        this.externalAttributes = Collections.EMPTY_MAP;
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                this.setInternalAttribute(attribute);
            }
        }
    }

    public String[] attributeNames() {
        return this.originalAttributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] attributeNamespaces() {
        return this.externalAttributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public void setAttribute(Attribute attribute) {
        this.setInternalAttribute(attribute);
        this.firePropertyChanged(attribute);
    }

    public String[] attributeNames(String namespace) {
        if (this.getNamespace().equals(namespace)) {
            return this.attributeNames();
        }
        Map<String, Attribute> externalAttribute = this.externalAttributes.get(namespace);
        if (externalAttribute != null) {
            return externalAttribute.keySet().toArray(EMPTY_STRING_ARRAY);
        }
        return EMPTY;
    }

    public Attribute getAttribute(String name) {
        assert (name == null);
        return this.originalAttributes.get(name);
    }

    public Attribute getAttribute(String namespace, String name) {
        Map<String, Attribute> externalAttribute = this.externalAttributes.get(namespace);
        if (externalAttribute != null) {
            return externalAttribute.get(name);
        }
        return null;
    }

    @Override
    public Object clone() {
        Element element = (Element)super.clone();
        element.parent = null;
        if (this.originalAttributes.isEmpty()) {
            this.originalAttributes = Collections.EMPTY_MAP;
        } else {
            element.originalAttributes = new LinkedHashMap<String, Attribute>(this.originalAttributes.size());
            for (String attrName : this.originalAttributes.keySet()) {
                Attribute attrValue = (Attribute)this.originalAttributes.get(attrName).clone();
                element.originalAttributes.put(attrName, attrValue);
            }
        }
        if (this.externalAttributes.isEmpty()) {
            element.originalAttributes = Collections.EMPTY_MAP;
        } else {
            element.externalAttributes = new LinkedHashMap<String, Map<String, Attribute>>(this.externalAttributes.size());
            for (String ns : this.externalAttributes.keySet()) {
                Map<String, Attribute> oAttributes = this.externalAttributes.get(ns);
                LinkedHashMap<String, Attribute> nAttributes = new LinkedHashMap<String, Attribute>(oAttributes.size());
                for (String attrName : oAttributes.keySet()) {
                    Attribute attrValue = (Attribute)oAttributes.get(attrName).clone();
                    nAttributes.put(attrName, attrValue);
                }
                element.externalAttributes.put(ns, nAttributes);
            }
        }
        return element;
    }

    protected void setAttributes(Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.setInternalAttribute(attribute);
        }
        this.firePropertyChanged(attributes);
    }

    private void firePropertyChanged(Attribute attribute) {
        this.notifyObservers(attribute);
    }

    private void firePropertyChanged(Collection<Attribute> attributes) {
        this.notifyObservers(attributes);
    }

    protected boolean isXWTNamespace(String namespace) {
        String scopeNamespace = this.getNamespace();
        if (namespace == null || "".equals(namespace)) {
            return true;
        }
        if (scopeNamespace.startsWith("clr-namespace:") || scopeNamespace.equals("http://www.eclipse.org/xwt/presentation")) {
            return namespace.equalsIgnoreCase(scopeNamespace) || namespace.equals("http://www.eclipse.org/xwt/presentation");
        }
        return false;
    }

    private void setInternalAttribute(Attribute attribute) {
        assert (attribute != null);
        String namespace = attribute.getNamespace();
        String name = attribute.getName();
        if (this.isXWTNamespace(namespace)) {
            if (this.originalAttributes == Collections.EMPTY_MAP) {
                this.originalAttributes = new LinkedHashMap<String, Attribute>();
            }
            this.originalAttributes.put(name, attribute);
        } else {
            Map<String, Attribute> externalAttribute = this.externalAttributes.get(namespace);
            if (externalAttribute == null) {
                externalAttribute = new HashMap<String, Attribute>();
            }
            if (this.externalAttributes == Collections.EMPTY_MAP) {
                this.externalAttributes = new LinkedHashMap<String, Map<String, Attribute>>();
            }
            externalAttribute.put(name, attribute);
            this.externalAttributes.put(namespace, externalAttribute);
        }
        attribute.setParent(this);
    }
}

